/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util;

import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.util.Email$callable$deliver;
import org.fenixedu.academic.domain.util.EmailAddressList;
import org.fenixedu.academic.domain.util.Email_Base;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Email
extends Email_Base {
    private static final Logger LOG;
    private static Session SESSION;
    private static int MAX_MAIL_RECIPIENTS;
    private static DateTimeFormatter rfc5322Fmt;
    public static final Advice advice$deliver;

    private static synchronized Session init() {
        Properties properties = new Properties();
        properties.put("mail.smtp.host", FenixEduAcademicConfiguration.getConfiguration().getMailSmtpHost());
        properties.put("mail.smtp.name", FenixEduAcademicConfiguration.getConfiguration().getMailSmtpName());
        properties.put("mailSender.max.recipients", FenixEduAcademicConfiguration.getConfiguration().getMailSenderMaxRecipients());
        properties.put("mail.debug", "false");
        Session tempSession = Session.getDefaultInstance((Properties)properties, null);
        MAX_MAIL_RECIPIENTS = Integer.parseInt(properties.getProperty("mailSender.max.recipients"));
        SESSION = tempSession;
        LOG.debug("Initialize mail properties");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            LOG.debug("\t{}={}", entry.getKey(), entry.getValue());
        }
        return SESSION;
    }

    private Email() {
        this.setRootDomainObjectFromEmailQueue(Bennu.getInstance());
    }

    public Email(String[] replyTos, Collection<String> toAddresses, Collection<String> ccAddresses, Collection<String> bccAddresses, Message message) {
        this();
        this.setReplyTos(new EmailAddressList(replyTos == null ? null : Arrays.asList(replyTos)));
        this.setToAddresses(new EmailAddressList(toAddresses));
        this.setCcAddresses(new EmailAddressList(ccAddresses));
        this.setBccAddresses(new EmailAddressList(bccAddresses));
        this.setMessage(message);
    }

    public String getBody() {
        return this.getMessage().getBody();
    }

    public String getSubject() {
        return this.getMessage().getSubject();
    }

    public String getHtmlBody() {
        return this.getMessage().getHtmlBody();
    }

    public void delete() {
        this.setMessage(null);
        this.setRootDomainObjectFromEmailQueue(null);
        super.deleteDomainObject();
    }

    public String[] replyTos() {
        return this.getReplyTos() == null ? null : this.getReplyTos().toArray();
    }

    public Collection<String> toAddresses() {
        return this.getToAddresses() == null ? null : this.getToAddresses().toCollection();
    }

    public Collection<String> ccAddresses() {
        return this.getCcAddresses() == null ? null : this.getCcAddresses().toCollection();
    }

    public Collection<String> bccAddresses() {
        return this.getBccAddresses() == null ? null : this.getBccAddresses().toCollection();
    }

    private void logProblem(String description) {
        LOG.warn("Sending of email {} failed. Description: {}", (Object)this.getExternalId(), (Object)description);
    }

    private void logProblem(MessagingException e) {
        this.logProblem(e.getMessage());
        Exception nextException = e.getNextException();
        if (nextException != null) {
            if (nextException instanceof MessagingException) {
                this.logProblem((MessagingException)((Object)nextException));
            } else {
                this.logProblem(nextException.getMessage());
            }
        }
    }

    private void abort() {
        EmailAddressList bccAddresses;
        EmailAddressList ccAddresses;
        EmailAddressList toAddresses;
        HashSet<String> failed = new HashSet<String>();
        EmailAddressList failedAddresses = this.getFailedAddresses();
        if (failedAddresses != null && !failedAddresses.isEmpty()) {
            failed.addAll(failedAddresses.toCollection());
        }
        if ((toAddresses = this.getToAddresses()) != null && !toAddresses.isEmpty()) {
            failed.addAll(toAddresses.toCollection());
        }
        if ((ccAddresses = this.getCcAddresses()) != null && !ccAddresses.isEmpty()) {
            failed.addAll(ccAddresses.toCollection());
        }
        if ((bccAddresses = this.getBccAddresses()) != null && !bccAddresses.isEmpty()) {
            failed.addAll(bccAddresses.toCollection());
        }
        EmailAddressList emailAddressList = new EmailAddressList(failed);
        this.setFailedAddresses(emailAddressList);
        this.setToAddresses(null);
        this.setCcAddresses(null);
        this.setBccAddresses(null);
    }

    private void retry(EmailAddressList toAddresses, EmailAddressList ccAddresses, EmailAddressList bccAddresses) {
        this.setToAddresses(toAddresses);
        this.setCcAddresses(ccAddresses);
        this.setBccAddresses(bccAddresses);
    }

    private static String encode(String string) {
        try {
            return string == null ? "" : MimeUtility.encodeText((String)string);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            return string;
        }
    }

    protected static String constructFromString(String fromName, String fromAddress) {
        return fromName == null || fromName.length() == 0 ? fromAddress : fromName.replace(',', ' ') + " <" + fromAddress + ">";
    }

    private void setConfirmedAddresses(Address[] recipients) {
        HashSet<String> addresses = new HashSet<String>();
        EmailAddressList confirmedAddresses = this.getConfirmedAddresses();
        if (confirmedAddresses != null && !confirmedAddresses.isEmpty()) {
            addresses.addAll(confirmedAddresses.toCollection());
        }
        if (recipients != null) {
            for (Address address : recipients) {
                addresses.add(address.toString());
            }
        }
        this.setConfirmedAddresses(new EmailAddressList(addresses));
    }

    private void setFailedAddresses(Address[] recipients) {
        HashSet<String> addresses = new HashSet<String>();
        EmailAddressList failedAddresses = this.getFailedAddresses();
        if (failedAddresses != null && !failedAddresses.isEmpty()) {
            addresses.addAll(failedAddresses.toCollection());
        }
        if (recipients != null) {
            for (Address address : recipients) {
                addresses.add(address.toString());
            }
        }
        this.setFailedAddresses(new EmailAddressList(addresses));
    }

    private void resend(Address[] recipients) {
        if (recipients != null && recipients.length > 0) {
            for (Address address : recipients) {
                String[] replyTos = this.getReplyTos() == null ? null : this.getReplyTos().toArray();
                new Email(replyTos, Collections.emptySet(), Collections.emptySet(), Collections.singleton(address.toString()), this.getMessage());
            }
        }
    }

    public void deliver() {
        Object object = advice$deliver.perform((Callable)new Email$callable$deliver(this));
    }

    static /* synthetic */ void advised$deliver(Email this_) {
        if (!this_.hasAnyRecipients() || this_.getMessage() != null && this_.getMessage().getCreated().plusDays(5).isBeforeNow()) {
            this_.setRootDomainObjectFromEmailQueue(null);
        } else {
            EmailAddressList toAddresses = this_.getToAddresses();
            EmailAddressList ccAddresses = this_.getCcAddresses();
            EmailAddressList bccAddresses = this_.getBccAddresses();
            EmailMimeMessage emailMimeMessage = this_.new EmailMimeMessage();
            try {
                emailMimeMessage.send(this_);
            }
            catch (SendFailedException e) {
                this_.logProblem((MessagingException)((Object)e));
                Address[] invalidAddresses = e.getInvalidAddresses();
                this_.setFailedAddresses(invalidAddresses);
                Address[] validSentAddresses = e.getValidSentAddresses();
                this_.setConfirmedAddresses(validSentAddresses);
                Address[] validUnsentAddresses = e.getValidUnsentAddresses();
                this_.resend(validUnsentAddresses);
            }
            catch (MessagingException e) {
                this_.logProblem(e);
                this_.retry(toAddresses, ccAddresses, bccAddresses);
            }
            if (!this_.hasAnyRecipients()) {
                this_.setRootDomainObjectFromEmailQueue(null);
            }
        }
    }

    private boolean hasAnyRecipients() {
        return this.hasAnyRecipients(this.getToAddresses()) || this.hasAnyRecipients(this.getCcAddresses()) || this.hasAnyRecipients(this.getBccAddresses());
    }

    private boolean hasAnyRecipients(EmailAddressList emailAddressList) {
        return emailAddressList != null && !emailAddressList.isEmpty();
    }

    static {
        advice$deliver = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        LOG = LoggerFactory.getLogger(Email.class);
        SESSION = null;
        rfc5322Fmt = DateTimeFormat.forPattern((String)"EEE, dd MMM yyyy HH:mm:ss Z").withLocale(Locale.ENGLISH);
    }

    private class EmailMimeMessage
    extends MimeMessage {
        private String fenixMessageId;

        public EmailMimeMessage() {
            super(SESSION == null ? Email.init() : SESSION);
            this.fenixMessageId = null;
        }

        public String getMessageID() throws MessagingException {
            if (this.fenixMessageId == null) {
                String externalId = Email.this.getExternalId();
                this.fenixMessageId = externalId + "." + new DateTime().getMillis() + "@fenix";
            }
            return this.fenixMessageId;
        }

        protected void updateMessageID() throws MessagingException {
            this.setHeader("Message-ID", this.getMessageID());
            this.setHeader("Date", rfc5322Fmt.print((ReadableInstant)Email.this.getMessage().getCreated()));
        }

        public void send(Email email) throws MessagingException {
            MimeBodyPart bodyPart;
            if (email.getMessage().getSender().getFromName() == null) {
                Email.this.logProblem("error.from.address.cannot.be.null");
                Email.this.abort();
                return;
            }
            String from = Email.constructFromString(Email.encode(email.getMessage().getFromName()), email.getMessage().getFromAddress());
            String[] replyTos = email.replyTos();
            Address[] replyToAddresses = new Address[replyTos == null ? 0 : replyTos.length];
            if (replyTos != null) {
                for (int i = 0; i < replyTos.length; ++i) {
                    try {
                        replyToAddresses[i] = new InternetAddress(Email.encode(replyTos[i]));
                        continue;
                    }
                    catch (AddressException e) {
                        Email.this.logProblem("invalid.reply.to.address: " + replyTos[i]);
                        Email.this.abort();
                        return;
                    }
                }
            }
            this.setFrom((Address)new InternetAddress(from));
            this.setSubject(Email.encode(email.getSubject()));
            this.setReplyTo(replyToAddresses);
            String body = email.getBody();
            String htmlBody = Email.this.getHtmlBody();
            MimeMultipart mimeMultipart = this.createMimeMultipart(body, htmlBody);
            if (body != null && !body.trim().isEmpty()) {
                bodyPart = new MimeBodyPart();
                bodyPart.setText(body);
                mimeMultipart.addBodyPart((BodyPart)bodyPart);
            }
            if (htmlBody != null && !htmlBody.trim().isEmpty()) {
                bodyPart = new MimeBodyPart();
                bodyPart.setContent((Object)htmlBody, "text/html; charset=utf-8");
                mimeMultipart.addBodyPart((BodyPart)bodyPart);
            }
            this.setContent((Multipart)mimeMultipart);
            this.addRecipientsAux();
            LOG.info("Sending email {} with message id {}", (Object)email.getExternalId(), (Object)this.getMessageID());
            Transport.send((javax.mail.Message)this);
            Address[] allRecipients = this.getAllRecipients();
            Email.this.setConfirmedAddresses(allRecipients);
        }

        private MimeMultipart createMimeMultipart(String body, String htmlBody) {
            return body != null && !body.trim().isEmpty() && htmlBody != null && !htmlBody.trim().isEmpty() ? new MimeMultipart("alternative") : new MimeMultipart();
        }

        private void addRecipientsAux() {
            EmailAddressList remainder;
            boolean hasAnyToOrCC = false;
            if (Email.this.hasAnyRecipients(Email.this.getToAddresses())) {
                EmailAddressList tos = Email.this.getToAddresses();
                remainder = this.addRecipientsAux(MimeMessage.RecipientType.TO, tos);
                Email.this.setToAddresses(remainder);
                hasAnyToOrCC = true;
            }
            if (Email.this.hasAnyRecipients(Email.this.getCcAddresses())) {
                EmailAddressList ccs = Email.this.getCcAddresses();
                remainder = this.addRecipientsAux(MimeMessage.RecipientType.CC, ccs);
                Email.this.setCcAddresses(remainder);
                hasAnyToOrCC = true;
            }
            if (!hasAnyToOrCC && Email.this.hasAnyRecipients(Email.this.getBccAddresses())) {
                EmailAddressList bccs = Email.this.getBccAddresses();
                remainder = this.addRecipientsAux(MimeMessage.RecipientType.BCC, bccs);
                Email.this.setBccAddresses(remainder);
            }
        }

        private EmailAddressList addRecipientsAux(Message.RecipientType recipientType, EmailAddressList emailAddressList) {
            String[] emailAddresses = emailAddressList.toArray();
            for (int i = 0; i < emailAddresses.length; ++i) {
                String emailAddress = emailAddresses[i];
                try {
                    if (this.emailAddressFormatIsValid(emailAddress)) {
                        this.addRecipient(recipientType, (Address)new InternetAddress(Email.encode(emailAddress)));
                    } else {
                        Email.this.logProblem("invalid.email.address.format: " + emailAddress);
                    }
                }
                catch (AddressException e) {
                    Email.this.logProblem(e.getMessage() + " " + emailAddress);
                }
                catch (MessagingException e) {
                    Email.this.logProblem(e.getMessage() + " " + emailAddress);
                }
                if (i != MAX_MAIL_RECIPIENTS || i + 1 >= emailAddresses.length) continue;
                String all = emailAddressList.toString();
                int next = all.indexOf(emailAddress) + emailAddress.length() + 2;
                return new EmailAddressList(all.substring(next));
            }
            return null;
        }

        public boolean emailAddressFormatIsValid(String emailAddress) {
            if (emailAddress == null || emailAddress.length() == 0) {
                return false;
            }
            if (emailAddress.indexOf(32) > 0) {
                return false;
            }
            String[] atSplit = emailAddress.split("@");
            if (atSplit.length != 2) {
                return false;
            }
            if (atSplit[0].length() == 0 || atSplit[1].length() == 0) {
                return false;
            }
            String domain = new String(atSplit[1]);
            if (domain.lastIndexOf(46) == domain.length() - 1) {
                return false;
            }
            return domain.indexOf(46) > 0;
        }
    }
}

