/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicOperationType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.curricularRules.executors.RuleResult;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.CurricularRuleLevel;
import org.fenixedu.academic.domain.curricularRules.executors.ruleExecutors.EnrolmentResultType;
import org.fenixedu.academic.domain.enrolment.EnrolmentContext;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrollmentDomainException;
import org.fenixedu.academic.domain.person.RoleType;
import org.fenixedu.academic.domain.phd.enrolments.PhdStudentCurricularPlanEnrolmentManager;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentManager;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanEnrolmentPreConditions;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanExtraEnrolmentManager;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanImprovementOfApprovedEnrolmentManager;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanPropaeudeuticsEnrolmentManager;
import org.fenixedu.academic.domain.studentCurriculum.StudentCurricularPlanStandaloneEnrolmentManager;

public abstract class StudentCurricularPlanEnrolment {
    protected EnrolmentContext enrolmentContext;

    protected StudentCurricularPlanEnrolment(EnrolmentContext enrolmentContext) {
        this.checkParameters(enrolmentContext);
        this.enrolmentContext = enrolmentContext;
    }

    private void checkParameters(EnrolmentContext enrolmentContext) {
        if (enrolmentContext == null) {
            throw new DomainException("error.StudentCurricularPlanEnrolment.invalid.enrolmentContext", new String[0]);
        }
        if (enrolmentContext.getStudentCurricularPlan() == null) {
            throw new DomainException("error.StudentCurricularPlanEnrolment.invalid.studentCurricularPlan", new String[0]);
        }
        if (!enrolmentContext.hasResponsiblePerson()) {
            throw new DomainException("error.StudentCurricularPlanEnrolment.enrolmentContext.invalid.person", new String[0]);
        }
    }

    public final RuleResult manage() {
        this.assertEnrolmentPreConditions();
        this.unEnrol();
        this.addEnroled();
        HashMap<EnrolmentResultType, List<IDegreeModuleToEvaluate>> degreeModulesToEnrolMap = new HashMap<EnrolmentResultType, List<IDegreeModuleToEvaluate>>();
        RuleResult result = this.evaluateDegreeModules(degreeModulesToEnrolMap);
        this.performEnrolments(degreeModulesToEnrolMap);
        return result;
    }

    protected void assertEnrolmentPreConditions() {
        if (this.isResponsiblePersonManager()) {
            return;
        }
        this.checkDebts();
        if (this.isResponsiblePersonAllowedToEnrolStudents() || this.isResponsibleInternationalRelationOffice()) {
            this.assertAcademicAdminOfficePreConditions();
        } else if (this.isResponsiblePersonStudent()) {
            this.assertStudentEnrolmentPreConditions();
        } else {
            this.assertOtherRolesPreConditions();
        }
    }

    protected void checkDebts() {
        StudentCurricularPlanEnrolmentPreConditions.EnrolmentPreConditionResult result = StudentCurricularPlanEnrolmentPreConditions.checkDebts(this.getStudentCurricularPlan());
        if (!result.isValid()) {
            throw new DomainException(result.message(), result.args());
        }
    }

    protected Person getPerson() {
        return this.getStudent().getPerson();
    }

    protected void assertAcademicAdminOfficePreConditions() {
        this.checkEnrolmentWithoutRules();
        if (this.updateRegistrationAfterConclusionProcessPermissionEvaluated()) {
            return;
        }
        if (!this.getRegistration().hasActiveLastState(this.getExecutionSemester())) {
            throw new DomainException("error.StudentCurricularPlan.registration.is.not.active.for.semester", this.getExecutionSemester().getQualifiedName());
        }
    }

    protected boolean updateRegistrationAfterConclusionProcessPermissionEvaluated() {
        if (this.areModifiedCyclesConcluded() || this.isStudentCurricularPlanConcluded()) {
            this.checkUpdateRegistrationAfterConclusion();
            return true;
        }
        return false;
    }

    protected boolean areModifiedCyclesConcluded() {
        for (CycleCurriculumGroup curriculumGroup : this.getModifiedCycles()) {
            if (!curriculumGroup.isConclusionProcessed()) continue;
            return true;
        }
        return false;
    }

    protected boolean isStudentCurricularPlanConcluded() {
        return !this.getStudentCurricularPlan().isEmptyDegree() && this.getStudentCurricularPlan().isConclusionProcessed();
    }

    protected void checkEnrolmentWithoutRules() {
        if (this.isEnrolmentWithoutRules() && !AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.ENROLMENT_WITHOUT_RULES, (AcademicProgram)((Object)this.getStudentCurricularPlan().getDegree()), this.getResponsiblePerson().getUser()) && !this.isResponsibleInternationalRelationOffice()) {
            throw new DomainException("error.permissions.cannot.enrol.without.rules", new String[0]);
        }
    }

    protected void checkUpdateRegistrationAfterConclusion() {
        if (!AcademicAccessRule.isProgramAccessibleToFunction(AcademicOperationType.UPDATE_REGISTRATION_AFTER_CONCLUSION, (AcademicProgram)((Object)this.getStudentCurricularPlan().getDegree()), this.getResponsiblePerson().getUser())) {
            throw new DomainException("error.permissions.cannot.update.registration.after.conclusion.process", new String[0]);
        }
    }

    protected Set<CycleCurriculumGroup> getModifiedCycles() {
        HashSet<CycleCurriculumGroup> result = new HashSet<CycleCurriculumGroup>();
        for (CycleCurriculumGroup cycle : this.getStudentCurricularPlan().getCycleCurriculumGroups()) {
            if (this.isRemovingModulesFromCycle(cycle)) {
                result.add(cycle);
                break;
            }
            if (!this.isEnrolingInCycle(cycle)) continue;
            result.add(cycle);
            break;
        }
        return result;
    }

    protected boolean isRemovingModulesFromCycle(CycleCurriculumGroup cycle) {
        for (CurriculumModule module : this.enrolmentContext.getToRemove()) {
            if (!cycle.hasCurriculumModule(module)) continue;
            return true;
        }
        return false;
    }

    protected boolean isEnrolingInCycle(CycleCurriculumGroup cycle) {
        for (IDegreeModuleToEvaluate dmte : this.enrolmentContext.getDegreeModulesToEvaluate()) {
            if (!dmte.isEnroling() || !cycle.hasCurriculumModule((CurriculumModule)((Object)dmte.getCurriculumGroup()))) continue;
            return true;
        }
        return false;
    }

    protected void assertStudentEnrolmentPreConditions() {
        if (!this.getResponsiblePerson().getStudent().getRegistrationsToEnrolByStudent().contains((Object)this.getRegistration())) {
            throw new DomainException("error.StudentCurricularPlan.student.is.not.allowed.to.perform.enrol", new String[0]);
        }
        if (this.getCurricularRuleLevel() != CurricularRuleLevel.ENROLMENT_WITH_RULES) {
            throw new DomainException("error.StudentCurricularPlan.invalid.curricular.rule.level", new String[0]);
        }
        StudentCurricularPlanEnrolmentPreConditions.EnrolmentPreConditionResult result = StudentCurricularPlanEnrolmentPreConditions.checkEnrolmentPeriods(this.getStudentCurricularPlan(), this.getExecutionSemester());
        if (!result.isValid()) {
            throw new DomainException(result.message(), result.args());
        }
    }

    protected void assertOtherRolesPreConditions() {
        throw new DomainException("error.invalid.user", new String[0]);
    }

    private RuleResult evaluateDegreeModules(Map<EnrolmentResultType, List<IDegreeModuleToEvaluate>> degreeModulesEnrolMap) {
        RuleResult finalResult = RuleResult.createInitialTrue();
        Map<IDegreeModuleToEvaluate, Set<ICurricularRule>> rulesToEvaluate = this.getRulesToEvaluate();
        for (Map.Entry<IDegreeModuleToEvaluate, Set<ICurricularRule>> entry : rulesToEvaluate.entrySet()) {
            RuleResult result = this.evaluateRules(entry.getKey(), entry.getValue());
            finalResult = finalResult.and(result);
        }
        if (!(finalResult = this.evaluateExtraRules(finalResult)).isFalse()) {
            for (IDegreeModuleToEvaluate degreeModuleToEvaluate : rulesToEvaluate.keySet()) {
                this.addDegreeModuleToEvaluateToMap(degreeModulesEnrolMap, finalResult.getEnrolmentResultTypeFor(degreeModuleToEvaluate.getDegreeModule()), degreeModuleToEvaluate);
            }
        }
        if (finalResult.isFalse()) {
            throw new EnrollmentDomainException(finalResult);
        }
        return finalResult;
    }

    protected RuleResult evaluateExtraRules(RuleResult actualResult) {
        return actualResult;
    }

    private RuleResult evaluateRules(IDegreeModuleToEvaluate degreeModuleToEvaluate, Set<ICurricularRule> curricularRules) {
        RuleResult ruleResult = RuleResult.createTrue(degreeModuleToEvaluate.getDegreeModule());
        for (ICurricularRule rule : curricularRules) {
            ruleResult = ruleResult.and(rule.evaluate(degreeModuleToEvaluate, this.enrolmentContext));
        }
        return ruleResult;
    }

    private void addDegreeModuleToEvaluateToMap(Map<EnrolmentResultType, List<IDegreeModuleToEvaluate>> result, EnrolmentResultType enrolmentResultType, IDegreeModuleToEvaluate degreeModuleToEnrol) {
        List<IDegreeModuleToEvaluate> information = result.get((Object)enrolmentResultType);
        if (information == null) {
            information = new ArrayList<IDegreeModuleToEvaluate>();
            result.put(enrolmentResultType, information);
        }
        information.add(degreeModuleToEnrol);
    }

    protected ExecutionSemester getExecutionSemester() {
        return this.enrolmentContext.getExecutionPeriod();
    }

    protected ExecutionYear getExecutionYear() {
        return this.getExecutionSemester().getExecutionYear();
    }

    protected StudentCurricularPlan getStudentCurricularPlan() {
        return this.enrolmentContext.getStudentCurricularPlan();
    }

    protected Registration getRegistration() {
        return this.getStudentCurricularPlan().getRegistration();
    }

    protected RootCurriculumGroup getRoot() {
        return this.getStudentCurricularPlan().getRoot();
    }

    protected Student getStudent() {
        return this.getRegistration().getStudent();
    }

    protected DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getStudentCurricularPlan().getDegreeCurricularPlan();
    }

    protected CurricularRuleLevel getCurricularRuleLevel() {
        return this.enrolmentContext.getCurricularRuleLevel();
    }

    protected Person getResponsiblePerson() {
        return this.enrolmentContext.getResponsiblePerson();
    }

    private boolean isEnrolmentWithoutRules() {
        return this.enrolmentContext.isEnrolmentWithoutRules();
    }

    protected boolean isResponsiblePersonManager() {
        return RoleType.MANAGER.isMember(this.getResponsiblePerson().getUser());
    }

    protected boolean isResponsiblePersonAllowedToEnrolStudents() {
        return AcademicAccessRule.getProgramsAccessibleToFunction(AcademicOperationType.STUDENT_ENROLMENTS, this.getResponsiblePerson().getUser()).collect(Collectors.toSet()).contains(this.getStudentCurricularPlan().getDegree());
    }

    protected boolean isResponsibleInternationalRelationOffice() {
        return RoleType.INTERNATIONAL_RELATION_OFFICE.isMember(this.getResponsiblePerson().getUser());
    }

    protected boolean isResponsiblePersonStudent() {
        return RoleType.STUDENT.isMember(this.getResponsiblePerson().getUser());
    }

    protected boolean isResponsiblePersonCoordinator() {
        return RoleType.COORDINATOR.isMember(this.getResponsiblePerson().getUser());
    }

    protected abstract void unEnrol();

    protected abstract void addEnroled();

    protected abstract Map<IDegreeModuleToEvaluate, Set<ICurricularRule>> getRulesToEvaluate();

    protected abstract void performEnrolments(Map<EnrolmentResultType, List<IDegreeModuleToEvaluate>> var1);

    public static StudentCurricularPlanEnrolment createManager(EnrolmentContext enrolmentContext) {
        if (enrolmentContext.isNormal()) {
            if (enrolmentContext.isPhdDegree()) {
                return new PhdStudentCurricularPlanEnrolmentManager(enrolmentContext);
            }
            return new StudentCurricularPlanEnrolmentManager(enrolmentContext);
        }
        if (enrolmentContext.isImprovement()) {
            return new StudentCurricularPlanImprovementOfApprovedEnrolmentManager(enrolmentContext);
        }
        if (enrolmentContext.isSpecialSeason()) {
            return new StudentCurricularPlanEnrolmentInSpecialSeasonEvaluationManager(enrolmentContext);
        }
        if (enrolmentContext.isExtra()) {
            return new StudentCurricularPlanExtraEnrolmentManager(enrolmentContext);
        }
        if (enrolmentContext.isPropaeudeutics()) {
            return new StudentCurricularPlanPropaeudeuticsEnrolmentManager(enrolmentContext);
        }
        if (enrolmentContext.isStandalone()) {
            return new StudentCurricularPlanStandaloneEnrolmentManager(enrolmentContext);
        }
        throw new DomainException("StudentCurricularPlanEnrolment", new String[0]);
    }
}

