/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.ICurricularRule;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.RootCourseGroup;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroupFactory;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.ExternalCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.domain.studentCurriculum.RootCurriculumGroup_Base;
import org.joda.time.DateTime;

public class RootCurriculumGroup
extends RootCurriculumGroup_Base {
    protected RootCurriculumGroup() {
        this.createExtraCurriculumGroup();
        this.createPropaedeuticsCurriculumGroup();
    }

    protected RootCurriculumGroup(StudentCurricularPlan studentCurricularPlan, RootCourseGroup rootCourseGroup, ExecutionSemester executionSemester, CycleType cycleType) {
        this();
        this.init(studentCurricularPlan, rootCourseGroup, executionSemester, cycleType);
        this.createStandaloneCurriculumGroupIfNecessary();
    }

    private void init(StudentCurricularPlan studentCurricularPlan, RootCourseGroup courseGroup, ExecutionSemester executionSemester, CycleType cycleType) {
        this.checkParameters(studentCurricularPlan, courseGroup, executionSemester);
        this.checkInitConstraints(studentCurricularPlan, courseGroup);
        this.setParentStudentCurricularPlan(studentCurricularPlan);
        this.setDegreeModule((DegreeModule)((Object)courseGroup));
        this.addChildCurriculumGroups(courseGroup, executionSemester, cycleType);
    }

    private void checkParameters(StudentCurricularPlan studentCurricularPlan, RootCourseGroup courseGroup, ExecutionSemester executionSemester) {
        this.checkParameters(studentCurricularPlan, courseGroup);
        if (executionSemester == null) {
            throw new DomainException("error.studentCurriculum.executionPeriod.cannot.be.null", new String[0]);
        }
    }

    protected RootCurriculumGroup(StudentCurricularPlan studentCurricularPlan, RootCourseGroup rootCourseGroup, CycleType cycleType) {
        this();
        this.init(studentCurricularPlan, rootCourseGroup, cycleType);
        this.createStandaloneCurriculumGroupIfNecessary();
    }

    private void init(StudentCurricularPlan studentCurricularPlan, RootCourseGroup rootCourseGroup, CycleType cycleType) {
        this.checkParameters(studentCurricularPlan, rootCourseGroup);
        this.checkInitConstraints(studentCurricularPlan, rootCourseGroup);
        this.setParentStudentCurricularPlan(studentCurricularPlan);
        this.setDegreeModule((DegreeModule)((Object)rootCourseGroup));
        this.addChildCurriculumGroups(rootCourseGroup, cycleType);
    }

    private void checkParameters(StudentCurricularPlan studentCurricularPlan, RootCourseGroup rootCourseGroup) {
        if (studentCurricularPlan == null) {
            throw new DomainException("error.studentCurriculum.studentCurricularPlan.cannot.be.null", new String[0]);
        }
        if (rootCourseGroup == null) {
            throw new DomainException("error.studentCurriculum.rootCourseGroup.cannot.be.null", new String[0]);
        }
    }

    private void addChildCurriculumGroups(RootCourseGroup rootCourseGroup, ExecutionSemester executionSemester, CycleType cycle) {
        if (rootCourseGroup.hasCycleGroups()) {
            this.createCycle(rootCourseGroup, executionSemester, cycle);
        } else {
            super.addChildCurriculumGroups((CourseGroup)((Object)rootCourseGroup), executionSemester);
        }
    }

    private void addChildCurriculumGroups(RootCourseGroup rootCourseGroup, CycleType cycle) {
        if (rootCourseGroup.hasCycleGroups()) {
            this.createCycle(rootCourseGroup, null, cycle);
        }
    }

    private void createCycle(RootCourseGroup rootCourseGroup, ExecutionSemester executionSemester, CycleType cycle) {
        if (cycle == null) {
            cycle = rootCourseGroup.getDegree().getDegreeType().getFirstOrderedCycleType();
        }
        if (cycle != null) {
            CurriculumGroupFactory.createGroup((CurriculumGroup)((Object)this), (CourseGroup)((Object)rootCourseGroup.getCycleCourseGroup(cycle)), executionSemester);
        }
    }

    private void checkInitConstraints(StudentCurricularPlan studentCurricularPlan, RootCourseGroup rootCourseGroup) {
        if (studentCurricularPlan.getDegreeCurricularPlan() != rootCourseGroup.getParentDegreeCurricularPlan()) {
            throw new DomainException("error.rootCurriculumGroup.scp.and.root.have.different.degreeCurricularPlan", new String[0]);
        }
    }

    public void setRootCourseGroup(RootCourseGroup rootCourseGroup) {
        this.setDegreeModule((DegreeModule)((Object)rootCourseGroup));
    }

    public void setDegreeModule(DegreeModule degreeModule) {
        if (degreeModule != null && !(degreeModule instanceof RootCourseGroup)) {
            throw new DomainException("error.curriculumGroup.RootCurriculumGroup.degreeModuleMustBeRootCourseGroup", new String[0]);
        }
        super.setDegreeModule(degreeModule);
    }

    public void setCurriculumGroup(CurriculumGroup curriculumGroup) {
        if (curriculumGroup != null) {
            throw new DomainException("error.curriculumGroup.RootCurriculumGroupCannotHaveParent", new String[0]);
        }
    }

    public boolean isRoot() {
        return true;
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.getParentStudentCurricularPlan();
    }

    public boolean hasStudentCurricularPlan() {
        return this.getParentStudentCurricularPlan() != null;
    }

    private void createExtraCurriculumGroup() {
        NoCourseGroupCurriculumGroup.create(NoCourseGroupCurriculumGroupType.EXTRA_CURRICULAR, this);
    }

    private void createPropaedeuticsCurriculumGroup() {
        NoCourseGroupCurriculumGroup.create(NoCourseGroupCurriculumGroupType.PROPAEDEUTICS, this);
    }

    private void createStandaloneCurriculumGroupIfNecessary() {
        if (this.hasStudentCurricularPlan() && this.getStudentCurricularPlan().isEmptyDegree()) {
            NoCourseGroupCurriculumGroup.create(NoCourseGroupCurriculumGroupType.STANDALONE, this);
        }
    }

    public CycleCurriculumGroup getCycleCurriculumGroup(CycleType cycleType) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            CycleCurriculumGroup cycleCurriculumGroup;
            if (!curriculumModule.isCycleCurriculumGroup() || !(cycleCurriculumGroup = (CycleCurriculumGroup)((Object)curriculumModule)).isCycle(cycleType)) continue;
            return cycleCurriculumGroup;
        }
        return null;
    }

    public CycleCurriculumGroup getFirstOrderedCycleCurriculumGroup() {
        for (CycleType cycleType : this.getDegreeType().getOrderedCycleTypes()) {
            CycleCurriculumGroup cycleCurriculumGroup = this.getCycleCurriculumGroup(cycleType);
            if (cycleCurriculumGroup == null) continue;
            return cycleCurriculumGroup;
        }
        return null;
    }

    public CycleCurriculumGroup getLastOrderedCycleCurriculumGroup() {
        TreeSet<CycleCurriculumGroup> cycleCurriculumGroups = new TreeSet<CycleCurriculumGroup>(CycleCurriculumGroup.COMPARATOR_BY_CYCLE_TYPE_AND_ID);
        cycleCurriculumGroups.addAll(this.getInternalCycleCurriculumGroups());
        return cycleCurriculumGroups.isEmpty() ? null : (CycleCurriculumGroup)((Object)cycleCurriculumGroups.last());
    }

    public CycleCurriculumGroup getLastConcludedCycleCurriculumGroup() {
        TreeSet<CycleCurriculumGroup> cycleCurriculumGroups = new TreeSet<CycleCurriculumGroup>((Comparator<CycleCurriculumGroup>)new ReverseComparator(CycleCurriculumGroup.COMPARATOR_BY_CYCLE_TYPE_AND_ID));
        cycleCurriculumGroups.addAll(this.getInternalCycleCurriculumGroups());
        for (CycleCurriculumGroup curriculumGroup : cycleCurriculumGroups) {
            if (!curriculumGroup.isConcluded()) continue;
            return curriculumGroup;
        }
        return null;
    }

    public Collection<CycleCurriculumGroup> getCycleCurriculumGroups() {
        HashSet<CycleCurriculumGroup> cycleCurriculumGroups = new HashSet<CycleCurriculumGroup>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isCycleCurriculumGroup()) continue;
            cycleCurriculumGroups.add((CycleCurriculumGroup)((Object)curriculumModule));
        }
        return cycleCurriculumGroups;
    }

    public DegreeType getDegreeType() {
        return this.getStudentCurricularPlan().getDegreeType();
    }

    public boolean hasConcludedCycle(CycleType cycleType) {
        for (CycleType degreeCycleType : this.getDegreeType().getCycleTypes()) {
            if (cycleType != null && degreeCycleType != cycleType || this.checkIfCycleIsConcluded(degreeCycleType)) continue;
            return false;
        }
        return cycleType == null || this.getDegreeType().getCycleTypes().contains((Object)cycleType);
    }

    private boolean checkIfCycleIsConcluded(CycleType cycleType) {
        CycleCurriculumGroup cycleCurriculumGroup = this.getCycleCurriculumGroup(cycleType);
        return cycleCurriculumGroup != null && cycleCurriculumGroup.isConcluded();
    }

    public boolean hasConcludedCycle(CycleType cycleType, ExecutionYear executionYear) {
        for (CycleType degreeCycleType : this.getDegreeType().getCycleTypes()) {
            if (cycleType != null && degreeCycleType != cycleType || this.checkIfCycleIsConcluded(degreeCycleType, executionYear)) continue;
            return false;
        }
        return cycleType == null || this.getDegreeType().getCycleTypes().contains((Object)cycleType);
    }

    private boolean checkIfCycleIsConcluded(CycleType cycleType, ExecutionYear executionYear) {
        CycleCurriculumGroup cycleCurriculumGroup = this.getCycleCurriculumGroup(cycleType);
        return cycleCurriculumGroup != null && cycleCurriculumGroup.isConcluded(executionYear).value();
    }

    public Curriculum getCurriculum(DateTime when, ExecutionYear executionYear) {
        Curriculum curriculum = Curriculum.createEmpty((CurriculumModule)((Object)this), executionYear);
        if (!this.wasCreated(when)) {
            return curriculum;
        }
        DegreeType degreeType = this.getDegreeType();
        if (degreeType.hasAnyCycleTypes()) {
            for (CycleCurriculumGroup cycleCurriculumGroup : this.getInternalCycleCurriculumGroups()) {
                curriculum.add(cycleCurriculumGroup.getCurriculum(when, executionYear));
            }
        } else {
            curriculum.add(super.getCurriculum(when, executionYear));
        }
        return curriculum;
    }

    public void delete() {
        this.setParentStudentCurricularPlan(null);
        super.delete();
    }

    public RootCourseGroup getDegreeModule() {
        return (RootCourseGroup)((Object)super.getDegreeModule());
    }

    public boolean hasExternalCycles() {
        for (CycleCurriculumGroup cycleCurriculumGroup : this.getCycleCurriculumGroups()) {
            if (!cycleCurriculumGroup.isExternal()) continue;
            return true;
        }
        return false;
    }

    public ICurricularRule getMostRecentActiveCurricularRule(CurricularRuleType ruleType, ExecutionYear executionYear) {
        return this.getDegreeModule().getMostRecentActiveCurricularRule(ruleType, null, executionYear);
    }

    public CycleCurriculumGroup getCycleCurriculumGroupFor(CurriculumModule curriculumModule) {
        for (CycleCurriculumGroup cycleCurriculumGroup : this.getCycleCurriculumGroups()) {
            if (!cycleCurriculumGroup.hasCurriculumModule(curriculumModule)) continue;
            return cycleCurriculumGroup;
        }
        return null;
    }

    public CycleCourseGroup getCycleCourseGroup(CurriculumModule curriculumModule) {
        CycleCurriculumGroup cycleCurriculumGroup = this.getCycleCurriculumGroupFor(curriculumModule);
        return cycleCurriculumGroup != null ? cycleCurriculumGroup.getDegreeModule() : null;
    }

    public CycleCourseGroup getCycleCourseGroup(CycleType cycleType) {
        return this.getDegreeModule().getCycleCourseGroup(cycleType);
    }

    public List<CycleCurriculumGroup> getInternalCycleCurriculumGroups() {
        ArrayList<CycleCurriculumGroup> result = new ArrayList<CycleCurriculumGroup>();
        for (CycleCurriculumGroup cycleCurriculumGroup : this.getCycleCurriculumGroups()) {
            if (cycleCurriculumGroup.isExternal()) continue;
            result.add(cycleCurriculumGroup);
        }
        return result;
    }

    public List<ExternalCurriculumGroup> getExternalCycleCurriculumGroups() {
        ArrayList<ExternalCurriculumGroup> result = new ArrayList<ExternalCurriculumGroup>();
        for (CycleCurriculumGroup cycleCurriculumGroup : this.getCycleCurriculumGroups()) {
            if (!cycleCurriculumGroup.isExternal()) continue;
            result.add((ExternalCurriculumGroup)((Object)cycleCurriculumGroup));
        }
        return result;
    }

    public double getDefaultEcts(ExecutionYear executionYear) {
        double result = 0.0;
        for (CycleCurriculumGroup cycleCurriculumGroup : this.getInternalCycleCurriculumGroups()) {
            result += cycleCurriculumGroup.getDefaultEcts(executionYear).doubleValue();
        }
        return result;
    }

    public Set<CurriculumGroup> getAllCurriculumGroups() {
        HashSet<CurriculumGroup> result = new HashSet<CurriculumGroup>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getAllCurriculumGroups());
        }
        return result;
    }

    public Set<CurriculumGroup> getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups() {
        HashSet<CurriculumGroup> result = new HashSet<CurriculumGroup>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups());
        }
        return result;
    }
}

