/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.studentCurriculum;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.OptionalEnrolment;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curricularRules.CreditsLimit;
import org.fenixedu.academic.domain.curricularRules.CurricularRuleType;
import org.fenixedu.academic.domain.curricularRules.DegreeModulesSelectionLimit;
import org.fenixedu.academic.domain.degreeStructure.BranchCourseGroup;
import org.fenixedu.academic.domain.degreeStructure.BranchType;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.enrolment.EnroledCurriculumModuleWrapper;
import org.fenixedu.academic.domain.enrolment.IDegreeModuleToEvaluate;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.student.curriculum.ConclusionProcess;
import org.fenixedu.academic.domain.student.curriculum.Curriculum;
import org.fenixedu.academic.domain.student.curriculum.ProgramConclusionProcess;
import org.fenixedu.academic.domain.studentCurriculum.BranchCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroupFactory;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup_Base;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumLine;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumModule;
import org.fenixedu.academic.domain.studentCurriculum.Dismissal;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroupType;
import org.fenixedu.academic.dto.student.RegistrationConclusionBean;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.CycleCurriculumGroupPredicates;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.util.predicates.AndPredicate;
import org.fenixedu.academic.util.predicates.ResultCollection;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class CurriculumGroup
extends CurriculumGroup_Base {
    public static final Comparator<CurriculumGroup> COMPARATOR_BY_CHILD_ORDER_AND_ID = new Comparator<CurriculumGroup>(){

        @Override
        public int compare(CurriculumGroup o1, CurriculumGroup o2) {
            int result = o1.getChildOrder().compareTo(o2.getChildOrder());
            return result != 0 ? result : o1.getExternalId().compareTo(o2.getExternalId());
        }
    };

    protected CurriculumGroup() {
    }

    public CurriculumGroup(CurriculumGroup curriculumGroup, CourseGroup courseGroup) {
        this();
        this.init(curriculumGroup, courseGroup);
    }

    protected void init(CurriculumGroup curriculumGroup, CourseGroup courseGroup) {
        if (courseGroup == null || curriculumGroup == null) {
            throw new DomainException("error.studentCurriculum.curriculumGroup.courseGroup.cannot.be.null", new String[0]);
        }
        this.checkInitConstraints(curriculumGroup, courseGroup);
        this.setDegreeModule((DegreeModule)((Object)courseGroup));
        this.setCurriculumGroup(curriculumGroup);
    }

    protected void checkInitConstraints(CurriculumGroup parent, CourseGroup courseGroup) {
        if (parent.getRootCurriculumGroup().hasCourseGroup(courseGroup)) {
            throw new DomainException("error.studentCurriculum.CurriculumGroup.duplicate.courseGroup", courseGroup.getName());
        }
    }

    protected void checkParameters(CourseGroup courseGroup, ExecutionSemester executionSemester) {
        if (courseGroup == null) {
            throw new DomainException("error.studentCurriculum.curriculumGroup.courseGroup.cannot.be.null", new String[0]);
        }
        if (executionSemester == null) {
            throw new DomainException("error.studentCurriculum.curriculumGroup.executionPeriod.cannot.be.null", new String[0]);
        }
    }

    public CurriculumGroup(CurriculumGroup parentCurriculumGroup, CourseGroup courseGroup, ExecutionSemester executionSemester) {
        this.init(parentCurriculumGroup, courseGroup, executionSemester);
    }

    protected void init(CurriculumGroup curriculumGroup, CourseGroup courseGroup, ExecutionSemester executionSemester) {
        this.checkInitConstraints(curriculumGroup, courseGroup);
        this.checkParameters(curriculumGroup, courseGroup, executionSemester);
        this.setDegreeModule((DegreeModule)((Object)courseGroup));
        this.setCurriculumGroup(curriculumGroup);
        this.addChildCurriculumGroups(courseGroup, executionSemester);
    }

    private void checkParameters(CurriculumGroup parentCurriculumGroup, CourseGroup courseGroup, ExecutionSemester executionSemester) {
        if (parentCurriculumGroup == null) {
            throw new DomainException("error.studentCurriculum.curriculumGroup.parentCurriculumGroup.cannot.be.null", new String[0]);
        }
        this.checkParameters(courseGroup, executionSemester);
    }

    protected void addChildCurriculumGroups(CourseGroup courseGroup, ExecutionSemester executionSemester) {
        for (CourseGroup childCourseGroup : courseGroup.getNotOptionalChildCourseGroups(executionSemester)) {
            CurriculumGroupFactory.createGroup(this, childCourseGroup, executionSemester);
        }
    }

    public final boolean isLeaf() {
        return false;
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getCurriculumModulesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.studentCurriculum.CurriculumGroup.notEmptyCurriculumGroupModules", (String[])new String[]{this.getName().getContent()}));
        }
    }

    public boolean isDeletable() {
        return this.getDeletionBlockers().isEmpty();
    }

    public void deleteRecursive() {
        AccessControl.check(this, RolePredicates.MANAGER_PREDICATE);
        for (CurriculumModule child : this.getCurriculumModulesSet()) {
            child.deleteRecursive();
        }
        this.delete();
    }

    public final StringBuilder print(String tabs) {
        StringBuilder builder = new StringBuilder();
        builder.append(tabs);
        builder.append("[CG ").append(this.getName().getContent()).append(" ]\n");
        String tab = tabs + "\t";
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            builder.append((CharSequence)curriculumModule.print(tab));
        }
        return builder;
    }

    public CourseGroup getDegreeModule() {
        return (CourseGroup)((Object)super.getDegreeModule());
    }

    public final List<Enrolment> getEnrolments() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getEnrolments());
        }
        return result;
    }

    public final Set<Enrolment> getEnrolmentsSet() {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getEnrolments());
        }
        return result;
    }

    public final boolean hasAnyEnrolments() {
        return this.hasAnyCurriculumModules(new CurriculumModule.CurriculumModulePredicateByType(Enrolment.class));
    }

    public boolean hasAnyCurriculumModules(Predicate<CurriculumModule> predicate) {
        if (super.hasAnyCurriculumModules(predicate)) {
            return true;
        }
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.hasAnyCurriculumModules(predicate)) continue;
            return true;
        }
        return false;
    }

    public final void collectDismissals(List<Dismissal> result) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            curriculumModule.collectDismissals(result);
        }
    }

    public List<Dismissal> getChildDismissals() {
        ArrayList<Dismissal> result = new ArrayList<Dismissal>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isDismissal()) continue;
            result.add((Dismissal)((Object)curriculumModule));
        }
        return result;
    }

    public double getChildCreditsDismissalEcts() {
        double total = 0.0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isCreditsDismissal()) continue;
            total += curriculumModule.getEctsCredits().doubleValue();
        }
        return total;
    }

    public List<Enrolment> getChildEnrolments() {
        ArrayList<Enrolment> result = new ArrayList<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnrolment()) continue;
            result.add((Enrolment)((Object)curriculumModule));
        }
        return result;
    }

    public List<CurriculumLine> getChildCurriculumLines() {
        ArrayList<CurriculumLine> result = new ArrayList<CurriculumLine>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isLeaf()) continue;
            result.add((CurriculumLine)((Object)curriculumModule));
        }
        return result;
    }

    public List<CurriculumGroup> getChildCurriculumGroups() {
        ArrayList<CurriculumGroup> result = new ArrayList<CurriculumGroup>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (curriculumModule.isLeaf()) continue;
            result.add((CurriculumGroup)((Object)curriculumModule));
        }
        return result;
    }

    public boolean isRoot() {
        return false;
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.getCurriculumGroup().getStudentCurricularPlan();
    }

    private Collection<Context> getDegreeModulesFor(ExecutionSemester executionSemester) {
        return this.getDegreeModule().getValidChildContexts(executionSemester);
    }

    public List<Context> getCurricularCourseContextsToEnrol(ExecutionSemester executionSemester) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getDegreeModulesFor(executionSemester)) {
            if (!context.getChildDegreeModule().isLeaf()) continue;
            CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
            if (this.getStudentCurricularPlan().isApproved(curricularCourse, executionSemester) || this.getStudentCurricularPlan().isEnroledInExecutionPeriod(curricularCourse, executionSemester)) continue;
            result.add(context);
        }
        return result;
    }

    public List<Context> getCourseGroupContextsToEnrol(ExecutionSemester executionSemester) {
        ArrayList<Context> result = new ArrayList<Context>();
        for (Context context : this.getDegreeModulesFor(executionSemester)) {
            if (context.getChildDegreeModule().isLeaf() || this.getStudentCurricularPlan().getRoot().hasDegreeModule(context.getChildDegreeModule())) continue;
            result.add(context);
        }
        return result;
    }

    public Collection<CurricularCourse> getCurricularCoursesToDismissal(ExecutionSemester executionSemester) {
        HashSet<CurricularCourse> result = new HashSet<CurricularCourse>();
        for (Context context : this.getDegreeModule().getOpenChildContexts(CurricularCourse.class, executionSemester)) {
            CurricularCourse curricularCourse = (CurricularCourse)((Object)context.getChildDegreeModule());
            if (this.getStudentCurricularPlan().getRoot().isApproved(curricularCourse, null)) continue;
            result.add(curricularCourse);
        }
        return result;
    }

    public final boolean isApproved(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isApproved(curricularCourse, executionSemester)) continue;
            return true;
        }
        return false;
    }

    public final boolean isEnroledInExecutionPeriod(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnroledInExecutionPeriod(curricularCourse, executionSemester)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasEnrolmentWithEnroledState(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.hasEnrolmentWithEnroledState(curricularCourse, executionSemester)) continue;
            return true;
        }
        return false;
    }

    public final ExecutionYear getIEnrolmentsLastExecutionYear() {
        ExecutionYear result = null;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            ExecutionYear lastExecutionYear = curriculumModule.getIEnrolmentsLastExecutionYear();
            if (result != null && !result.isBefore(lastExecutionYear)) continue;
            result = lastExecutionYear;
        }
        return result;
    }

    public boolean hasDegreeModule(DegreeModule degreeModule) {
        if (super.hasDegreeModule(degreeModule)) {
            return true;
        }
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.hasDegreeModule(degreeModule)) continue;
            return true;
        }
        return false;
    }

    public final boolean hasCurriculumModule(CurriculumModule curriculumModule) {
        if (super.hasCurriculumModule(curriculumModule)) {
            return true;
        }
        for (CurriculumModule module : this.getCurriculumModulesSet()) {
            if (!module.hasCurriculumModule(curriculumModule)) continue;
            return true;
        }
        return false;
    }

    public final Enrolment findEnrolmentFor(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment search = curriculumModule.findEnrolmentFor(curricularCourse, executionSemester);
            if (search == null) continue;
            return search;
        }
        return null;
    }

    public final Enrolment getApprovedEnrolment(CurricularCourse curricularCourse) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolment = curriculumModule.getApprovedEnrolment(curricularCourse);
            if (enrolment == null) continue;
            return enrolment;
        }
        return null;
    }

    public final Dismissal getDismissal(CurricularCourse curricularCourse) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Dismissal dismissal = curriculumModule.getDismissal(curricularCourse);
            if (dismissal == null) continue;
            return dismissal;
        }
        return null;
    }

    public final CurriculumLine getApprovedCurriculumLine(CurricularCourse curricularCourse) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            CurriculumLine curriculumLine = curriculumModule.getApprovedCurriculumLine(curricularCourse);
            if (curriculumLine == null) continue;
            return curriculumLine;
        }
        return null;
    }

    public CurriculumGroup findCurriculumGroupFor(CourseGroup courseGroup) {
        if (this.getDegreeModule() == courseGroup) {
            return this;
        }
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            CurriculumGroup curriculumGroup;
            CurriculumGroup searchCurriculumGroup;
            if (curriculumModule.isLeaf() || (searchCurriculumGroup = (curriculumGroup = (CurriculumGroup)((Object)curriculumModule)).findCurriculumGroupFor(courseGroup)) == null) continue;
            return searchCurriculumGroup;
        }
        return null;
    }

    public void getCurriculumModules(ResultCollection<CurriculumModule> collection) {
        collection.condicionalAdd((CurriculumModule)((Object)this));
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            curriculumModule.getCurriculumModules(collection);
        }
    }

    public final Set<CurriculumLine> getCurriculumLines() {
        TreeSet<CurriculumModule> result = new TreeSet<CurriculumModule>(CurriculumModule.COMPARATOR_BY_NAME_AND_ID);
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isLeaf()) continue;
            result.add((CurriculumModule)((Object)((CurriculumLine)((Object)curriculumModule))));
        }
        return result;
    }

    public final boolean hasCurriculumLines() {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isLeaf()) continue;
            return true;
        }
        return false;
    }

    public final void addApprovedCurriculumLines(Collection<CurriculumLine> result) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            curriculumModule.addApprovedCurriculumLines(result);
        }
    }

    public final boolean hasAnyApprovedCurriculumLines() {
        AndPredicate<CurriculumModule> andPredicate = new AndPredicate<CurriculumModule>();
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByType(CurriculumLine.class));
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByApproval());
        return this.hasAnyCurriculumModules(andPredicate);
    }

    public final Set<CurriculumGroup> getCurriculumGroups() {
        TreeSet<CurriculumModule> result = new TreeSet<CurriculumModule>(CurriculumModule.COMPARATOR_BY_NAME_AND_ID);
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (curriculumModule.isLeaf()) continue;
            result.add((CurriculumModule)((Object)((CurriculumGroup)((Object)curriculumModule))));
        }
        return result;
    }

    public Set<CurriculumGroup> getCurriculumGroupsToEnrolmentProcess() {
        TreeSet<CurriculumModule> result = new TreeSet<CurriculumModule>(CurriculumModule.COMPARATOR_BY_NAME_AND_ID);
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (curriculumModule.isLeaf() || curriculumModule.isNoCourseGroupCurriculumGroup()) continue;
            result.add((CurriculumModule)((Object)((CurriculumGroup)((Object)curriculumModule))));
        }
        return result;
    }

    public Set<BranchCurriculumGroup> getBranchCurriculumGroups() {
        HashSet<BranchCurriculumGroup> result = new HashSet<BranchCurriculumGroup>(1);
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!(curriculumModule instanceof CurriculumGroup)) continue;
            CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)curriculumModule);
            result.addAll(curriculumGroup.getBranchCurriculumGroups());
        }
        return result;
    }

    public Set<BranchCurriculumGroup> getBranchCurriculumGroups(BranchType branchType) {
        HashSet<BranchCurriculumGroup> result = new HashSet<BranchCurriculumGroup>(1);
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!(curriculumModule instanceof CurriculumGroup)) continue;
            CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)curriculumModule);
            result.addAll(curriculumGroup.getBranchCurriculumGroups(branchType));
        }
        return result;
    }

    public boolean hasBranchCurriculumGroup(BranchType type) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            CurriculumGroup curriculumGroup;
            if (!(curriculumModule instanceof CurriculumGroup) || !(curriculumGroup = (CurriculumGroup)((Object)curriculumModule)).hasBranchCurriculumGroup(type)) continue;
            return true;
        }
        return false;
    }

    public Set<BranchCurriculumGroup> getMajorBranchCurriculumGroups() {
        return this.getBranchCurriculumGroups(BranchType.MAJOR);
    }

    public Set<BranchCurriculumGroup> getMinorBranchCurriculumGroups() {
        return this.getBranchCurriculumGroups(BranchType.MINOR);
    }

    public Set<BranchCourseGroup> getBranchCourseGroups(BranchType branchType) {
        HashSet<BranchCourseGroup> result = new HashSet<BranchCourseGroup>();
        for (BranchCurriculumGroup group : this.getBranchCurriculumGroups(branchType)) {
            result.add(group.getDegreeModule());
        }
        return result;
    }

    public Set<BranchCourseGroup> getMajorBranchCourseGroups() {
        return this.getBranchCourseGroups(BranchType.MAJOR);
    }

    public Set<BranchCourseGroup> getMinorBranchCourseGroups() {
        return this.getBranchCourseGroups(BranchType.MINOR);
    }

    public Set<CurriculumGroup> getAllCurriculumGroups() {
        HashSet<CurriculumGroup> result = new HashSet<CurriculumGroup>();
        result.add(this);
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getAllCurriculumGroups());
        }
        return result;
    }

    public Set<CurriculumGroup> getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups() {
        HashSet<CurriculumGroup> result = new HashSet<CurriculumGroup>();
        result.add(this);
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getAllCurriculumGroupsWithoutNoCourseGroupCurriculumGroups());
        }
        return result;
    }

    public Set<CurriculumLine> getAllCurriculumLines() {
        HashSet<CurriculumLine> result = new HashSet<CurriculumLine>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getAllCurriculumLines());
        }
        return result;
    }

    public Integer getChildOrder() {
        return this.getChildOrder(null);
    }

    public Integer getChildOrder(ExecutionSemester executionSemester) {
        Integer childOrder = this.getParentCurriculumGroup().searchChildOrderForChild(this, executionSemester);
        return childOrder != null ? childOrder : Integer.MAX_VALUE;
    }

    private CurriculumGroup getParentCurriculumGroup() {
        return this.getCurriculumGroup();
    }

    protected Integer searchChildOrderForChild(CurriculumGroup child, ExecutionSemester executionSemester) {
        for (Context context : this.getDegreeModule().getValidChildContexts(executionSemester)) {
            if (context.getChildDegreeModule() != child.getDegreeModule()) continue;
            return context.getChildOrder();
        }
        return null;
    }

    public boolean hasCourseGroup(CourseGroup courseGroup) {
        if (this.getDegreeModule().equals((Object)courseGroup)) {
            return true;
        }
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            CurriculumGroup group;
            if (curriculumModule.isLeaf() || !(group = (CurriculumGroup)((Object)curriculumModule)).hasCourseGroup(courseGroup)) continue;
            return true;
        }
        return false;
    }

    public final NoCourseGroupCurriculumGroup getNoCourseGroupCurriculumGroup(NoCourseGroupCurriculumGroupType groupType) {
        for (CurriculumGroup curriculumGroup : this.getCurriculumGroups()) {
            NoCourseGroupCurriculumGroup noCourseGroupCurriculumGroup;
            if (!curriculumGroup.isNoCourseGroupCurriculumGroup() || !(noCourseGroupCurriculumGroup = (NoCourseGroupCurriculumGroup)((Object)curriculumGroup)).getNoCourseGroupCurriculumGroupType().equals((Object)groupType)) continue;
            return noCourseGroupCurriculumGroup;
        }
        return null;
    }

    public final Double getEctsCredits() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            bigDecimal = bigDecimal.add(new BigDecimal(curriculumModule.getEctsCredits()));
        }
        return bigDecimal.doubleValue();
    }

    public Double getAprovedEctsCredits() {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            bigDecimal = bigDecimal.add(new BigDecimal(curriculumModule.getAprovedEctsCredits()));
        }
        return bigDecimal.doubleValue();
    }

    public final Double getEnroledEctsCredits(ExecutionSemester executionSemester) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            bigDecimal = bigDecimal.add(new BigDecimal(curriculumModule.getEnroledEctsCredits(executionSemester)));
        }
        return bigDecimal.doubleValue();
    }

    public Double getCreditsConcluded(ExecutionYear executionYear) {
        CreditsLimit creditsLimit = (CreditsLimit)((Object)this.getMostRecentActiveCurricularRule(CurricularRuleType.CREDITS_LIMIT, executionYear));
        Double creditsConcluded = 0.0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            creditsConcluded = creditsConcluded + curriculumModule.getCreditsConcluded(executionYear);
        }
        if (creditsLimit == null) {
            return creditsConcluded;
        }
        return Math.min(creditsLimit.getMaximumCredits(), creditsConcluded);
    }

    public final int getNumberOfChildCurriculumGroupsWithCourseGroup() {
        int result = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            CurriculumGroup curriculumGroup;
            if (curriculumModule.isLeaf() || (curriculumGroup = (CurriculumGroup)((Object)curriculumModule)).isNoCourseGroupCurriculumGroup()) continue;
            ++result;
        }
        return result;
    }

    public final int getNumberOfApprovedChildCurriculumLines() {
        int result = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isCurriculumLine()) continue;
            CurriculumLine curriculumLine = (CurriculumLine)((Object)curriculumModule);
            if (curriculumLine.isDismissal() && curriculumLine.hasCurricularCourse()) {
                ++result;
                continue;
            }
            if (!curriculumLine.isEnrolment() || !((Enrolment)((Object)curriculumLine)).isApproved()) continue;
            ++result;
        }
        return result;
    }

    public int getNumberOfAllEnroledCurriculumLines() {
        int result = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (curriculumModule.isCurriculumLine()) {
                CurriculumLine curriculumLine = (CurriculumLine)((Object)curriculumModule);
                if (!curriculumLine.isEnrolment()) continue;
                ++result;
                continue;
            }
            result += ((CurriculumGroup)((Object)curriculumModule)).getNumberOfAllEnroledCurriculumLines();
        }
        return result;
    }

    public int getNumberOfAllApprovedCurriculumLines() {
        int result = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (curriculumModule.isCurriculumLine()) {
                CurriculumLine curriculumLine = (CurriculumLine)((Object)curriculumModule);
                if (curriculumLine.isDismissal() && curriculumLine.hasCurricularCourse()) {
                    ++result;
                    continue;
                }
                if (!curriculumLine.isEnrolment() || !((Enrolment)((Object)curriculumLine)).isApproved()) continue;
                ++result;
                continue;
            }
            result += ((CurriculumGroup)((Object)curriculumModule)).getNumberOfAllApprovedCurriculumLines();
        }
        return result;
    }

    public final int getNumberOfChildEnrolments(ExecutionSemester executionSemester) {
        int result = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            Enrolment enrolment;
            if (!(curriculumModule instanceof Enrolment) || !(enrolment = (Enrolment)((Object)curriculumModule)).isValid(executionSemester) || !enrolment.isEnroled()) continue;
            ++result;
        }
        return result;
    }

    public int getNumberOfAllApprovedEnrolments(ExecutionSemester executionSemester) {
        int result = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result += curriculumModule.getNumberOfAllApprovedEnrolments(executionSemester);
        }
        return result;
    }

    public Set<IDegreeModuleToEvaluate> getDegreeModulesToEvaluate(ExecutionSemester executionSemester) {
        HashSet<IDegreeModuleToEvaluate> result = new HashSet<IDegreeModuleToEvaluate>();
        result.add(new EnroledCurriculumModuleWrapper((CurriculumModule)((Object)this), executionSemester));
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getDegreeModulesToEvaluate(executionSemester));
        }
        return result;
    }

    public Collection<Enrolment> getSpecialSeasonEnrolments(ExecutionYear executionYear) {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getSpecialSeasonEnrolments(executionYear));
        }
        return result;
    }

    public Collection<Enrolment> getSpecialSeasonEnrolments(ExecutionSemester executionSemester) {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            result.addAll(curriculumModule.getSpecialSeasonEnrolments(executionSemester));
        }
        return result;
    }

    public final void getAllDegreeModules(Collection<DegreeModule> degreeModules) {
        degreeModules.add((DegreeModule)((Object)this.getDegreeModule()));
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            curriculumModule.getAllDegreeModules(degreeModules);
        }
    }

    public CurriculumModule.ConclusionValue isConcluded(ExecutionYear executionYear) {
        if (this.isToCheckCreditsLimits(executionYear)) {
            return CurriculumModule.ConclusionValue.create(this.checkCreditsLimits(executionYear));
        }
        if (this.isToCheckDegreeModulesSelectionLimit(executionYear)) {
            return CurriculumModule.ConclusionValue.create(this.checkDegreeModulesSelectionLimit(executionYear));
        }
        return CurriculumModule.ConclusionValue.UNKNOWN;
    }

    public void assertCorrectStructure(Collection<CurriculumGroup> result, ExecutionYear lastApprovedYear) {
        if (this.isSkipConcluded()) {
            return;
        }
        for (CurriculumGroup curriculumGroup : this.getCurriculumGroups()) {
            if (curriculumGroup.getCurriculumGroups().isEmpty() && curriculumGroup.hasUnexpectedCredits(lastApprovedYear)) {
                result.add(curriculumGroup);
                continue;
            }
            curriculumGroup.assertCorrectStructure(result, lastApprovedYear);
        }
    }

    public boolean hasUnexpectedCredits(ExecutionYear lastApprovedYear) {
        return this.getAprovedEctsCredits().doubleValue() != this.getCreditsConcluded(lastApprovedYear).doubleValue();
    }

    public boolean hasInsufficientCredits() {
        return this.getAprovedEctsCredits() < this.getCreditsConcluded();
    }

    private boolean isToCheckDegreeModulesSelectionLimit(ExecutionYear executionYear) {
        return this.getMostRecentActiveCurricularRule(CurricularRuleType.DEGREE_MODULES_SELECTION_LIMIT, executionYear) != null;
    }

    private boolean isToCheckCreditsLimits(ExecutionYear executionYear) {
        return this.getMostRecentActiveCurricularRule(CurricularRuleType.CREDITS_LIMIT, executionYear) != null;
    }

    private boolean checkCreditsLimits(ExecutionYear executionYear) {
        CreditsLimit creditsLimit = (CreditsLimit)((Object)this.getMostRecentActiveCurricularRule(CurricularRuleType.CREDITS_LIMIT, executionYear));
        if (creditsLimit == null) {
            return false;
        }
        Double creditsConcluded = 0.0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isConcluded(executionYear).isValid()) continue;
            creditsConcluded = creditsConcluded + curriculumModule.getCreditsConcluded(executionYear);
        }
        return creditsConcluded >= creditsLimit.getMinimumCredits();
    }

    private boolean checkDegreeModulesSelectionLimit(ExecutionYear executionYear) {
        DegreeModulesSelectionLimit degreeModulesSelectionLimit = (DegreeModulesSelectionLimit)((Object)this.getMostRecentActiveCurricularRule(CurricularRuleType.DEGREE_MODULES_SELECTION_LIMIT, executionYear));
        if (degreeModulesSelectionLimit == null) {
            return false;
        }
        int modulesConcluded = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isConcluded(executionYear).value()) continue;
            ++modulesConcluded;
        }
        return modulesConcluded >= degreeModulesSelectionLimit.getMinimumLimit();
    }

    public boolean hasConcluded(DegreeModule degreeModule, ExecutionYear executionYear) {
        if (this.getDegreeModule() == degreeModule) {
            return this.isConcluded(executionYear).value();
        }
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.hasConcluded(degreeModule, executionYear)) continue;
            return true;
        }
        return false;
    }

    public YearMonthDay calculateConclusionDate() {
        HashSet curriculumModules = new HashSet(this.getCurriculumModulesSet());
        YearMonthDay result = null;
        for (CurriculumModule curriculumModule : curriculumModules) {
            YearMonthDay curriculumModuleConclusionDate;
            if (!curriculumModule.isConcluded(this.getApprovedCurriculumLinesLastExecutionYear()).isValid() || !curriculumModule.hasAnyApprovedCurriculumLines() || (curriculumModuleConclusionDate = curriculumModule.calculateConclusionDate()) == null || result != null && !curriculumModuleConclusionDate.isAfter((ReadablePartial)result)) continue;
            result = curriculumModuleConclusionDate;
        }
        return result;
    }

    public void assertConclusionDate(Collection<CurriculumModule> result) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            YearMonthDay curriculumModuleConclusionDate;
            if (!curriculumModule.isConcluded(this.getApprovedCurriculumLinesLastExecutionYear()).isValid() || !curriculumModule.hasAnyApprovedCurriculumLines() || (curriculumModuleConclusionDate = curriculumModule.calculateConclusionDate()) != null) continue;
            result.add(curriculumModule);
        }
    }

    public Curriculum getCurriculum(DateTime when, ExecutionYear executionYear) {
        Curriculum curriculum = Curriculum.createEmpty((CurriculumModule)((Object)this), executionYear);
        if (!this.wasCreated(when)) {
            return curriculum;
        }
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            curriculum.add(curriculumModule.getCurriculum(when, executionYear));
        }
        return curriculum;
    }

    public boolean isPropaedeutic() {
        return this.getCurriculumGroup() != null && this.getCurriculumGroup().isPropaedeutic();
    }

    public boolean isExtraCurriculum() {
        return false;
    }

    public boolean isStandalone() {
        return false;
    }

    public boolean canAdd(CurriculumLine curriculumLine) {
        if (!curriculumLine.hasCurricularCourse() || !curriculumLine.isBolonhaDegree()) {
            return true;
        }
        if (curriculumLine.isEnrolment() && curriculumLine instanceof OptionalEnrolment) {
            return this.getDegreeModule().hasDegreeModuleOnChilds((DegreeModule)((Object)((OptionalEnrolment)((Object)curriculumLine)).getOptionalCurricularCourse()));
        }
        return this.getDegreeModule().hasDegreeModuleOnChilds((DegreeModule)((Object)curriculumLine.getCurricularCourse()));
    }

    public Collection<CurriculumGroup> getCurricularCoursePossibleGroups(CurricularCourse curricularCourse) {
        HashSet<CurriculumGroup> result = new HashSet<CurriculumGroup>();
        if (this.getDegreeModule().hasDegreeModuleOnChilds((DegreeModule)((Object)curricularCourse))) {
            result.add(this);
        }
        for (CurriculumGroup curriculumGroup : this.getCurriculumGroups()) {
            result.addAll(curriculumGroup.getCurricularCoursePossibleGroups(curricularCourse));
        }
        return result;
    }

    public Collection<CurriculumGroup> getCurricularCoursePossibleGroupsWithoutNoCourseGroupCurriculumGroups(CurricularCourse curricularCourse) {
        HashSet<CurriculumGroup> result = new HashSet<CurriculumGroup>();
        if (this.getDegreeModule().hasDegreeModuleOnChilds((DegreeModule)((Object)curricularCourse))) {
            result.add(this);
        }
        for (CurriculumGroup curriculumGroup : this.getCurriculumGroups()) {
            result.addAll(curriculumGroup.getCurricularCoursePossibleGroupsWithoutNoCourseGroupCurriculumGroups(curricularCourse));
        }
        return result;
    }

    public Collection<NoCourseGroupCurriculumGroup> getNoCourseGroupCurriculumGroups() {
        HashSet<NoCourseGroupCurriculumGroup> res = new HashSet<NoCourseGroupCurriculumGroup>();
        for (CurriculumGroup curriculumGroup : this.getCurriculumGroups()) {
            res.addAll(curriculumGroup.getNoCourseGroupCurriculumGroups());
        }
        return res;
    }

    public int getNoCourseGroupCurriculumGroupsCount() {
        return this.getNoCourseGroupCurriculumGroups().size();
    }

    public boolean hasChildDegreeModule(DegreeModule degreeModule) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (curriculumModule.getDegreeModule() != degreeModule) continue;
            return true;
        }
        return false;
    }

    public CurriculumModule getChildCurriculumModule(DegreeModule degreeModule) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (curriculumModule.getDegreeModule() != degreeModule) continue;
            return curriculumModule;
        }
        return null;
    }

    public boolean hasEnrolment(ExecutionYear executionYear) {
        AndPredicate<CurriculumModule> andPredicate = new AndPredicate<CurriculumModule>();
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByType(Enrolment.class));
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByExecutionYear(executionYear));
        return this.hasAnyCurriculumModules(andPredicate);
    }

    public boolean hasEnrolment(ExecutionSemester executionSemester) {
        AndPredicate<CurriculumModule> andPredicate = new AndPredicate<CurriculumModule>();
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByType(Enrolment.class));
        andPredicate.add((Predicate)new CurriculumModule.CurriculumModulePredicateByExecutionSemester(executionSemester));
        return this.hasAnyCurriculumModules(andPredicate);
    }

    public boolean isEnroledInSpecialSeason(ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnroledInSpecialSeason(executionSemester)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnroledInSpecialSeason(ExecutionYear executionYear) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (!curriculumModule.isEnroledInSpecialSeason(executionYear)) continue;
            return true;
        }
        return false;
    }

    public Set<Enrolment> getEnrolmentsBy(ExecutionYear executionYear) {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.getExecutionYear() != executionYear) continue;
            result.add(enrolment);
        }
        return result;
    }

    public Set<Enrolment> getEnrolmentsBy(ExecutionSemester executionSemester) {
        HashSet<Enrolment> result = new HashSet<Enrolment>();
        for (Enrolment enrolment : this.getEnrolmentsSet()) {
            if (enrolment.getExecutionPeriod() != executionSemester) continue;
            result.add(enrolment);
        }
        return result;
    }

    public boolean hasEnrolmentInCurricularCourseBefore(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            CurriculumGroup curriculumGroup;
            Enrolment enrolment;
            if (!(curriculumModule.isEnrolment() ? !(enrolment = (Enrolment)((Object)curriculumModule)).isAnnulled() && enrolment.getExecutionPeriod().isBefore(executionSemester) && enrolment.getCurricularCourse() == curricularCourse : curriculumModule instanceof CurriculumGroup && (curriculumGroup = (CurriculumGroup)((Object)curriculumModule)).hasEnrolmentInCurricularCourseBefore(curricularCourse, executionSemester))) continue;
            return true;
        }
        return false;
    }

    public int calculateStudentAcumulatedEnrollments(CurricularCourse curricularCourse, ExecutionSemester executionSemester) {
        int result = 0;
        for (CurriculumModule curriculumModule : this.getCurriculumModulesSet()) {
            if (curriculumModule.isEnrolment()) {
                Enrolment enrolment = (Enrolment)((Object)curriculumModule);
                if (enrolment.isAnnulled() || !enrolment.getExecutionPeriod().isBefore(executionSemester) || !enrolment.getCurricularCourse().getCurricularCourseUniqueKeyForEnrollment().equalsIgnoreCase(curricularCourse.getCurricularCourseUniqueKeyForEnrollment())) continue;
                ++result;
                continue;
            }
            if (!(curriculumModule instanceof CurriculumGroup)) continue;
            CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)curriculumModule);
            result += curriculumGroup.calculateStudentAcumulatedEnrollments(curricularCourse, executionSemester);
        }
        return result;
    }

    public void setConclusionProcess(ConclusionProcess process2) {
        if (process2 != null && !process2.isActive()) {
            throw new DomainException("error.conclusion.process.not.valid", new String[0]);
        }
        super.setConclusionProcess(process2);
    }

    public ConclusionProcess getConclusionProcess() {
        ConclusionProcess conclusionProcess = super.getConclusionProcess();
        if (conclusionProcess != null && conclusionProcess.isActive()) {
            return conclusionProcess;
        }
        return null;
    }

    public void conclude() {
        AccessControl.check(this, CycleCurriculumGroupPredicates.MANAGE_CONCLUSION_PROCESS);
        if (this.isConclusionProcessed() && !this.getRegistration().canRepeatConclusionProcess(AccessControl.getPerson())) {
            throw new DomainException("error.CycleCurriculumGroup.cycle.is.already.concluded", this.getDegreeModule().getName());
        }
        ProgramConclusion conclusion = this.getDegreeModule().getProgramConclusion();
        if (conclusion == null) {
            throw new DomainException("error.program.conclusion.empty", new String[0]);
        }
        if (!this.isConcluded()) {
            throw new DomainException("error.CycleCurriculumGroup.cycle.is.not.concluded", new String[0]);
        }
        RegistrationConclusionBean bean = new RegistrationConclusionBean(this.getRegistration(), this);
        if (super.getConclusionProcess() != null) {
            super.getConclusionProcess().update(bean);
        } else {
            super.setConclusionProcess((ConclusionProcess)((Object)new ProgramConclusionProcess(bean)));
        }
    }

    public boolean isSkipConcluded() {
        return this.getDegreeModule() != null && this.getDegreeModule().getProgramConclusion() != null && this.getDegreeModule().getProgramConclusion().isSkipValidation();
    }

    public boolean isConcluded() {
        return this.isConclusionProcessed() || this.isSkipConcluded() || super.isConcluded();
    }

    public boolean isConclusionProcessed() {
        return this.getConclusionProcess() != null;
    }

    public final ExecutionYear getIngressionYear() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getIngressionYear() : this.getRegistration().calculateIngressionYear();
    }

    public final ExecutionYear calculateIngressionYear() {
        return this.getRegistration().calculateIngressionYear();
    }

    public final Grade getRawGrade() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getRawGrade() : null;
    }

    public final Grade getFinalGrade() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getFinalGrade() : null;
    }

    public final Grade getDescriptiveGrade() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getDescriptiveGrade() : null;
    }

    public final ExecutionYear getConclusionYear() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getConclusionYear() : null;
    }

    public final Person getConclusionProcessResponsible() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getResponsible() : null;
    }

    public final Person getConclusionProcessLastResponsible() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getLastResponsible() : null;
    }

    public final String getConclusionProcessNotes() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getNotes() : null;
    }

    public final DateTime getConclusionProcessCreationDateTime() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getCreationDateTime() : null;
    }

    public final DateTime getConclusionProcessLastModificationDateTime() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getLastModificationDateTime() : null;
    }

    public void editConclusionInformation(Person editor, Grade finalGrade, Grade rawGrade, Grade descriptiveGrade, YearMonthDay conclusion, String notes) {
        if (!this.isConclusionProcessed()) {
            throw new DomainException("error.org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup.its.only.possible.to.edit.after.conclusion.process.has.been.performed", new String[0]);
        }
        if (finalGrade == null || rawGrade == null || conclusion == null) {
            throw new DomainException("error.CycleCurriculumGroup.argument.must.not.be.null", new String[0]);
        }
        this.getConclusionProcess().update(editor, finalGrade, rawGrade, descriptiveGrade, conclusion.toLocalDate(), notes);
    }

    public final ExecutionYear calculateConclusionYear() {
        return this.getLastApprovementExecutionYear();
    }

    public final YearMonthDay getConclusionDate() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getConclusionYearMonthDay() : null;
    }

    public Double getCreditsConcluded() {
        return this.isConclusionProcessed() ? this.getConclusionProcess().getCredits().doubleValue() : this.calculateCreditsConcluded().doubleValue();
    }

    public final Double calculateCreditsConcluded() {
        return super.getCreditsConcluded();
    }
}

