/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.documents.DocumentRequestGeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistryCode;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.domain.student.curriculum.ICurriculumEntry;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.dto.serviceRequests.DocumentRequestCreateBean;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.joda.time.LocalDate;

public abstract class DocumentRequest
extends DocumentRequest_Base
implements IDocumentRequest {
    public static Comparator<AcademicServiceRequest> COMPARATOR_BY_REGISTRY_NUMBER = new Comparator<AcademicServiceRequest>(){

        @Override
        public int compare(AcademicServiceRequest o1, AcademicServiceRequest o2) {
            int codeCompare = RegistryCode.COMPARATOR_BY_CODE.compare(o1.getRegistryCode(), o2.getRegistryCode());
            if (codeCompare != 0) {
                return codeCompare;
            }
            return o1.getExternalId().compareTo(o2.getExternalId());
        }
    };

    protected DocumentRequest() {
    }

    protected void checkParameters(DocumentRequestCreateBean bean) {
        if (bean.getChosenDocumentPurposeType() != null && bean.getChosenDocumentPurposeType().getDocumentPurposeType() == DocumentPurposeType.OTHER && bean.getOtherPurpose() == null) {
            throw new DomainException("error.serviceRequests.documentRequests.DocumentRequest.otherDocumentPurposeTypeDescription.cannot.be.null.for.other.purpose.type", new String[0]);
        }
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.getAcademicServiceRequestType(), this.getDocumentRequestType().getQualifiedName());
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.DOCUMENT;
    }

    @Override
    public abstract DocumentRequestType getDocumentRequestType();

    @Override
    public abstract String getDocumentTemplateKey();

    public abstract boolean isPagedDocument();

    @Override
    public final boolean isCertificate() {
        return this.getDocumentRequestType().isCertificate();
    }

    public final boolean isDeclaration() {
        return this.getDocumentRequestType().isDeclaration();
    }

    @Override
    public final boolean isDiploma() {
        return this.getDocumentRequestType().isDiploma();
    }

    public final boolean isPastDiploma() {
        return this.getDocumentRequestType().isPastDiploma();
    }

    public boolean isRegistryDiploma() {
        return this.getDocumentRequestType().isRegistryDiploma();
    }

    public final boolean isDiplomaSupplement() {
        return this.getDocumentRequestType().isDiplomaSupplement();
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
    }

    protected void assertPayedEvents(ExecutionYear executionYear) {
        if (executionYear != null && TreasuryBridgeAPIFactory.implementation().isAcademicalActsBlocked(this.getPerson(), new LocalDate())) {
            throw new DomainException("DocumentRequest.student.has.not.payed.debts", new String[0]);
        }
    }

    public boolean isDownloadPossible() {
        return this.getLastGeneratedDocument() != null && !this.isCancelled() && !this.isRejected();
    }

    @Override
    public final boolean isToShowCredits() {
        return !this.getDegreeType().isPreBolonhaDegree();
    }

    public boolean hasNumberOfPages() {
        return this.getNumberOfPages() != null && this.getNumberOfPages() != 0;
    }

    public Locale getLocale() {
        return null;
    }

    protected void checkRulesToDelete() {
        super.checkRulesToDelete();
        if (this.hasRegistryCode()) {
            throw new DomainException("error.AcademicServiceRequest.cannot.be.deleted", new String[0]);
        }
    }

    @Override
    public byte[] generateDocument() {
        try {
            List<AdministrativeOfficeDocument> documents = AdministrativeOfficeDocument.AdministrativeOfficeDocumentCreator.create(this);
            AdministrativeOfficeDocument[] array = new AdministrativeOfficeDocument[]{};
            byte[] data = ReportsUtils.generateReport(documents.toArray(array)).getData();
            DocumentRequestGeneratedDocument.store(this, ((AdministrativeOfficeDocument)documents.iterator().next()).getReportFileName() + ".pdf", data);
            return data;
        }
        catch (Exception e) {
            throw new DomainException("error.documentRequest.errorGeneratingDocument", e, new String[0]);
        }
    }

    @Override
    public String getReportFileName() {
        return ((AdministrativeOfficeDocument)AdministrativeOfficeDocument.AdministrativeOfficeDocumentCreator.create(this).iterator().next()).getReportFileName();
    }

    public Collection<ICurriculumEntry> getApprovedCurriculumEntries() {
        return null;
    }
}

