/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestTypeOption$callable$create;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestTypeOption$callable$edit;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestTypeOptionBooleanValue;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestTypeOption_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ServiceRequestTypeOption
extends ServiceRequestTypeOption_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected ServiceRequestTypeOption() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected ServiceRequestTypeOption(String code, LocalizedString name, boolean detailedOption, boolean numberOfUnitsOption) {
        this();
        super.setCode(code);
        super.setName(name);
        super.setDetailedOption(detailedOption);
        super.setNumberOfUnitsOption(numberOfUnitsOption);
        this.checkRules();
    }

    private void checkRules() {
        if (Strings.isNullOrEmpty((String)this.getCode())) {
            throw new DomainException("error.ServiceRequestTypeOption.code.required", new String[0]);
        }
        if (ServiceRequestTypeOption.isTrimmedEmpty(this.getName())) {
            throw new DomainException("error.ServiceRequestTypeOption.name.required", new String[0]);
        }
    }

    public void edit(String string, LocalizedString localizedString) {
        Object object = advice$edit.perform((Callable)new ServiceRequestTypeOption$callable$edit(this, string, localizedString));
    }

    static /* synthetic */ void advised$edit(ServiceRequestTypeOption this_, String code, LocalizedString name) {
        super.setCode(code);
        super.setName(name);
        this_.checkRules();
    }

    public static boolean isTrimmedEmpty(LocalizedString localizedString) {
        if (localizedString == null || localizedString.getLocales().isEmpty()) {
            return true;
        }
        boolean empty = true;
        for (Locale locale : localizedString.getLocales()) {
            empty &= Strings.isNullOrEmpty((String)localizedString.getContent(locale));
        }
        return empty;
    }

    public boolean isDetailedOption() {
        return this.getDetailedOption();
    }

    public boolean isNumberOfUnitsOption() {
        return this.getNumberOfUnitsOption();
    }

    public static Map<ServiceRequestTypeOption, Boolean> optionValuesMap(AcademicServiceRequest academicServiceRequest) {
        Set values = academicServiceRequest.getServiceRequestTypeOptionBooleanValuesSet();
        HashMap result = Maps.newHashMap();
        for (ServiceRequestTypeOptionBooleanValue serviceRequestTypeOptionBooleanValue : values) {
            result.put(serviceRequestTypeOptionBooleanValue.getServiceRequestTypeOption(), serviceRequestTypeOptionBooleanValue.getValue());
        }
        return result;
    }

    public static Stream<ServiceRequestTypeOption> findAll() {
        return Bennu.getInstance().getServiceRequestTypeOptionsSet().stream();
    }

    public static Optional<ServiceRequestTypeOption> findDetailedOption() {
        return ServiceRequestTypeOption.findAll().filter(s -> s.isDetailedOption()).findFirst();
    }

    public static Optional<ServiceRequestTypeOption> findNumberOfUnitsOption() {
        return ServiceRequestTypeOption.findAll().filter(ServiceRequestTypeOption::isNumberOfUnitsOption).findFirst();
    }

    public static ServiceRequestTypeOption create(String string, LocalizedString localizedString, boolean bl, boolean bl2) {
        return (ServiceRequestTypeOption)((Object)advice$create.perform((Callable)new ServiceRequestTypeOption$callable$create(string, localizedString, bl, bl2)));
    }

    static /* synthetic */ ServiceRequestTypeOption advised$create(String code, LocalizedString name, boolean detailedOption, boolean numberOfUnitsOption) {
        return new ServiceRequestTypeOption(code, name, detailedOption, numberOfUnitsOption);
    }
}

