/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.serviceRequests.documentRequests;

import java.util.List;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.documents.DocumentRequestGeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdDocumentRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDocumentRequest_Base;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.AcademicServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IDocumentRequest;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PhdDocumentRequest
extends PhdDocumentRequest_Base
implements IDocumentRequest {
    private static final Logger logger = LoggerFactory.getLogger(PhdDocumentRequest.class);

    protected PhdDocumentRequest() {
    }

    protected void init(PhdAcademicServiceRequestCreateBean bean) {
        throw new DomainException("invoke init(PhdAcademicServiceRequestCreateBean)", new String[0]);
    }

    protected void init(PhdDocumentRequestCreateBean bean) {
        super.init((PhdAcademicServiceRequestCreateBean)bean);
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.getAcademicServiceRequestType(), this.getDocumentRequestType().getQualifiedName());
    }

    public AcademicServiceRequestType getAcademicServiceRequestType() {
        return AcademicServiceRequestType.DOCUMENT;
    }

    @Override
    public abstract DocumentRequestType getDocumentRequestType();

    @Override
    public abstract String getDocumentTemplateKey();

    @Override
    public final boolean isDiploma() {
        return this.getDocumentRequestType().isDiploma();
    }

    public boolean isRegistryDiploma() {
        return this.getDocumentRequestType().isRegistryDiploma();
    }

    public final boolean isDiplomaSupplement() {
        return this.getDocumentRequestType().isDiplomaSupplement();
    }

    @Override
    public boolean isCertificate() {
        return false;
    }

    @Override
    public boolean isToShowCredits() {
        return false;
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess() && !this.getFreeProcessed().booleanValue()) {
            this.assertPayedEvents();
        }
    }

    protected void assertPayedEvents() {
        if (this.getPhdIndividualProgramProcess().hasInsuranceDebtsCurrently()) {
            throw new PhdDomainOperationException("DocumentRequest.registration.has.not.payed.insurance.fees", new String[0]);
        }
        if (this.getPhdIndividualProgramProcess().hasAdministrativeOfficeFeeAndInsuranceDebtsCurrently(this.getAdministrativeOffice())) {
            throw new PhdDomainOperationException("DocumentRequest.registration.has.not.payed.administrative.office.fees", new String[0]);
        }
    }

    protected void assertPayedEvents(ExecutionYear executionYear) {
        if (executionYear != null) {
            if (this.getPhdIndividualProgramProcess().hasInsuranceDebts(executionYear)) {
                throw new PhdDomainOperationException("DocumentRequest.registration.has.not.payed.insurance.fees", new String[0]);
            }
            if (this.getPhdIndividualProgramProcess().hasAdministrativeOfficeFeeAndInsuranceDebts(this.getAdministrativeOffice(), executionYear)) {
                throw new PhdDomainOperationException("DocumentRequest.registration.has.not.payed.administrative.office.fees", new String[0]);
            }
        }
    }

    public boolean isDownloadPossible() {
        return this.getLastGeneratedDocument() != null;
    }

    public boolean hasNumberOfPages() {
        return this.getNumberOfPages() != null && this.getNumberOfPages() != 0;
    }

    @Override
    public byte[] generateDocument() {
        try {
            List<AdministrativeOfficeDocument> documents = AdministrativeOfficeDocument.AdministrativeOfficeDocumentCreator.create(this);
            AdministrativeOfficeDocument[] array = new AdministrativeOfficeDocument[]{};
            byte[] data = ReportsUtils.generateReport(documents.toArray(array)).getData();
            DocumentRequestGeneratedDocument.store(this, ((AdministrativeOfficeDocument)documents.iterator().next()).getReportFileName() + ".pdf", data);
            return data;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DomainException("error.documentRequest.errorGeneratingDocument", new String[0]);
        }
    }

    @Override
    public String getReportFileName() {
        return ((AdministrativeOfficeDocument)AdministrativeOfficeDocument.AdministrativeOfficeDocumentCreator.create(this).iterator().next()).getReportFileName();
    }
}

