/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.phd.serviceRequests.documentRequests;

import java.util.List;
import java.util.Locale;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.ProgramConclusion;
import org.fenixedu.academic.domain.documents.DocumentRequestGeneratedDocument;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.exceptions.PhdDomainOperationException;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdAcademicServiceRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.PhdDocumentRequestCreateBean;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdDiplomaRequest_Base;
import org.fenixedu.academic.domain.phd.serviceRequests.documentRequests.PhdRegistryDiplomaRequest;
import org.fenixedu.academic.domain.phd.thesis.PhdThesisFinalGrade;
import org.fenixedu.academic.domain.serviceRequests.AcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.IDiplomaRequest;
import org.fenixedu.academic.domain.serviceRequests.RegistryCode;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.IRectorateSubmissionBatchDocumentEntry;
import org.fenixedu.academic.dto.serviceRequests.AcademicServiceRequestBean;
import org.fenixedu.academic.report.academicAdministrativeOffice.AdministrativeOfficeDocument;
import org.fenixedu.academic.util.report.ReportsUtils;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.LocalDate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhdDiplomaRequest
extends PhdDiplomaRequest_Base
implements IDiplomaRequest,
IRectorateSubmissionBatchDocumentEntry {
    private static final Logger logger = LoggerFactory.getLogger(PhdDiplomaRequest.class);

    protected PhdDiplomaRequest() {
    }

    protected PhdDiplomaRequest(PhdDocumentRequestCreateBean bean) {
        this.init(bean);
    }

    protected void init(PhdAcademicServiceRequestCreateBean bean) {
        throw new DomainException("invoke init(PhdDocumentRequestCreateBean)", new String[0]);
    }

    protected void init(PhdDocumentRequestCreateBean bean) {
        this.checkParameters(bean);
        super.init(bean);
        this.applyRegistryCode();
    }

    private void applyRegistryCode() {
        RegistryCode code = this.getRegistryCode();
        if (code != null) {
            if (!code.getDocumentRequestSet().contains(this)) {
                code.addDocumentRequest((AcademicServiceRequest)((Object)this));
            }
        } else {
            this.getRootDomainObject().getInstitutionUnit().getRegistryCodeGenerator().createRegistryFor((AcademicServiceRequest)((Object)this));
        }
    }

    private void checkParameters(PhdDocumentRequestCreateBean bean) {
        PhdIndividualProgramProcess process2 = bean.getPhdIndividualProgramProcess();
        if (process2.hasDiplomaRequest()) {
            throw new PhdDomainOperationException("error.phdDiploma.alreadyHasDiplomaRequest", new String[0]);
        }
        this.checkRegistryDiplomaRequest(process2);
    }

    private void checkRegistryDiplomaRequest(PhdIndividualProgramProcess process2) {
        if (!process2.isBolonha().booleanValue()) {
            return;
        }
        if (!process2.hasRegistryDiplomaRequest()) {
            throw new PhdDomainOperationException("error.phdDiploma.registryDiploma.must.be.requested", new String[0]);
        }
        PhdRegistryDiplomaRequest phdRegistryDiploma = process2.getRegistryDiplomaRequest();
    }

    @Override
    public DocumentRequestType getDocumentRequestType() {
        return DocumentRequestType.DIPLOMA_REQUEST;
    }

    @Override
    public String getDescription() {
        return this.getDescription(this.getAcademicServiceRequestType(), this.getDocumentRequestType().getQualifiedName() + "." + "PHD");
    }

    @Override
    public String getDocumentTemplateKey() {
        return PhdDiplomaRequest.class.getName();
    }

    public boolean isPayedUponCreation() {
        return false;
    }

    public boolean isToPrint() {
        return true;
    }

    public boolean isPossibleToSendToOtherEntity() {
        return true;
    }

    public boolean isManagedWithRectorateSubmissionBatch() {
        return true;
    }

    @Override
    public EventType getEventType() {
        return EventType.BOLONHA_PHD_DIPLOMA_REQUEST;
    }

    public boolean hasPersonalInfo() {
        return true;
    }

    @Override
    public RegistryCode getRegistryCode() {
        PhdIndividualProgramProcess phdIndividualProgramProcess = this.getPhdIndividualProgramProcess();
        RegistryCode registryCode = null;
        if (phdIndividualProgramProcess.hasRegistryDiplomaRequest()) {
            registryCode = phdIndividualProgramProcess.getRegistryDiplomaRequest().getRegistryCode();
        }
        return registryCode != null ? registryCode : super.getRegistryCode();
    }

    protected void internalChangeState(AcademicServiceRequestBean academicServiceRequestBean) {
        try {
            this.verifyIsToProcessAndHasPersonalInfo(academicServiceRequestBean);
            this.verifyIsToDeliveredAndIsPayed(academicServiceRequestBean);
        }
        catch (DomainException e) {
            throw new PhdDomainOperationException(e.getKey(), (Throwable)((Object)e), e.getArgs());
        }
        super.internalChangeState(academicServiceRequestBean);
        if (academicServiceRequestBean.isToProcess()) {
            if (!this.getPhdIndividualProgramProcess().isConclusionProcessed()) {
                throw new PhdDomainOperationException("error.registryDiploma.registrationNotSubmitedToConclusionProcess", new String[0]);
            }
            this.getAdministrativeOffice().getCurrentRectorateSubmissionBatch().addDocumentRequest((AcademicServiceRequest)((Object)this));
            if (this.getLastGeneratedDocument() == null) {
                this.generateDocument();
            }
        }
    }

    @Override
    public CycleType getRequestedCycle() {
        return CycleType.THIRD_CYCLE;
    }

    @Override
    public LocalDate getConclusionDate() {
        return this.getPhdIndividualProgramProcess().getConclusionDate();
    }

    @Override
    public Integer getFinalAverage() {
        return null;
    }

    @Override
    public String getFinalAverageQualified() {
        return null;
    }

    @Override
    public String getDissertationThesisTitle() {
        return this.getPhdIndividualProgramProcess().getThesisTitle();
    }

    @Override
    public String getGraduateTitle(Locale locale) {
        return this.getPhdIndividualProgramProcess().getGraduateTitle(locale);
    }

    public PhdThesisFinalGrade getThesisFinalGrade() {
        return this.getPhdIndividualProgramProcess().getFinalGrade();
    }

    public Boolean isBolonha() {
        return this.getPhdIndividualProgramProcess().isBolonha();
    }

    public static PhdDiplomaRequest create(PhdDocumentRequestCreateBean bean) {
        return new PhdDiplomaRequest(bean);
    }

    @Override
    public String getProgrammeTypeDescription() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)"label.php.program", (String[])new String[0]);
    }

    @Override
    public String getViewStudentProgrammeLink() {
        return "/phdIndividualProgramProcess.do?method=viewProcess&amp;processId=" + this.getPhdIndividualProgramProcess().getExternalId();
    }

    @Override
    public String getReceivedActionLink() {
        return String.format("/phdAcademicServiceRequestManagement.do?method=prepareReceiveOnRectorate&amp;phdAcademicServiceRequestId=%s&amp;batchOid=%s", this.getExternalId(), this.getRectorateSubmissionBatch().getExternalId());
    }

    @Override
    public boolean isProgrammeLinkVisible() {
        return this.getPhdIndividualProgramProcess().isCurrentUserAllowedToManageProcess();
    }

    @Override
    public byte[] generateDocument() {
        try {
            List<AdministrativeOfficeDocument> documents = AdministrativeOfficeDocument.AdministrativeOfficeDocumentCreator.create(this);
            AdministrativeOfficeDocument[] array = new AdministrativeOfficeDocument[]{};
            byte[] data = ReportsUtils.generateReport(documents.toArray(array)).getData();
            DocumentRequestGeneratedDocument.store(this, ((AdministrativeOfficeDocument)documents.iterator().next()).getReportFileName() + ".pdf", data);
            return data;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new DomainException("error.phdDiplomaRequest.errorGeneratingDocument", new String[0]);
        }
    }

    @Override
    public ProgramConclusion getProgramConclusion() {
        return ProgramConclusion.conclusionsFor(this.getPhdIndividualProgramProcess().getRegistration()).findAny().orElse(null);
    }
}

