/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.contacts;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;

public class PhysicalAddressData
implements Serializable {
    private String address;
    private String areaCode;
    private String areaOfAreaCode;
    private String area;
    private String parishOfResidence;
    private String districtSubdivisionOfResidence;
    private String districtOfResidence;
    private Country countryOfResidence;

    public PhysicalAddressData() {
    }

    public PhysicalAddressData(PhysicalAddress address) {
        this.setAddress(address.getAddress());
        this.setAreaCode(address.getAreaCode());
        this.setAreaOfAreaCode(address.getAreaOfAreaCode());
        this.setArea(address.getArea());
        this.setParishOfResidence(address.getParishOfResidence());
        this.setDistrictSubdivisionOfResidence(address.getDistrictSubdivisionOfResidence());
        this.setDistrictOfResidence(address.getDistrictOfResidence());
        this.setCountryOfResidence(address.getCountryOfResidence());
    }

    public PhysicalAddressData(String address, String areaCode, String areaOfAreaCode, String area) {
        this(address, areaCode, areaOfAreaCode, area, null, null, null, null);
    }

    public PhysicalAddressData(String address, String areaCode, String areaOfAreaCode, String area, String parishOfResidence, String districtSubdivisionOfResidence, String districtOfResidence, Country countryOfResidence) {
        this.setAddress(address);
        this.setAreaCode(areaCode);
        this.setAreaOfAreaCode(areaOfAreaCode);
        this.setArea(area);
        this.setParishOfResidence(parishOfResidence);
        this.setDistrictSubdivisionOfResidence(districtSubdivisionOfResidence);
        this.setDistrictOfResidence(districtOfResidence);
        this.setCountryOfResidence(countryOfResidence);
    }

    public String getAddress() {
        return this.ifNullReturnEmpty(this.address);
    }

    public PhysicalAddressData setAddress(String address) {
        this.address = address;
        return this;
    }

    public String getArea() {
        return this.ifNullReturnEmpty(this.area);
    }

    public PhysicalAddressData setArea(String area) {
        this.area = area;
        return this;
    }

    public String getAreaCode() {
        return this.ifNullReturnEmpty(this.areaCode);
    }

    public PhysicalAddressData setAreaCode(String areaCode) {
        this.areaCode = areaCode;
        return this;
    }

    private String ifNullReturnEmpty(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    public String getAreaOfAreaCode() {
        return this.ifNullReturnEmpty(this.areaOfAreaCode);
    }

    public PhysicalAddressData setAreaOfAreaCode(String areaOfAreaCode) {
        this.areaOfAreaCode = areaOfAreaCode;
        return this;
    }

    public String getDistrictOfResidence() {
        return this.ifNullReturnEmpty(this.districtOfResidence);
    }

    public PhysicalAddressData setDistrictOfResidence(String districtOfResidence) {
        this.districtOfResidence = districtOfResidence;
        return this;
    }

    public String getDistrictSubdivisionOfResidence() {
        return this.ifNullReturnEmpty(this.districtSubdivisionOfResidence);
    }

    public PhysicalAddressData setDistrictSubdivisionOfResidence(String districtSubdivisionOfResidence) {
        this.districtSubdivisionOfResidence = districtSubdivisionOfResidence;
        return this;
    }

    public String getParishOfResidence() {
        return this.ifNullReturnEmpty(this.parishOfResidence);
    }

    public PhysicalAddressData setParishOfResidence(String parishOfResidence) {
        this.parishOfResidence = parishOfResidence;
        return this;
    }

    private String getCountryOfResidenceName() {
        return this.getCountryOfResidence() == null ? "" : this.getCountryOfResidence().getName();
    }

    public Country getCountryOfResidence() {
        return this.countryOfResidence;
    }

    public PhysicalAddressData setCountryOfResidence(Country countryOfResidence) {
        this.countryOfResidence = countryOfResidence;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PhysicalAddressData) {
            PhysicalAddressData data = (PhysicalAddressData)obj;
            return this.getAddress().equals(data.getAddress()) && this.getAreaCode().equals(data.getAreaCode()) && this.getAreaOfAreaCode().equals(data.getAreaOfAreaCode()) && this.getArea().equals(data.getArea()) && this.getParishOfResidence().equals(data.getParishOfResidence()) && this.getDistrictSubdivisionOfResidence().equals(data.getDistrictSubdivisionOfResidence()) && this.getDistrictOfResidence().equals(data.getDistrictOfResidence()) && this.getCountryOfResidenceName().equals(data.getCountryOfResidenceName());
        }
        return false;
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.address) && StringUtils.isEmpty((String)this.areaCode) && StringUtils.isEmpty((String)this.areaOfAreaCode) && StringUtils.isEmpty((String)this.area) && StringUtils.isEmpty((String)this.parishOfResidence) && StringUtils.isEmpty((String)this.districtSubdivisionOfResidence) && StringUtils.isEmpty((String)this.districtOfResidence) && this.countryOfResidence == null;
    }
}

