/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess.erasmus;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementDocumentFile$callable$createCandidacyDocument;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementDocumentFile$callable$markLearningAgreementSent;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementDocumentFile$callable$markLearningAgreementViewed;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementDocumentFile_Base;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ApprovedLearningAgreementExecutedAction;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ExecutedAction;
import org.fenixedu.academic.domain.candidacyProcess.erasmus.ExecutedActionType;
import org.fenixedu.academic.domain.candidacyProcess.mobility.MobilityIndividualApplicationProcess;
import org.fenixedu.academic.util.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ApprovedLearningAgreementDocumentFile
extends ApprovedLearningAgreementDocumentFile_Base {
    public static final Comparator<ApprovedLearningAgreementDocumentFile> SUBMISSION_DATE_COMPARATOR;
    public static final Advice advice$createCandidacyDocument;
    public static final Advice advice$markLearningAgreementViewed;
    public static final Advice advice$markLearningAgreementSent;

    private ApprovedLearningAgreementDocumentFile() {
        this.setCandidacyFileActive(Boolean.TRUE);
    }

    protected ApprovedLearningAgreementDocumentFile(byte[] contents, String filename) {
        this();
        this.setCandidacyFileActive(Boolean.TRUE);
        this.setCandidacyFileType(IndividualCandidacyDocumentFileType.APPROVED_LEARNING_AGREEMENT);
        this.init(filename, filename, contents);
    }

    public void setFilename(String filename) {
        super.setFilename(FileUtils.cleanupUserInputFilename(filename));
    }

    public void setDisplayName(String displayName) {
        super.setDisplayName(FileUtils.cleanupUserInputFileDisplayName(displayName));
    }

    public static ApprovedLearningAgreementDocumentFile createCandidacyDocument(byte[] byArray, String string, String string2, String string3) {
        return (ApprovedLearningAgreementDocumentFile)((Object)advice$createCandidacyDocument.perform((Callable)new ApprovedLearningAgreementDocumentFile$callable$createCandidacyDocument(byArray, string, string2, string3)));
    }

    static /* synthetic */ ApprovedLearningAgreementDocumentFile advised$createCandidacyDocument(byte[] contents, String filename, String processName, String documentIdNumber) {
        return new ApprovedLearningAgreementDocumentFile(contents, filename);
    }

    public void markLearningAgreementViewed() {
        Object object = advice$markLearningAgreementViewed.perform((Callable)new ApprovedLearningAgreementDocumentFile$callable$markLearningAgreementViewed(this));
    }

    static /* synthetic */ void advised$markLearningAgreementViewed(ApprovedLearningAgreementDocumentFile this_) {
        new ApprovedLearningAgreementExecutedAction(this_, ExecutedActionType.VIEWED_APPROVED_LEARNING_AGREEMENT);
    }

    public void markLearningAgreementSent() {
        Object object = advice$markLearningAgreementSent.perform((Callable)new ApprovedLearningAgreementDocumentFile$callable$markLearningAgreementSent(this));
    }

    static /* synthetic */ void advised$markLearningAgreementSent(ApprovedLearningAgreementDocumentFile this_) {
        new ApprovedLearningAgreementExecutedAction(this_, ExecutedActionType.SENT_APPROVED_LEARNING_AGREEMENT);
    }

    public boolean isApprovedLearningAgreementSent() {
        return !this.getSentLearningAgreementActions().isEmpty();
    }

    public boolean isApprovedLearningAgreementViewed() {
        return !this.getViewedLearningAgreementActions().isEmpty();
    }

    protected List<ApprovedLearningAgreementExecutedAction> getSentLearningAgreementActions() {
        ArrayList<ApprovedLearningAgreementExecutedAction> executedActionList = new ArrayList<ApprovedLearningAgreementExecutedAction>();
        CollectionUtils.select((Collection)this.getExecutedActionsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((ApprovedLearningAgreementExecutedAction)((Object)arg0)).isSentLearningAgreementAction();
            }
        }, executedActionList);
        Collections.sort(executedActionList, Collections.reverseOrder(ExecutedAction.WHEN_OCCURED_COMPARATOR));
        return executedActionList;
    }

    public ApprovedLearningAgreementExecutedAction getMostRecentSentLearningAgreementAction() {
        List<ApprovedLearningAgreementExecutedAction> executedActionList = this.getSentLearningAgreementActions();
        return executedActionList.isEmpty() ? null : executedActionList.iterator().next();
    }

    public DateTime getMostRecentSentLearningAgreementActionWhenOccured() {
        if (this.getMostRecentSentLearningAgreementAction() == null) {
            return null;
        }
        return this.getMostRecentSentLearningAgreementAction().getWhenOccured();
    }

    protected List<ApprovedLearningAgreementExecutedAction> getViewedLearningAgreementActions() {
        ArrayList<ApprovedLearningAgreementExecutedAction> executedActionList = new ArrayList<ApprovedLearningAgreementExecutedAction>();
        CollectionUtils.select((Collection)this.getExecutedActionsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((ApprovedLearningAgreementExecutedAction)((Object)arg0)).isViewedLearningAgreementAction();
            }
        }, executedActionList);
        Collections.sort(executedActionList, Collections.reverseOrder(ExecutedAction.WHEN_OCCURED_COMPARATOR));
        return executedActionList;
    }

    public ApprovedLearningAgreementExecutedAction getMostRecentViewedLearningAgreementAction() {
        List<ApprovedLearningAgreementExecutedAction> executedActionList = this.getViewedLearningAgreementActions();
        return executedActionList.isEmpty() ? null : executedActionList.iterator().next();
    }

    public DateTime getMostRecentViewedLearningAgreementActionWhenOccured() {
        if (this.getMostRecentViewedLearningAgreementAction() == null) {
            return null;
        }
        return this.getMostRecentViewedLearningAgreementAction().getWhenOccured();
    }

    protected List<ApprovedLearningAgreementExecutedAction> getSentEmailAcceptedStudentActions() {
        ArrayList<ApprovedLearningAgreementExecutedAction> executedActionList = new ArrayList<ApprovedLearningAgreementExecutedAction>();
        CollectionUtils.select((Collection)this.getExecutedActionsSet(), (Predicate)new Predicate(){

            public boolean evaluate(Object arg0) {
                return ((ApprovedLearningAgreementExecutedAction)((Object)arg0)).isSentEmailAcceptedStudent();
            }
        }, executedActionList);
        Collections.sort(executedActionList, Collections.reverseOrder(ExecutedAction.WHEN_OCCURED_COMPARATOR));
        return executedActionList;
    }

    public ApprovedLearningAgreementExecutedAction getMostRecentSentEmailAcceptedStudentAction() {
        List<ApprovedLearningAgreementExecutedAction> executedActionList = this.getSentEmailAcceptedStudentActions();
        return executedActionList.isEmpty() ? null : executedActionList.iterator().next();
    }

    public DateTime getMostRecentSentEmailAcceptedStudentActionWhenOccured() {
        if (this.getMostRecentSentEmailAcceptedStudentAction() == null) {
            return null;
        }
        return this.getMostRecentSentEmailAcceptedStudentAction().getWhenOccured();
    }

    public boolean isMostRecent() {
        return this.getMobilityIndividualApplication().getMostRecentApprovedLearningAgreement() == this;
    }

    public MobilityIndividualApplicationProcess getProcess() {
        return this.getMobilityIndividualApplication().getCandidacyProcess();
    }

    public boolean isAbleToSendEmailToAcceptStudent() {
        return this.getProcess().isStudentAccepted() && this.isMostRecent() && this.getCandidacyFileActive() != false;
    }

    static {
        advice$createCandidacyDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markLearningAgreementViewed = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markLearningAgreementSent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        SUBMISSION_DATE_COMPARATOR = new Comparator<ApprovedLearningAgreementDocumentFile>(){

            @Override
            public int compare(ApprovedLearningAgreementDocumentFile o1, ApprovedLearningAgreementDocumentFile o2) {
                return o1.getCreationDate().compareTo((ReadableInstant)o2.getCreationDate());
            }
        };
    }
}

