/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcess;
import org.fenixedu.academic.domain.candidacyProcess.CandidacyProcessDocumentUploadBean;
import org.fenixedu.academic.domain.candidacyProcess.DegreeOfficePublicCandidacyHashCode;
import org.fenixedu.academic.domain.candidacyProcess.Formation;
import org.fenixedu.academic.domain.candidacyProcess.FormationBean;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyDocumentFileType;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyProcess;
import org.fenixedu.academic.dto.person.ChoosePersonBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.joda.time.LocalDate;

public abstract class IndividualCandidacyProcessBean
implements Serializable {
    private static final long serialVersionUID = 2860833709120576930L;
    private Boolean internalPersonCandidacy = Boolean.TRUE;
    private CandidacyProcess candidacyProcess;
    private DegreeOfficePublicCandidacyHashCode publicCandidacyHashCode;
    private IndividualCandidacyProcess individualCandidacyProcess;
    private ChoosePersonBean choosePersonBean;
    private PersonBean personBean;
    private LocalDate candidacyDate;
    private String observations;
    private Boolean processChecked;
    private String personNumber;
    private Boolean publicCandidacyCreationOrEdition;
    private Integer numberOfPreviousYearEnrolmentsInPrecedentDegree;
    private CandidacyProcessDocumentUploadBean documentIdentificationDocument;
    private CandidacyProcessDocumentUploadBean paymentDocument;
    private CandidacyProcessDocumentUploadBean habilitationCertificationDocument;
    private CandidacyProcessDocumentUploadBean firstCycleAccessHabilitationDocument;
    private CandidacyProcessDocumentUploadBean vatCatCopyDocument;
    private CandidacyProcessDocumentUploadBean photoDocument;
    private List<FormationBean> formationConcludedBeanList;
    private List<FormationBean> formationNonConcludedBeanList;
    protected Boolean honorAgreement;
    protected Boolean utlStudent;
    private Boolean paymentChecked;

    public IndividualCandidacyProcessBean() {
        this.setFormationConcludedBeanList(new ArrayList<FormationBean>());
        this.setFormationNonConcludedBeanList(new ArrayList<FormationBean>());
        this.setPublicCandidacy(Boolean.TRUE);
    }

    public Integer getNumberOfPreviousYearEnrolmentsInPrecedentDegree() {
        return this.numberOfPreviousYearEnrolmentsInPrecedentDegree;
    }

    public void setNumberOfPreviousYearEnrolmentsInPrecedentDegree(Integer numberOfPreviousYearEnrolmentsInPrecedentDegree) {
        this.numberOfPreviousYearEnrolmentsInPrecedentDegree = numberOfPreviousYearEnrolmentsInPrecedentDegree;
    }

    public Boolean getInternalPersonCandidacy() {
        return this.internalPersonCandidacy;
    }

    public void setInternalPersonCandidacy(Boolean internalPersonCandidacy) {
        this.internalPersonCandidacy = internalPersonCandidacy;
    }

    public CandidacyProcess getCandidacyProcess() {
        return this.candidacyProcess;
    }

    public void setCandidacyProcess(CandidacyProcess candidacyProcess) {
        this.candidacyProcess = candidacyProcess;
    }

    public boolean hasCandidacyProcess() {
        return this.getCandidacyProcess() != null;
    }

    public ChoosePersonBean getChoosePersonBean() {
        return this.choosePersonBean;
    }

    public void setChoosePersonBean(ChoosePersonBean choosePersonBean) {
        this.choosePersonBean = choosePersonBean;
    }

    public boolean hasChoosenPerson() {
        return this.getChoosePersonBean().hasPerson();
    }

    public void removeChoosePersonBean() {
        this.setChoosePersonBean(null);
    }

    public PersonBean getPersonBean() {
        return this.personBean;
    }

    public void setPersonBean(PersonBean personBean) {
        this.personBean = personBean;
    }

    public LocalDate getCandidacyDate() {
        return this.candidacyDate;
    }

    public void setCandidacyDate(LocalDate candidacyDate) {
        this.candidacyDate = candidacyDate;
    }

    public Person getOrCreatePersonFromBean() {
        if (!this.getPersonBean().hasPerson()) {
            return new Person(this.getPersonBean(), true);
        }
        if (this.getPersonBean().getPerson().getUser() != null) {
            return this.getPersonBean().getPerson();
        }
        if (this.isPublicCandidacy().booleanValue()) {
            return this.getPersonBean().getPerson().editByPublicCandidate(this.personBean);
        }
        return this.getPersonBean().save();
    }

    public ExecutionInterval getCandidacyExecutionInterval() {
        return this.hasCandidacyProcess() ? this.getCandidacyProcess().getCandidacyExecutionInterval() : null;
    }

    public CandidacyProcessDocumentUploadBean getDocumentIdentificationDocument() {
        return this.documentIdentificationDocument;
    }

    public void setDocumentIdentificationDocument(CandidacyProcessDocumentUploadBean documentIdentificationDocument) {
        this.documentIdentificationDocument = documentIdentificationDocument;
    }

    public CandidacyProcessDocumentUploadBean getPaymentDocument() {
        return this.paymentDocument;
    }

    public void setPaymentDocument(CandidacyProcessDocumentUploadBean paymentDocument) {
        this.paymentDocument = paymentDocument;
    }

    public CandidacyProcessDocumentUploadBean getHabilitationCertificationDocument() {
        return this.habilitationCertificationDocument;
    }

    public void setHabilitationCertificationDocument(CandidacyProcessDocumentUploadBean habilitationCertificationDocument) {
        this.habilitationCertificationDocument = habilitationCertificationDocument;
    }

    public CandidacyProcessDocumentUploadBean getFirstCycleAccessHabilitationDocument() {
        return this.firstCycleAccessHabilitationDocument;
    }

    public void setFirstCycleAccessHabilitationDocument(CandidacyProcessDocumentUploadBean firstCycleAccessHabilitationDocument) {
        this.firstCycleAccessHabilitationDocument = firstCycleAccessHabilitationDocument;
    }

    public CandidacyProcessDocumentUploadBean getVatCatCopyDocument() {
        return this.vatCatCopyDocument;
    }

    public void setVatCatCopyDocument(CandidacyProcessDocumentUploadBean vatCatCopyDocument) {
        this.vatCatCopyDocument = vatCatCopyDocument;
    }

    public IndividualCandidacyProcess getIndividualCandidacyProcess() {
        return this.individualCandidacyProcess;
    }

    public void setIndividualCandidacyProcess(IndividualCandidacyProcess individualCandidacyProcess) {
        this.individualCandidacyProcess = individualCandidacyProcess;
    }

    public DegreeOfficePublicCandidacyHashCode getPublicCandidacyHashCode() {
        return this.publicCandidacyHashCode;
    }

    public void setPublicCandidacyHashCode(DegreeOfficePublicCandidacyHashCode publicCandidacyHashCode) {
        this.publicCandidacyHashCode = publicCandidacyHashCode;
    }

    public String getObservations() {
        return this.observations;
    }

    public void setObservations(String value) {
        this.observations = value;
    }

    public CandidacyProcessDocumentUploadBean getPhotoDocument() {
        return this.photoDocument;
    }

    public void setPhotoDocument(CandidacyProcessDocumentUploadBean bean) {
        this.photoDocument = bean;
    }

    public List<FormationBean> getFormationConcludedBeanList() {
        return this.formationConcludedBeanList;
    }

    public void setFormationConcludedBeanList(List<FormationBean> formationConcludedBeanList) {
        this.formationConcludedBeanList = formationConcludedBeanList;
    }

    public List<FormationBean> getFormationNonConcludedBeanList() {
        return this.formationNonConcludedBeanList;
    }

    public void setFormationNonConcludedBeanList(List<FormationBean> formationNonConcludedBeanList) {
        this.formationNonConcludedBeanList = formationNonConcludedBeanList;
    }

    public void addConcludedFormationBean() {
        this.formationConcludedBeanList.add(new FormationBean(Boolean.TRUE));
    }

    public void addNonConcludedFormationBean() {
        this.formationNonConcludedBeanList.add(new FormationBean(Boolean.FALSE));
    }

    public void removeFormationConcludedBean(int index) {
        this.formationConcludedBeanList.remove(index);
    }

    public void removeFormationNonConcludedBean(int index) {
        this.formationNonConcludedBeanList.remove(index);
    }

    protected void initializeFormation(Collection<Formation> formations) {
        this.formationConcludedBeanList = new ArrayList<FormationBean>();
        this.formationNonConcludedBeanList = new ArrayList<FormationBean>();
        for (Formation formation : formations) {
            if (formation.getConcluded().booleanValue()) {
                this.formationConcludedBeanList.add(new FormationBean(formation));
                continue;
            }
            this.formationNonConcludedBeanList.add(new FormationBean(formation));
        }
    }

    protected void initializeDocumentUploadBeans() {
        this.documentIdentificationDocument = new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.DOCUMENT_IDENTIFICATION);
        this.paymentDocument = new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.PAYMENT_DOCUMENT);
        this.habilitationCertificationDocument = new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.HABILITATION_CERTIFICATE_DOCUMENT);
        this.firstCycleAccessHabilitationDocument = new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.FIRST_CYCLE_ACCESS_HABILITATION_DOCUMENT);
        this.vatCatCopyDocument = new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.VAT_CARD_DOCUMENT);
        this.setPhotoDocument(new CandidacyProcessDocumentUploadBean(IndividualCandidacyDocumentFileType.PHOTO));
    }

    public Boolean getProcessChecked() {
        return this.processChecked;
    }

    public void setProcessChecked(Boolean value) {
        this.processChecked = value;
    }

    public String getPersonNumber() {
        return this.personNumber;
    }

    public void setPersonNumber(String personNumber) {
        this.personNumber = personNumber;
    }

    public Boolean isPublicCandidacy() {
        return this.publicCandidacyCreationOrEdition;
    }

    public void setPublicCandidacy(Boolean value) {
        this.publicCandidacyCreationOrEdition = value;
    }

    public Boolean getHonorAgreement() {
        return this.honorAgreement;
    }

    public void setHonorAgreement(Boolean value) {
        this.honorAgreement = value;
    }

    public Boolean getUtlStudent() {
        return this.utlStudent;
    }

    public void setUtlStudent(Boolean utlStudent) {
        this.utlStudent = utlStudent;
    }

    public Boolean getPaymentChecked() {
        return this.paymentChecked;
    }

    public void setPaymentChecked(Boolean value) {
        this.paymentChecked = value;
    }

    public boolean isDegreeCandidacyForGraduatedPerson() {
        return false;
    }

    public boolean isDegreeChange() {
        return false;
    }

    public boolean isDegreeTransfer() {
        return false;
    }

    public boolean isErasmus() {
        return false;
    }

    public boolean isOver23() {
        return false;
    }

    public boolean isSecondCycle() {
        return false;
    }

    public boolean isStandalone() {
        return false;
    }
}

