/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.candidacyProcess;

import org.fenixedu.academic.domain.Country;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacy;
import org.fenixedu.academic.domain.candidacyProcess.IndividualCandidacyInternalPersonDetails_Base;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.person.Gender;
import org.fenixedu.academic.domain.person.IDDocumentType;
import org.fenixedu.academic.domain.person.MaritalStatus;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.dto.contacts.PendingPartyContactBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.joda.time.YearMonthDay;

public class IndividualCandidacyInternalPersonDetails
extends IndividualCandidacyInternalPersonDetails_Base {
    public IndividualCandidacyInternalPersonDetails(IndividualCandidacy candidacy, Person person) {
        this.setCandidacy(candidacy);
        this.setPerson(person);
    }

    public boolean isInternal() {
        return true;
    }

    public void edit(PersonBean personBean) {
        personBean.save(this.getPerson());
    }

    public void ensurePersonInternalization() {
    }

    public Student getStudent() {
        return this.getPerson().getStudent();
    }

    public String getName() {
        return this.getPerson().getName();
    }

    public String getDocumentIdNumber() {
        return this.getPerson().getDocumentIdNumber();
    }

    public void setDocumentIdNumber(String documentIdNumber) {
        this.getPerson().setDocumentIdNumber(documentIdNumber);
    }

    public Country getCountry() {
        return this.getPerson().getCountry();
    }

    public void setCountry(Country country) {
        this.getPerson().setCountry(country);
    }

    public YearMonthDay getDateOfBirthYearMonthDay() {
        return this.getPerson().getDateOfBirthYearMonthDay();
    }

    public void setDateOfBirthYearMonthDay(YearMonthDay birthday) {
        this.getPerson().setDateOfBirthYearMonthDay(birthday);
    }

    public PhysicalAddress getDefaultPhysicalAddress() {
        return new PendingPartyContactBean(this.getPerson()).getDefaultPhysicalAddress();
    }

    private Phone getDefaultPhone() {
        return new PendingPartyContactBean(this.getPerson()).getDefaultPhone();
    }

    private EmailAddress getDefaultEmailAddress() {
        return new PendingPartyContactBean(this.getPerson()).getDefaultEmailAddress();
    }

    public YearMonthDay getEmissionDateOfDocumentIdYearMonthDay() {
        return this.getPerson().getEmissionDateOfDocumentIdYearMonthDay();
    }

    public void setEmissionDateOfDocumentIdYearMonthDay(YearMonthDay date) {
        this.getPerson().setEmissionDateOfDocumentIdYearMonthDay(date);
    }

    public String getEmissionLocationOfDocumentId() {
        return this.getPerson().getEmissionLocationOfDocumentId();
    }

    public void setEmissionLocationOfDocumentId(String location) {
        this.getPerson().setEmissionLocationOfDocumentId(location);
    }

    public YearMonthDay getExpirationDateOfDocumentIdYearMonthDay() {
        return this.getPerson().getExpirationDateOfDocumentIdYearMonthDay();
    }

    public void setExpirationDateOfDocumentIdYearMonthDay(YearMonthDay date) {
        this.getPerson().setExpirationDateOfDocumentIdYearMonthDay(date);
    }

    public Gender getGender() {
        return this.getPerson().getGender();
    }

    public void setGender(Gender gender) {
        this.getPerson().setGender(gender);
    }

    public IDDocumentType getIdDocumentType() {
        return this.getPerson().getIdDocumentType();
    }

    public void setIdDocumentType(IDDocumentType type) {
        this.getPerson().setIdDocumentType(type);
    }

    public MaritalStatus getMaritalStatus() {
        return this.getPerson().getMaritalStatus();
    }

    public void setMaritalStatus(MaritalStatus status) {
        this.getPerson().setMaritalStatus(status);
    }

    public String getSocialSecurityNumber() {
        return this.getPerson().getSocialSecurityNumber();
    }

    public void setSocialSecurityNumber(String number) {
        this.getPerson().setSocialSecurityNumber(number);
    }

    public String getAddress() {
        return this.getDefaultPhysicalAddress() != null ? this.getDefaultPhysicalAddress().getAddress() : null;
    }

    public String getArea() {
        return this.getDefaultPhysicalAddress() != null ? this.getDefaultPhysicalAddress().getArea() : null;
    }

    public String getAreaCode() {
        return this.getDefaultPhysicalAddress() != null ? this.getDefaultPhysicalAddress().getAreaCode() : null;
    }

    public String getAreaOfAreaCode() {
        return this.getDefaultPhysicalAddress() != null ? this.getDefaultPhysicalAddress().getAreaOfAreaCode() : null;
    }

    public Country getCountryOfResidence() {
        return this.getDefaultPhysicalAddress() != null ? this.getDefaultPhysicalAddress().getCountryOfResidence() : null;
    }

    public void setCountryOfResidence(Country country) {
        this.getDefaultPhysicalAddress().setCountryOfResidence(country);
    }

    public void setAddress(String address) {
        this.getDefaultPhysicalAddress().setAddress(address);
    }

    public void setArea(String area) {
        this.getDefaultPhysicalAddress().setArea(area);
    }

    public void setAreaCode(String areaCode) {
        this.getDefaultPhysicalAddress().setAreaCode(areaCode);
    }

    public void setAreaOfAreaCode(String areaOfAreaCode) {
        this.getDefaultPhysicalAddress().setAreaOfAreaCode(areaOfAreaCode);
    }

    @Deprecated
    public String getFiscalCode() {
        return this.getPerson().getSocialSecurityNumber();
    }

    @Deprecated
    public void setFiscalCode(String value) {
        this.getPerson().setSocialSecurityNumber(value);
    }

    public String getEmail() {
        return this.getDefaultEmailAddress() != null ? this.getDefaultEmailAddress().getValue() : null;
    }

    public String getTelephoneContact() {
        return this.getDefaultPhone() != null ? this.getDefaultPhone().getNumber() : null;
    }

    public void setEmail(String email) {
        this.getPerson().setDefaultEmailAddressValue(email);
    }

    public void setTelephoneContact(String telephoneContact) {
        this.getPerson().setDefaultPhoneNumber(telephoneContact);
    }

    public String getProfession() {
        return this.getPerson().getProfession();
    }

    public void setProfession(String profession) {
        this.getPerson().setProfession(profession);
    }

    public Boolean hasAnyRole() {
        return this.getPerson().getUser() != null;
    }

    public void editPublic(PersonBean personBean) {
        this.getPerson().editByPublicCandidate(personBean);
    }

    public String getEidentifier() {
        return this.getPerson().getEidentifier();
    }

    public String getGivenNames() {
        return this.getPerson().getGivenNames();
    }

    public String getFamilyNames() {
        return this.getPerson().getFamilyNames();
    }
}

