/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.academic.domain.ExecutionInterval;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.PaymentCode$callable$process;
import org.fenixedu.academic.domain.accounting.PaymentCode$callable$setState;
import org.fenixedu.academic.domain.accounting.PaymentCodeMapping;
import org.fenixedu.academic.domain.accounting.PaymentCodeState;
import org.fenixedu.academic.domain.accounting.PaymentCodeType;
import org.fenixedu.academic.domain.accounting.PaymentCode_Base;
import org.fenixedu.academic.domain.accounting.util.PaymentCodeGenerator;
import org.fenixedu.academic.domain.accounting.util.PaymentCodeGeneratorFactory;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class PaymentCode
extends PaymentCode_Base {
    public static final String SIBS_IGNORE_MAX_AMOUNT = "99999999.99";
    public static Comparator<PaymentCode> COMPARATOR_BY_CODE;
    public static Comparator<PaymentCode> COMPARATOR_BY_END_DATE;
    public static final Advice advice$setState;
    public static final Advice advice$process;

    protected PaymentCode() {
        super.setRootDomainObject(Bennu.getInstance());
        super.setWhenCreated(new DateTime());
        super.setWhenUpdated(new DateTime());
        super.setState(PaymentCodeState.NEW);
        super.setEntityCode(FenixEduAcademicConfiguration.getConfiguration().getSibsEntityCode());
    }

    protected void init(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Person person) {
        this.checkParameters(paymentCodeType, startDate, endDate, minAmount, maxAmount, person);
        super.setCode(PaymentCode.getPaymentCodeGenerator(paymentCodeType).generateNewCodeFor(paymentCodeType, person));
        super.setType(paymentCodeType);
        super.setStartDate(startDate);
        super.setEndDate(endDate);
        super.setMinAmount(minAmount);
        super.setMaxAmount(maxAmount != null ? maxAmount : new Money(SIBS_IGNORE_MAX_AMOUNT));
        super.setPerson(person);
    }

    private void checkParameters(PaymentCodeType paymentCodeType, YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount, Person person) {
        if (paymentCodeType == null) {
            throw new DomainException("error.accounting.PaymentCode.paymentCodeType.cannot.be.null", new String[0]);
        }
        this.checkParameters(startDate, endDate, minAmount, maxAmount);
    }

    private void checkParameters(YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount) {
        if (startDate == null) {
            throw new DomainException("error.accounting.PaymentCode.startDate.cannot.be.null", new String[0]);
        }
        if (endDate == null) {
            throw new DomainException("error.accounting.PaymentCode.endDate.cannot.be.null", new String[0]);
        }
        if (minAmount == null) {
            throw new DomainException("error.accounting.PaymentCode.minAmount.cannot.be.null", new String[0]);
        }
    }

    public String getFormattedCode() {
        StringBuilder result = new StringBuilder();
        int i = 1;
        for (char character : this.getCode().toCharArray()) {
            result.append(character);
            if (i % 3 == 0) {
                result.append(" ");
            }
            ++i;
        }
        return result.charAt(result.length() - 1) == ' ' ? result.deleteCharAt(result.length() - 1).toString() : result.toString();
    }

    public void setWhenCreated(DateTime whenCreated) {
        throw new DomainException("error.accounting.PaymentCode.cannot.modify.whenCreated", new String[0]);
    }

    public void setCode(String code) {
        throw new DomainException("error.accounting.PaymentCode.cannot.modify.code", new String[0]);
    }

    public void setStartDate(YearMonthDay startDate) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.PaymentCode.cannot.modify.startDate", new String[0]);
    }

    public void setEndDate(YearMonthDay endDate) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.PaymentCode.cannot.modify.endDate", new String[0]);
    }

    public void setMinAmount(Money minAmount) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.PaymentCode.cannot.modify.minAmount", new String[0]);
    }

    public void setMaxAmount(Money maxAmount) {
        throw new DomainException("error.org.fenixedu.academic.domain.accounting.PaymentCode.cannot.modify.maxAmount", new String[0]);
    }

    public void setWhenUpdated(DateTime whenUpdated) {
        throw new DomainException("error.accounting.PaymentCode.cannot.modify.whenUpdated", new String[0]);
    }

    public void setState(PaymentCodeState paymentCodeState) {
        Object object = advice$setState.perform((Callable)new PaymentCode$callable$setState(this, paymentCodeState));
    }

    static /* synthetic */ void advised$setState(PaymentCode this_, PaymentCodeState state) {
        super.setWhenUpdated(new DateTime());
        super.setState(state);
    }

    public void setEntityCode(String entityCode) {
        throw new DomainException("error.accounting.PaymentCode.cannot.modify.entityCode", new String[0]);
    }

    public boolean isNew() {
        return this.getState() == PaymentCodeState.NEW;
    }

    protected void reuseCode() {
        this.setState(PaymentCodeState.NEW);
    }

    public boolean isProcessed() {
        return this.getState() == PaymentCodeState.PROCESSED;
    }

    public boolean isCancelled() {
        return this.getState() == PaymentCodeState.CANCELLED;
    }

    public boolean isInvalid() {
        return this.getState() == PaymentCodeState.INVALID;
    }

    public void cancel() {
        this.setState(PaymentCodeState.CANCELLED);
    }

    public boolean isAvailableForReuse() {
        return !this.isNew();
    }

    public void update(YearMonthDay startDate, YearMonthDay endDate, Money minAmount, Money maxAmount) {
        this.checkParameters(startDate, endDate, maxAmount, maxAmount);
        super.setStartDate(startDate);
        super.setEndDate(endDate);
        super.setMinAmount(minAmount);
        super.setMaxAmount(maxAmount != null ? maxAmount : new Money(SIBS_IGNORE_MAX_AMOUNT));
        super.setWhenUpdated(new DateTime());
    }

    public void process(Person person, Money money, DateTime dateTime, String string, String string2) {
        Object object = advice$process.perform((Callable)new PaymentCode$callable$process(this, person, money, dateTime, string, string2));
    }

    static /* synthetic */ void advised$process(PaymentCode this_, Person responsiblePerson, Money amount, DateTime whenRegistered, String sibsTransactionId, String comments) {
        if (this_.isProcessed()) {
            return;
        }
        if (this_.isInvalid()) {
            throw new DomainException("error.accounting.PaymentCode.cannot.process.invalid.codes", new String[0]);
        }
        this_.internalProcess(responsiblePerson, amount, whenRegistered, sibsTransactionId, comments);
        if (!this_.getType().isReusable()) {
            this_.setState(PaymentCodeState.PROCESSED);
        }
    }

    public void delete() {
        super.setPerson(null);
        for (PaymentCodeMapping mapping : this.getOldPaymentCodeMappingsSet()) {
            mapping.delete();
        }
        for (PaymentCodeMapping mapping : this.getNewPaymentCodeMappingsSet()) {
            this.removeNewPaymentCodeMappings(mapping);
        }
        this.setStudentCandidacy(null);
        this.setRootDomainObject(null);
        this.deleteDomainObject();
    }

    public String getDescription() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)this.getType().getQualifiedName(), (String[])new String[0]);
    }

    protected abstract void internalProcess(Person var1, Money var2, DateTime var3, String var4, String var5);

    public PaymentCodeMapping getOldPaymentCodeMapping(ExecutionYear executionYear) {
        for (PaymentCodeMapping mapping : this.getOldPaymentCodeMappingsSet()) {
            if (!mapping.has((ExecutionInterval)((Object)executionYear))) continue;
            return mapping;
        }
        return null;
    }

    protected static PaymentCodeGenerator getPaymentCodeGenerator(PaymentCodeType paymentCodeType) {
        return PaymentCodeGeneratorFactory.getGenerator(paymentCodeType);
    }

    public static PaymentCode readByCode(String code) {
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        for (PaymentCode paymentCode : Bennu.getInstance().getPaymentCodesSet()) {
            if (!paymentCode.getCode().equals(code)) continue;
            return paymentCode;
        }
        return null;
    }

    public static boolean canGenerateNewCode(Class<? extends PaymentCode> paymentCodeClass, PaymentCodeType paymentCodeType, Person person) {
        return PaymentCode.getPaymentCodeGenerator(paymentCodeType).canGenerateNewCode(paymentCodeType, person);
    }

    public boolean isInstallmentPaymentCode() {
        return false;
    }

    public boolean isAccountingEventPaymentCode() {
        return false;
    }

    public boolean isForRectorate() {
        return false;
    }

    static {
        advice$setState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$process = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_CODE = new Comparator<PaymentCode>(){

            @Override
            public int compare(PaymentCode leftPaymentCode, PaymentCode rightPaymentCode) {
                int comparationResult = leftPaymentCode.getCode().compareTo(rightPaymentCode.getCode());
                if (comparationResult == 0) {
                    throw new DomainException("error.accounting.PaymentCode.data.is.corrupted.because.found.duplicate.codes", new String[0]);
                }
                return comparationResult;
            }
        };
        COMPARATOR_BY_END_DATE = new Comparator<PaymentCode>(){

            @Override
            public int compare(PaymentCode leftPaymentCode, PaymentCode rightPaymentCode) {
                int comparationResult = leftPaymentCode.getEndDate().compareTo((ReadablePartial)rightPaymentCode.getEndDate());
                return comparationResult == 0 ? leftPaymentCode.getExternalId().compareTo(rightPaymentCode.getExternalId()) : comparationResult;
            }
        };
    }
}

