/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl.academicAdministration;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.AcademicProgram;
import org.fenixedu.academic.domain.accessControl.academicAdministration.AcademicAccessRule;
import org.fenixedu.academic.domain.accessControl.rules.AccessOperation;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.Group;
import org.fenixedu.bennu.core.groups.NobodyGroup;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixWebFramework.rendererExtensions.util.IPresentableEnum;

public enum AcademicOperationType implements IPresentableEnum,
AccessOperation<AcademicAccessRule, AcademicAccessRule.AcademicAccessTarget>
{
    MANAGE_AUTHORIZATIONS(false, false, Scope.ADMINISTRATION),
    MANAGE_EQUIVALENCES(true, true, Scope.ADMINISTRATION),
    MANAGE_ACADEMIC_CALENDARS(false, false, Scope.ADMINISTRATION),
    EDIT_STUDENT_PERSONAL_DATA(true, true, Scope.OFFICE),
    STUDENT_ENROLMENTS(true, true, Scope.OFFICE),
    MANAGE_REGISTRATIONS(true, true, Scope.OFFICE),
    MANAGE_STATUTES(false, false, Scope.OFFICE),
    MANAGE_CONCLUSION(true, true, Scope.OFFICE),
    UPDATE_REGISTRATION_AFTER_CONCLUSION(true, true, Scope.OFFICE),
    REPEAT_CONCLUSION_PROCESS(true, true, Scope.OFFICE),
    ENROLMENT_WITHOUT_RULES(true, true, Scope.OFFICE),
    MOVE_CURRICULUM_LINES_WITHOUT_RULES(true, true, Scope.OFFICE),
    REPORT_STUDENTS_UTL_CANDIDATES(true, true, Scope.ADMINISTRATION),
    MANAGE_REGISTERED_DEGREE_CANDIDACIES(true, true, Scope.ADMINISTRATION),
    MANAGE_ENROLMENT_PERIODS(true, true, Scope.ADMINISTRATION),
    MANAGE_MARKSHEETS(true, true, Scope.ADMINISTRATION),
    RECTIFICATION_MARKSHEETS(true, true, Scope.ADMINISTRATION),
    REMOVE_GRADES(true, true, Scope.ADMINISTRATION),
    DISSERTATION_MARKSHEETS(true, true, Scope.ADMINISTRATION),
    REGISTRATION_CONCLUSION_CURRICULUM_VALIDATION(true, true, Scope.OFFICE),
    CREATE_REGISTRATION(true, true, Scope.OFFICE),
    STUDENT_LISTINGS(true, true, Scope.ADMINISTRATION),
    SERVICE_REQUESTS(true, true, Scope.OFFICE),
    SERVICE_REQUESTS_RECTORAL_SENDING(true, true, Scope.OFFICE),
    MANAGE_EXECUTION_COURSES(true, true, Scope.ADMINISTRATION),
    MANAGE_EXECUTION_COURSES_ADV(true, true, Scope.ADMINISTRATION),
    MANAGE_DEGREE_CURRICULAR_PLANS(true, true, Scope.ADMINISTRATION),
    MANAGE_EVENT_REPORTS(true, false, Scope.ADMINISTRATION),
    MANAGE_STUDENT_PAYMENTS(true, false, Scope.OFFICE),
    MANAGE_STUDENT_PAYMENTS_ADV(true, true, Scope.ADMINISTRATION),
    CREATE_SIBS_PAYMENTS_REPORT(false, false, Scope.ADMINISTRATION),
    MANAGE_ACCOUNTING_EVENTS(true, true, Scope.OFFICE),
    MANAGE_PRICES(true, false, Scope.ADMINISTRATION),
    MANAGE_EXTRA_CURRICULAR_ACTIVITIES(false, false, Scope.ADMINISTRATION),
    MANAGE_EXTERNAL_UNITS(false, false, Scope.ADMINISTRATION),
    MANAGE_INDIVIDUAL_CANDIDACIES(true, true, Scope.ADMINISTRATION),
    MANAGE_CANDIDACY_PROCESSES(true, true, Scope.ADMINISTRATION),
    VIEW_FULL_STUDENT_CURRICULUM(true, true, Scope.OFFICE),
    MANAGE_DOCUMENTS(true, true, Scope.OFFICE),
    VIEW_PHD_CANDIDACY_ALERTS(true, true, Scope.OFFICE),
    VIEW_PHD_PUBLIC_PRESENTATION_ALERTS(true, true, Scope.OFFICE),
    VIEW_PHD_THESIS_ALERTS(true, true, Scope.OFFICE),
    MANAGE_PHD_ENROLMENT_PERIODS(true, true, Scope.OFFICE),
    MANAGE_PHD_PROCESSES(true, true, Scope.OFFICE),
    MANAGE_PHD_PROCESS_STATE(true, true, Scope.OFFICE),
    MANAGE_MOBILITY_OUTBOUND(false, false, Scope.ADMINISTRATION),
    VALIDATE_MOBILITY_OUTBOUND_CANDIDACIES(false, false, Scope.ADMINISTRATION),
    VIEW_SCHEDULING_OVERSIGHT(false, false, Scope.ADMINISTRATION),
    MANAGE_TEACHER_AUTHORIZATIONS(false, false, Scope.ADMINISTRATION),
    MANAGE_TEACHER_PROFESSORSHIPS(false, false, Scope.ADMINISTRATION),
    SUMMARIES_CONTROL(false, false, Scope.ADMINISTRATION);

    private boolean allowOffices;
    private boolean allowPrograms;
    private Scope scope;
    public static Comparator<AcademicOperationType> COMPARATOR_BY_LOCALIZED_NAME;

    private AcademicOperationType(boolean allowOffices, boolean allowPrograms, Scope scope) {
        this.allowOffices = allowOffices;
        this.allowPrograms = allowPrograms;
        this.scope = scope;
    }

    public boolean isOfficeAllowedAsTarget() {
        return this.allowOffices;
    }

    public boolean isProgramAllowedAsTarget() {
        return this.allowPrograms;
    }

    public boolean isOfScope(Scope scope) {
        return this.scope.equals((Object)scope);
    }

    @Override
    public String getLocalizedName() {
        return BundleUtil.getString((String)"resources.EnumerationResources", (String)(this.getClass().getName() + "." + this.name()), (String[])new String[0]);
    }

    @Override
    public String exportAsString() {
        return this.getClass().getName() + ":" + this.name();
    }

    @Override
    public Optional<AcademicAccessRule> grant(Group whoCanAccess, Set<AcademicAccessRule.AcademicAccessTarget> whatCanAffect) {
        if (whoCanAccess.equals((Object)NobodyGroup.get())) {
            return Optional.empty();
        }
        Optional<AcademicAccessRule> match = AcademicAccessRule.accessRules().filter(r -> r.getOperation().equals(this) && r.getWhoCanAccess().equals((Object)whoCanAccess) && Sets.symmetricDifference(r.getWhatCanAffect(), (Set)whatCanAffect).isEmpty()).findAny();
        return Optional.of(match.orElseGet(() -> new AcademicAccessRule(this, whoCanAccess, whatCanAffect)));
    }

    public Optional<AcademicAccessRule> grant(Group whoCanAccess, Set<AcademicProgram> programs, Set<AdministrativeOffice> offices) {
        Set<AcademicAccessRule.AcademicAccessTarget> targets = Stream.concat(programs.stream().map(AcademicAccessRule.AcademicProgramAccessTarget::new), offices.stream().map(AcademicAccessRule.AdministrativeOfficeAccessTarget::new)).collect(Collectors.toSet());
        return this.grant(whoCanAccess, targets);
    }

    @Override
    public Optional<AcademicAccessRule> grant(User user) {
        Optional<AcademicAccessRule> match = AcademicAccessRule.accessRules().filter(r -> r.getOperation().equals(this) && r.getWhatCanAffect().isEmpty()).findAny();
        return match.map(r -> r.grant(user)).orElseGet(() -> Optional.of(new AcademicAccessRule(this, UserGroup.of((User[])new User[]{user}), Collections.emptySet())));
    }

    @Override
    public Optional<AcademicAccessRule> revoke(User user) {
        Optional<AcademicAccessRule> match = AcademicAccessRule.accessRules().filter(r -> r.getOperation().equals(this) && r.getWhatCanAffect().isEmpty()).findAny();
        return match.map(r -> r.revoke(user)).orElse(Optional.empty());
    }

    static {
        COMPARATOR_BY_LOCALIZED_NAME = new Comparator<AcademicOperationType>(){

            @Override
            public int compare(AcademicOperationType p1, AcademicOperationType p2) {
                String operationName1 = p1.getLocalizedName();
                String operationName2 = p2.getLocalizedName();
                int res = operationName1.compareTo(operationName2);
                return res;
            }
        };
    }

    public static enum Scope {
        OFFICE,
        ADMINISTRATION;


        public boolean contains(AcademicOperationType function) {
            if (function instanceof AcademicOperationType) {
                return function.scope == this;
            }
            return false;
        }
    }
}

