/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Professorship$callable$create;
import org.fenixedu.academic.domain.ProfessorshipManagementLog;
import org.fenixedu.academic.domain.ProfessorshipPermissions;
import org.fenixedu.academic.domain.Professorship_Base;
import org.fenixedu.academic.domain.Teacher;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Professorship
extends Professorship_Base {
    public static final Comparator<Professorship> COMPARATOR_BY_PERSON_NAME;
    public static final Advice advice$create;

    public Professorship() {
        this.setRootDomainObject(Bennu.getInstance());
        new ProfessorshipPermissions(this);
    }

    public boolean belongsToExecutionPeriod(ExecutionSemester executionSemester) {
        return this.getExecutionCourse().getExecutionPeriod().equals(executionSemester);
    }

    public static Professorship create(Boolean bl, ExecutionCourse executionCourse, Person person) {
        return (Professorship)((Object)advice$create.perform((Callable)new Professorship$callable$create(bl, executionCourse, person)));
    }

    static /* synthetic */ Professorship advised$create(Boolean responsibleFor, ExecutionCourse executionCourse, Person person) {
        Objects.requireNonNull(responsibleFor);
        Objects.requireNonNull(executionCourse);
        Objects.requireNonNull(person);
        if (executionCourse.getProfessorshipsSet().stream().anyMatch(p -> person.equals((Object)p.getPerson()))) {
            throw new DomainException("error.teacher.already.associated.to.professorship", new String[0]);
        }
        Professorship professorShip = new Professorship();
        professorShip.setExecutionCourse(executionCourse);
        professorShip.setPerson(person);
        professorShip.setCreator(Authenticate.getUser().getPerson());
        professorShip.setResponsibleFor(responsibleFor);
        if (person.getTeacher() != null) {
            executionCourse.moveSummariesFromTeacherToProfessorship(person.getTeacher(), professorShip);
        }
        ProfessorshipManagementLog.createLog(professorShip.getExecutionCourse(), "resources.MessagingResources", "log.executionCourse.professorship.added", professorShip.getPerson().getPresentationName(), professorShip.getExecutionCourse().getNome(), professorShip.getExecutionCourse().getDegreePresentationString());
        return professorShip;
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        ProfessorshipManagementLog.createLog(this.getExecutionCourse(), "resources.MessagingResources", "log.executionCourse.professorship.removed", this.getPerson().getPresentationName(), this.getExecutionCourse().getNome(), this.getExecutionCourse().getDegreePresentationString());
        this.setExecutionCourse(null);
        this.setPerson(null);
        if (super.getPermissions() != null) {
            this.getPermissions().delete();
        }
        this.setRootDomainObject(null);
        this.setCreator(null);
        this.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getAssociatedSummariesSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.remove.professorship.hasAnyAssociatedSummaries", (String[])new String[0]));
        }
        if (!this.getAssociatedShiftProfessorshipSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.remove.professorship.hasAnyAssociatedShiftProfessorship", (String[])new String[0]));
        }
    }

    public boolean isDeletable() {
        return this.getDeletionBlockers().isEmpty();
    }

    public boolean isResponsibleFor() {
        return this.getResponsibleFor();
    }

    public static List<Professorship> readByDegreeCurricularPlanAndExecutionYear(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear) {
        HashSet professorships = new HashSet();
        for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
            for (ExecutionCourse executionCourse : curricularCourse.getExecutionCoursesByExecutionYear(executionYear)) {
                professorships.addAll(executionCourse.getProfessorshipsSet());
            }
        }
        return new ArrayList<Professorship>(professorships);
    }

    public static List<Professorship> readByDegreeCurricularPlanAndExecutionYearAndBasic(DegreeCurricularPlan degreeCurricularPlan, ExecutionYear executionYear, Boolean basic) {
        HashSet professorships = new HashSet();
        for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
            if (!curricularCourse.getBasic().equals(basic)) continue;
            for (ExecutionCourse executionCourse : curricularCourse.getExecutionCoursesByExecutionYear(executionYear)) {
                professorships.addAll(executionCourse.getProfessorshipsSet());
            }
        }
        return new ArrayList<Professorship>(professorships);
    }

    public static List<Professorship> readByDegreeCurricularPlanAndExecutionPeriod(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester) {
        HashSet professorships = new HashSet();
        for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
            for (ExecutionCourse executionCourse : curricularCourse.getExecutionCoursesByExecutionPeriod(executionSemester)) {
                professorships.addAll(executionCourse.getProfessorshipsSet());
            }
        }
        return new ArrayList<Professorship>(professorships);
    }

    public static List<Professorship> readByDegreeCurricularPlansAndExecutionYearAndBasic(List<DegreeCurricularPlan> degreeCurricularPlans, ExecutionYear executionYear, Boolean basic) {
        HashSet professorships = new HashSet();
        for (DegreeCurricularPlan degreeCurricularPlan : degreeCurricularPlans) {
            for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
                if (curricularCourse.getBasic() != null && !curricularCourse.getBasic().equals(basic)) continue;
                if (executionYear != null) {
                    for (ExecutionCourse executionCourse : curricularCourse.getExecutionCoursesByExecutionYear(executionYear)) {
                        professorships.addAll(executionCourse.getProfessorshipsSet());
                    }
                    continue;
                }
                for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                    professorships.addAll(executionCourse.getProfessorshipsSet());
                }
            }
        }
        return new ArrayList<Professorship>(professorships);
    }

    public static List<Professorship> readByDegreeCurricularPlansAndExecutionYear(List<DegreeCurricularPlan> degreeCurricularPlans, ExecutionYear executionYear) {
        HashSet professorships = new HashSet();
        for (DegreeCurricularPlan degreeCurricularPlan : degreeCurricularPlans) {
            for (CurricularCourse curricularCourse : degreeCurricularPlan.getCurricularCoursesSet()) {
                if (executionYear != null) {
                    for (ExecutionCourse executionCourse : curricularCourse.getExecutionCoursesByExecutionYear(executionYear)) {
                        professorships.addAll(executionCourse.getProfessorshipsSet());
                    }
                    continue;
                }
                for (ExecutionCourse executionCourse : curricularCourse.getAssociatedExecutionCoursesSet()) {
                    professorships.addAll(executionCourse.getProfessorshipsSet());
                }
            }
        }
        return new ArrayList<Professorship>(professorships);
    }

    public Teacher getTeacher() {
        return this.getPerson().getTeacher();
    }

    public void setTeacher(Teacher teacher) {
        this.setPerson(teacher.getPerson());
    }

    public void setResponsibleFor(Boolean responsibleFor) {
        if (responsibleFor == null) {
            responsibleFor = Boolean.FALSE;
        }
        super.setResponsibleFor(responsibleFor);
    }

    public boolean hasTeacher() {
        return this.getPerson() != null && this.getPerson().getTeacher() != null;
    }

    public void removeTeacher() {
        this.setPerson(null);
    }

    public String getDegreeSiglas() {
        HashSet<String> degreeSiglas = new HashSet<String>();
        for (CurricularCourse curricularCourse : this.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
            degreeSiglas.add(curricularCourse.getDegreeCurricularPlan().getDegree().getSigla());
        }
        return StringUtils.join(degreeSiglas, (String)", ");
    }

    public String getDegreePlanNames() {
        HashSet<String> degreeSiglas = new HashSet<String>();
        for (CurricularCourse curricularCourse : this.getExecutionCourse().getAssociatedCurricularCoursesSet()) {
            degreeSiglas.add(curricularCourse.getDegreeCurricularPlan().getName());
        }
        return StringUtils.join(degreeSiglas, (String)", ");
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_PERSON_NAME = new BeanComparator("person.name", (Comparator)Collator.getInstance());
    }
}

