/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.stream.Stream;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.EvaluationConfiguration;
import org.fenixedu.academic.domain.EvaluationSeason_Base;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.OccupationPeriod;
import org.fenixedu.academic.domain.OccupationPeriodReference_Base;
import org.fenixedu.academic.domain.OccupationPeriodType;
import org.fenixedu.commons.i18n.LocalizedString;

public class EvaluationSeason
extends EvaluationSeason_Base
implements Comparable<EvaluationSeason> {
    public EvaluationSeason() {
        this.setEvaluationConfiguration(EvaluationConfiguration.getInstance());
    }

    public EvaluationSeason(LocalizedString acronym, LocalizedString name, boolean normal, boolean improvement, boolean specialAuthorization, boolean special) {
        this();
        this.setAcronym(acronym);
        this.setName(name);
        this.setNormal(normal);
        this.setImprovement(improvement);
        this.setSpecialAuthorization(specialAuthorization);
        this.setSpecial(special);
    }

    public boolean isNormal() {
        return this.getNormal();
    }

    public boolean isSpecial() {
        return this.getSpecial();
    }

    public boolean isImprovement() {
        return this.getImprovement();
    }

    public boolean isSpecialAuthorization() {
        return this.getSpecialAuthorization();
    }

    public static EvaluationSeason readNormalSeason() {
        return EvaluationSeason.all().filter(EvaluationSeason::isNormal).findAny().orElse(null);
    }

    public static EvaluationSeason readSpecialSeason() {
        return EvaluationSeason.all().filter(EvaluationSeason::isSpecial).findAny().orElse(null);
    }

    public static EvaluationSeason readImprovementSeason() {
        return EvaluationSeason.all().filter(EvaluationSeason::isImprovement).findAny().orElse(null);
    }

    public static EvaluationSeason readSpecialAuthorization() {
        return EvaluationSeason.all().filter(EvaluationSeason::isSpecialAuthorization).findAny().orElse(null);
    }

    public static Stream<EvaluationSeason> all() {
        return EvaluationConfiguration.getInstance().getEvaluationSeasonSet().stream();
    }

    public Stream<OccupationPeriod> getExamPeriods(ExecutionDegree executionDegree, ExecutionSemester semester) {
        return executionDegree.getPeriodReferences(OccupationPeriodType.EXAMS, semester == null ? null : semester.getSemester(), null).filter(r -> r.getEvaluationSeasonSet().contains(this)).distinct().map(OccupationPeriodReference_Base::getOccupationPeriod);
    }

    public boolean isGradeSubmissionAvailable(CurricularCourse curricularCourse, ExecutionSemester semester) {
        ExecutionDegree executionDegree = curricularCourse.getExecutionDegreeFor(semester.getExecutionYear());
        return executionDegree.getPeriodReferences(OccupationPeriodType.GRADE_SUBMISSION, semester == null ? null : semester.getSemester(), null).filter(r -> r.getEvaluationSeasonSet().contains(this)).distinct().map(OccupationPeriodReference_Base::getOccupationPeriod).anyMatch(o -> o.getPeriodInterval().containsNow());
    }

    public Stream<OccupationPeriod> getGradeSubmissionPeriods(ExecutionDegree executionDegree, ExecutionSemester semester) {
        return executionDegree.getPeriodReferences(OccupationPeriodType.GRADE_SUBMISSION, semester == null ? null : semester.getSemester(), null).filter(r -> r.getEvaluationSeasonSet().contains(this)).distinct().map(OccupationPeriodReference_Base::getOccupationPeriod);
    }

    @Override
    public int compareTo(EvaluationSeason o) {
        return this.getExternalId().compareTo(o.getExternalId());
    }
}

