/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.EnrolmentPeriod$callable$delete;
import org.fenixedu.academic.domain.EnrolmentPeriod_Base;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.domain.Bennu;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public abstract class EnrolmentPeriod
extends EnrolmentPeriod_Base {
    public static final Comparator<EnrolmentPeriod> COMPARATOR_BY_DEGREE_NAME;
    public static final Comparator<EnrolmentPeriod> COMPARATOR_BY_EXECUTION_SEMESTER;
    public static final Advice advice$delete;

    public EnrolmentPeriod() {
        this.setRootDomainObject(Bennu.getInstance());
    }

    protected void init(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester, Date startDate, Date endDate) {
        this.init(degreeCurricularPlan, executionSemester, new DateTime((Object)startDate), new DateTime((Object)endDate));
    }

    protected void init(DegreeCurricularPlan degreeCurricularPlan, ExecutionSemester executionSemester, DateTime startDate, DateTime endDate) {
        if (!endDate.isAfter((ReadableInstant)startDate)) {
            throw new DomainException("EnrolmentPeriod.end.date.must.be.after.start.date", new String[0]);
        }
        this.setDegreeCurricularPlan(degreeCurricularPlan);
        this.setExecutionPeriod(executionSemester);
        this.setStartDateDateTime(startDate);
        this.setEndDateDateTime(endDate);
    }

    public boolean isValid() {
        return this.containsDate(new DateTime());
    }

    public boolean isValid(Date date) {
        return this.containsDate(new DateTime((Object)date));
    }

    public boolean isUpcomingPeriod() {
        return this.getStartDateDateTime().isAfterNow();
    }

    public boolean containsDate(DateTime date) {
        return !this.getStartDateDateTime().isAfter((ReadableInstant)date) && !this.getEndDateDateTime().isBefore((ReadableInstant)date);
    }

    public boolean isFor(ExecutionSemester executionSemester) {
        return this.getExecutionPeriod() == executionSemester;
    }

    public Degree getDegree() {
        return this.getDegreeCurricularPlan().getDegree();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new EnrolmentPeriod$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(EnrolmentPeriod this_) {
        this_.setDegreeCurricularPlan(null);
        this_.setExecutionPeriod(null);
        this_.setRootDomainObject(null);
        this_.deleteDomainObject();
    }

    @Deprecated
    public Date getEndDate() {
        DateTime dt = this.getEndDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setEndDate(Date date) {
        if (date == null) {
            this.setEndDateDateTime(null);
        } else {
            this.setEndDateDateTime(new DateTime(date.getTime()));
        }
    }

    @Deprecated
    public Date getStartDate() {
        DateTime dt = this.getStartDateDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setStartDate(Date date) {
        if (date == null) {
            this.setStartDateDateTime(null);
        } else {
            this.setStartDateDateTime(new DateTime(date.getTime()));
        }
    }

    public Interval getInterval() {
        return new Interval((ReadableInstant)this.getStartDateDateTime(), (ReadableInstant)this.getEndDateDateTime());
    }

    static {
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_DEGREE_NAME = new Comparator<EnrolmentPeriod>(){

            @Override
            public int compare(EnrolmentPeriod o1, EnrolmentPeriod o2) {
                DegreeCurricularPlan dcp2;
                DegreeCurricularPlan dcp1 = o1.getDegreeCurricularPlan();
                int dcp = DegreeCurricularPlan.COMPARATOR_BY_PRESENTATION_NAME.compare(dcp1, dcp2 = o2.getDegreeCurricularPlan());
                return dcp == 0 ? o2.hashCode() - o1.hashCode() : dcp;
            }
        };
        COMPARATOR_BY_EXECUTION_SEMESTER = new Comparator<EnrolmentPeriod>(){

            @Override
            public int compare(EnrolmentPeriod period1, EnrolmentPeriod period2) {
                ExecutionSemester semester1 = period1.getExecutionPeriod();
                ExecutionSemester semester2 = period2.getExecutionPeriod();
                return ExecutionSemester.COMPARATOR_BY_SEMESTER_AND_YEAR.compare(semester1, semester2);
            }
        };
    }
}

