/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Enrolment;
import org.fenixedu.academic.domain.EnrolmentEvaluation_Base;
import org.fenixedu.academic.domain.EvaluationSeason;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.Grade;
import org.fenixedu.academic.domain.GradeScale;
import org.fenixedu.academic.domain.MarkSheet;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.curriculum.EnrollmentState;
import org.fenixedu.academic.domain.curriculum.EnrolmentEvaluationContext;
import org.fenixedu.academic.domain.curriculum.GradeFactory;
import org.fenixedu.academic.domain.curriculum.IGrade;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.exceptions.EnrolmentNotPayedException;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.academic.domain.treasury.IImprovementTreasuryEvent;
import org.fenixedu.academic.domain.treasury.TreasuryBridgeAPIFactory;
import org.fenixedu.academic.util.EnrolmentEvaluationState;
import org.fenixedu.academic.util.FenixDigestUtils;
import org.fenixedu.academic.util.MarkType;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class EnrolmentEvaluation
extends EnrolmentEvaluation_Base {
    public static final Comparator<EnrolmentEvaluation> COMPARATORY_BY_WHEN = new Comparator<EnrolmentEvaluation>(){

        @Override
        public int compare(EnrolmentEvaluation o1, EnrolmentEvaluation o2) {
            return o1.getWhenDateTime().compareTo((ReadableInstant)o2.getWhenDateTime());
        }
    };
    public static final Comparator<EnrolmentEvaluation> SORT_BY_STUDENT_NUMBER = new Comparator<EnrolmentEvaluation>(){

        @Override
        public int compare(EnrolmentEvaluation o1, EnrolmentEvaluation o2) {
            Student s1 = o1.getRegistration().getStudent();
            Student s2 = o2.getRegistration().getStudent();
            return s1.getNumber().compareTo(s2.getNumber());
        }
    };
    public static final Comparator<EnrolmentEvaluation> COMPARATOR_BY_EXAM_DATE = new Comparator<EnrolmentEvaluation>(){

        @Override
        public int compare(EnrolmentEvaluation o1, EnrolmentEvaluation o2) {
            if (o1.getExamDateYearMonthDay() == null && o2.getExamDateYearMonthDay() == null) {
                return 0;
            }
            if (o1.getExamDateYearMonthDay() == null) {
                return -1;
            }
            if (o2.getExamDateYearMonthDay() == null) {
                return 1;
            }
            return o1.getExamDateYearMonthDay().compareTo((ReadablePartial)o2.getExamDateYearMonthDay());
        }
    };

    public EnrolmentEvaluation() {
        this.setRootDomainObject(Bennu.getInstance());
        this.setEnrolmentEvaluationState(EnrolmentEvaluationState.TEMPORARY_OBJ);
        this.setGrade(Grade.createEmptyGrade());
        this.setContext(EnrolmentEvaluationContext.MARK_SHEET_EVALUATION);
    }

    public EnrolmentEvaluation(Enrolment enrolment, EvaluationSeason season) {
        this();
        if (enrolment == null || season == null) {
            throw new DomainException("error.enrolmentEvaluation.invalid.parameters", new String[0]);
        }
        this.setEnrolment(enrolment);
        this.setEvaluationSeason(season);
    }

    private EnrolmentEvaluation(Enrolment enrolment, EnrolmentEvaluationState enrolmentEvaluationState, EvaluationSeason season, Person responsibleFor, Grade grade, Date availableDate, Date examDate) {
        this(enrolment, season);
        if (enrolmentEvaluationState == null || responsibleFor == null) {
            throw new DomainException("error.enrolmentEvaluation.invalid.parameters", new String[0]);
        }
        this.setEnrolmentEvaluationState(enrolmentEvaluationState);
        this.setPersonResponsibleForGrade(responsibleFor);
        this.setGrade(grade);
        this.setGradeAvailableDate(availableDate);
        this.setExamDate(examDate);
        this.generateCheckSum();
    }

    public void setExamDateYearMonthDay(YearMonthDay evaluationDateYearMonthDay) {
        Enrolment enrolment;
        Thesis thesis;
        if (evaluationDateYearMonthDay != null && (thesis = (enrolment = this.getEnrolment()).getThesis()) != null) {
            DateTime newDateTime = evaluationDateYearMonthDay.toDateTimeAtMidnight();
            DateTime dateTime = thesis.getDiscussed();
            if (dateTime != null) {
                newDateTime = newDateTime.withHourOfDay(dateTime.getHourOfDay());
                newDateTime = newDateTime.withMinuteOfHour(dateTime.getMinuteOfHour());
            }
            thesis.setDiscussed(newDateTime);
        }
        super.setExamDateYearMonthDay(evaluationDateYearMonthDay);
    }

    protected EnrolmentEvaluation(Enrolment enrolment, EnrolmentEvaluationState enrolmentEvaluationState, EvaluationSeason season, Person responsibleFor, Grade grade, Date availableDate, Date examDate, DateTime when) {
        this(enrolment, enrolmentEvaluationState, season, responsibleFor, grade, availableDate, examDate);
        this.setWhenDateTime(when);
    }

    protected EnrolmentEvaluation(Enrolment enrolment, EvaluationSeason season, EnrolmentEvaluationState evaluationState) {
        this(enrolment, season);
        if (evaluationState == null) {
            throw new DomainException("error.enrolmentEvaluation.invalid.parameters", new String[0]);
        }
        this.setEnrolmentEvaluationState(evaluationState);
        this.setWhenDateTime(new DateTime());
    }

    protected EnrolmentEvaluation(Enrolment enrolment, EvaluationSeason season, EnrolmentEvaluationState evaluationState, Person person) {
        this(enrolment, season, evaluationState);
        if (person == null) {
            throw new DomainException("error.enrolmentEvaluation.invalid.parameters", new String[0]);
        }
        this.setPerson(person);
    }

    protected EnrolmentEvaluation(Enrolment enrolment, EvaluationSeason season, EnrolmentEvaluationState evaluationState, Person person, ExecutionSemester executionSemester) {
        this(enrolment, season, evaluationState, person);
        if (executionSemester == null) {
            throw new DomainException("error.enrolmentEvaluation.invalid.parameters", new String[0]);
        }
        this.setExecutionPeriod(executionSemester);
    }

    private int compareMyExamDateToAnotherExamDate(Date examDate) {
        if (this.getExamDate() == null) {
            return -1;
        }
        if (examDate == null) {
            return 1;
        }
        return this.getExamDate().compareTo(examDate);
    }

    public EnrollmentState getEnrollmentStateByGrade() {
        return this.getGrade().getEnrolmentState();
    }

    public GradeScale getGradeScale() {
        return this.getGradeScaleChain();
    }

    public GradeScale getGradeScaleChain() {
        return super.getGradeScale() != null ? super.getGradeScale() : this.getEnrolment().getGradeScaleChain();
    }

    public GradeScale getAssociatedGradeScale() {
        return super.getGradeScale();
    }

    public boolean isNotEvaluated() {
        return this.getEnrollmentStateByGrade() == EnrollmentState.NOT_EVALUATED;
    }

    public boolean isFlunked() {
        return this.getEnrollmentStateByGrade() == EnrollmentState.NOT_APROVED;
    }

    public boolean isApproved() {
        return this.getEnrollmentStateByGrade() == EnrollmentState.APROVED;
    }

    public void edit(Person responsibleFor, Date evaluationDate) {
        if (responsibleFor == null) {
            throw new DomainException("error.enrolmentEvaluation.invalid.parameters", new String[0]);
        }
        this.setPersonResponsibleForGrade(responsibleFor);
        this.setExamDate(evaluationDate);
        this.generateCheckSum();
    }

    public void edit(Person responsibleFor, String gradeValue, Date availableDate, Date examDate, String bookReference, String page, String examReference) {
        this.edit(responsibleFor, gradeValue, availableDate, examDate);
        this.setBookReference(bookReference);
        this.setPage(page);
    }

    public void edit(Person responsibleFor, String gradeValue, Date availableDate, Date examDate) {
        this.edit(responsibleFor, Grade.createGrade(gradeValue, this.getGradeScale()), availableDate, examDate);
    }

    public void edit(Person responsibleFor, Grade grade, Date availableDate, Date examDate) {
        if (responsibleFor == null) {
            throw new DomainException("error.enrolmentEvaluation.invalid.parameters", new String[0]);
        }
        if (examDate != null) {
            if (!grade.isNotEvaluated()) {
                this.checkRegistrationState();
            }
            this.setExamDateYearMonthDay(YearMonthDay.fromDateFields((Date)examDate));
        } else if (grade.isEmpty()) {
            this.setExamDateYearMonthDay(null);
        } else {
            this.setExamDateYearMonthDay(YearMonthDay.fromDateFields((Date)availableDate));
        }
        this.setGrade(grade);
        this.setGradeAvailableDateYearMonthDay(YearMonthDay.fromDateFields((Date)availableDate));
        this.setPersonResponsibleForGrade(responsibleFor);
        this.generateCheckSum();
    }

    private void checkRegistrationState() {
        if (this.getRegistration().hasAnyActiveState(this.getExecutionYear()) || this.getRegistration().isTransited(this.getExecutionYear()) || this.getRegistration().isConcluded() && this.getEvaluationSeason().isImprovement()) {
            return;
        }
        throw new DomainException("error.EnrolmentEvaluation.registration.with.invalid.state", this.getRegistration().getNumber().toString());
    }

    private ExecutionYear getExecutionYear() {
        return this.getExecutionPeriod().getExecutionYear();
    }

    public void confirmSubmission(Person person, String observation) {
        this.confirmSubmission(EnrolmentEvaluationState.FINAL_OBJ, person, observation);
    }

    public void confirmSubmission(EnrolmentEvaluationState enrolmentEvaluationState, Person person, String observation) {
        if (!this.isTemporary()) {
            throw new DomainException("EnrolmentEvaluation.cannot.submit.not.temporary", new String[0]);
        }
        if (!this.hasGrade()) {
            throw new DomainException("EnrolmentEvaluation.cannot.submit.with.empty.grade", new String[0]);
        }
        if (this.isPayable() && !this.isPayed()) {
            throw new EnrolmentNotPayedException("EnrolmentEvaluation.cannot.set.grade.on.not.payed.enrolment.evaluation", this.getEnrolment());
        }
        if (enrolmentEvaluationState == EnrolmentEvaluationState.RECTIFICATION_OBJ && this.getRectified() != null) {
            this.getRectified().setEnrolmentEvaluationState(EnrolmentEvaluationState.RECTIFIED_OBJ);
        }
        this.setEnrolmentEvaluationState(enrolmentEvaluationState);
        this.setPerson(person);
        this.setObservation(observation);
        this.setWhenDateTime(new DateTime());
        EnrollmentState newEnrolmentState = EnrollmentState.APROVED;
        if (!this.getEvaluationSeason().isImprovement()) {
            if (MarkType.getRepMarks().contains(this.getGradeValue())) {
                newEnrolmentState = EnrollmentState.NOT_APROVED;
            } else if (MarkType.getNaMarks().contains(this.getGradeValue())) {
                newEnrolmentState = EnrollmentState.NOT_EVALUATED;
            }
        }
        this.getEnrolment().setEnrollmentState(newEnrolmentState);
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.isTemporary() || this.hasConfirmedMarkSheet()) {
            blockers.add(BundleUtil.getString((String)"resources.ApplicationResources", (String)"error.enrolmentEvaluation.isTemporary.or.hasConfirmedMarksheet", (String[])new String[0]));
        }
    }

    public boolean hasConfirmedMarkSheet() {
        return this.getMarkSheet() != null && this.getMarkSheet().isConfirmed();
    }

    public boolean isTemporary() {
        return this.getEnrolmentEvaluationState() != null && this.getEnrolmentEvaluationState().equals(EnrolmentEvaluationState.TEMPORARY_OBJ);
    }

    public boolean isFinal() {
        return this.getEnrolmentEvaluationState().equals(EnrolmentEvaluationState.FINAL_OBJ) || this.getEnrolmentEvaluationState().equals(EnrolmentEvaluationState.RECTIFICATION_OBJ);
    }

    public boolean isRectification() {
        return this.getEnrolmentEvaluationState().equals(EnrolmentEvaluationState.RECTIFICATION_OBJ);
    }

    public boolean isRectified() {
        return this.getEnrolmentEvaluationState().equals(EnrolmentEvaluationState.RECTIFIED_OBJ);
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setPersonResponsibleForGrade(null);
        this.setPerson(null);
        this.setEnrolment(null);
        this.setMarkSheet(null);
        this.setRectification(null);
        this.setRectified(null);
        this.setExecutionPeriod(null);
        this.setEvaluationSeason(null);
        this.setRootDomainObject(null);
        super.deleteDomainObject();
    }

    public void removeFromMarkSheet() {
        if (this.hasConfirmedMarkSheet()) {
            throw new DomainException("error.enrolmentEvaluation.cannot.be.removed.from.markSheet", new String[0]);
        }
        this.setCheckSum(null);
        this.setExamDateYearMonthDay(null);
        this.setGradeAvailableDateYearMonthDay(null);
        this.setMarkSheet(null);
    }

    protected void generateCheckSum() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getExamDateYearMonthDay() != null ? this.getExamDateYearMonthDay().toString() : "").append(this.getGradeValue());
        stringBuilder.append(this.getEvaluationSeason().getExternalId());
        stringBuilder.append(this.getEnrolment().getStudentCurricularPlan().getRegistration().getNumber());
        this.setCheckSum(FenixDigestUtils.createDigest(stringBuilder.toString()));
    }

    public IGrade getGradeWrapper() {
        return GradeFactory.getInstance().getGrade(this.getGradeValue());
    }

    public String getGradeValue() {
        return this.getGrade().getValue();
    }

    @Deprecated
    public void setGradeValue(String grade) {
        this.setGrade(grade);
    }

    public void setGrade(String grade) {
        this.setGrade(Grade.createGrade(grade, this.getGradeScale()));
    }

    public void setGrade(Grade grade) {
        Thesis thesis;
        if (this.isFinal()) {
            throw new DomainException("EnrolmentEvaluation.cannot.set.grade.final", new String[0]);
        }
        super.setGrade(grade);
        Enrolment enrolment = this.getEnrolment();
        if (enrolment != null && enrolment.getCurricularCourse().isDissertation() && (thesis = enrolment.getThesis()) != null) {
            thesis.setMark(Integer.valueOf(grade.getValue()));
        }
        super.setGradeValue(grade.getValue());
    }

    @Deprecated
    public Registration getStudent() {
        return this.getRegistration();
    }

    public Registration getRegistration() {
        return this.getStudentCurricularPlan().getRegistration();
    }

    public DegreeCurricularPlan getDegreeCurricularPlan() {
        return this.getStudentCurricularPlan().getDegreeCurricularPlan();
    }

    public StudentCurricularPlan getStudentCurricularPlan() {
        return this.getEnrolment().getStudentCurricularPlan();
    }

    public MarkSheet getRectificationMarkSheet() {
        if (this.getEnrolmentEvaluationState().equals(EnrolmentEvaluationState.RECTIFIED_OBJ) && this.getRectification() != null) {
            return this.getRectification().getMarkSheet();
        }
        return null;
    }

    public boolean hasGrade() {
        return !this.getGrade().isEmpty();
    }

    public final boolean hasExamDateYearMonthDay() {
        return this.getExamDateYearMonthDay() != null;
    }

    public boolean isPayable() {
        IImprovementTreasuryEvent event = TreasuryBridgeAPIFactory.implementation().getImprovementTaxTreasuryEvent(this.getRegistration(), this.getExecutionYear());
        return event != null && event.isWithDebitEntry(this);
    }

    public boolean isPayed() {
        IImprovementTreasuryEvent event = TreasuryBridgeAPIFactory.implementation().getImprovementTaxTreasuryEvent(this.getRegistration(), this.getExecutionYear());
        return event != null && event.isPayed(this);
    }

    public ExecutionSemester getExecutionPeriod() {
        if (this.getEvaluationSeason().isImprovement()) {
            return super.getExecutionPeriod();
        }
        if (this.getEnrolment() != null) {
            return this.getEnrolment().getExecutionPeriod();
        }
        return null;
    }

    @Deprecated
    public Date getExamDate() {
        YearMonthDay ymd = this.getExamDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setExamDate(Date date) {
        if (date == null) {
            this.setExamDateYearMonthDay(null);
        } else {
            this.setExamDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getGradeAvailableDate() {
        YearMonthDay ymd = this.getGradeAvailableDateYearMonthDay();
        return ymd == null ? null : new Date(ymd.getYear() - 1900, ymd.getMonthOfYear() - 1, ymd.getDayOfMonth());
    }

    @Deprecated
    public void setGradeAvailableDate(Date date) {
        if (date == null) {
            this.setGradeAvailableDateYearMonthDay(null);
        } else {
            this.setGradeAvailableDateYearMonthDay(YearMonthDay.fromDateFields((Date)date));
        }
    }

    @Deprecated
    public Date getWhen() {
        DateTime dt = this.getWhenDateTime();
        return dt == null ? null : new Date(dt.getMillis());
    }

    @Deprecated
    public void setWhen(Date date) {
        if (date == null) {
            this.setWhenDateTime(null);
        } else {
            this.setWhenDateTime(new DateTime(date.getTime()));
        }
    }
}

