/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacy;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyContest;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacyPeriodConfirmationOption;
import org.fenixedu.academic.domain.mobility.outbound.OutboundMobilityCandidacySubmission;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.exceptions.FenixActionException;
import org.fenixedu.academic.ui.struts.action.student.StudentApplication;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;

@StrutsFunctionality(app=StudentApplication.StudentParticipateApp.class, path="outbound-mobility", titleKey="link.title.student.mobility.outbound")
@Mapping(module="student", path="/erasmusOutboundManagement")
@Forwards(value={@Forward(name="erasmusOutboundManagement", path="/student/erasmusOutboundManagement.jsp")})
public class ErasmusOutboundManagement
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        Student student = ErasmusOutboundManagement.getUserView(request).getPerson().getStudent();
        return this.prepare(mapping, request, student);
    }

    public ActionForward prepare(ActionMapping mapping, HttpServletRequest request, Student student) {
        request.setAttribute("student", (Object)student);
        return mapping.findForward("erasmusOutboundManagement");
    }

    public ActionForward apply(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        Student student = ErasmusOutboundManagement.getUserView(request).getPerson().getStudent();
        OutboundMobilityCandidacyContest contest = (OutboundMobilityCandidacyContest)this.getDomainObject(request, "contestOid");
        contest.apply(student);
        return this.prepare(mapping, request, student);
    }

    public ActionForward removeCandidacy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        OutboundMobilityCandidacy candidacy = (OutboundMobilityCandidacy)this.getDomainObject(request, "candidacyOid");
        candidacy.delete();
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward reorder(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        Student student = ErasmusOutboundManagement.getUserView(request).getPerson().getStudent();
        OutboundMobilityCandidacy candidacy = (OutboundMobilityCandidacy)this.getDomainObject(request, "candidacyOid");
        int index = Integer.parseInt((String)this.getFromRequest(request, "index"));
        candidacy.reorder(index + 1);
        return this.prepare(mapping, request, student);
    }

    public ActionForward selectOption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        OutboundMobilityCandidacySubmission submission = (OutboundMobilityCandidacySubmission)this.getDomainObject(request, "submissionOid");
        OutboundMobilityCandidacyPeriodConfirmationOption option = (OutboundMobilityCandidacyPeriodConfirmationOption)this.getDomainObject(request, "optionOid");
        submission.selectOption(option);
        return this.prepare(mapping, form, request, response);
    }

    public ActionForward removeOption(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixActionException, FenixServiceException {
        OutboundMobilityCandidacySubmission submission = (OutboundMobilityCandidacySubmission)this.getDomainObject(request, "submissionOid");
        OutboundMobilityCandidacyPeriodConfirmationOption option = (OutboundMobilityCandidacyPeriodConfirmationOption)this.getDomainObject(request, "optionOid");
        submission.removeOption(option);
        return this.prepare(mapping, form, request, response);
    }
}

