/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.phd;

import java.util.function.Predicate;
import org.fenixedu.academic.domain.phd.PhdIndividualProgramProcess;
import org.fenixedu.academic.domain.phd.PhdProgramCandidacyProcessState;
import org.fenixedu.academic.util.predicates.InlinePredicate;
import org.fenixedu.academic.util.predicates.OrPredicate;
import org.fenixedu.academic.util.predicates.PredicateContainer;
import org.fenixedu.bennu.core.i18n.BundleUtil;

public enum PhdCandidacyPredicateContainer implements PredicateContainer<PhdIndividualProgramProcess>
{
    DELIVERED{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            final PhdCandidacyPredicate missingInformationFilter = new PhdCandidacyPredicate(PhdProgramCandidacyProcessState.STAND_BY_WITH_MISSING_INFORMATION);
            final PhdCandidacyPredicate completeInformationFilter = new PhdCandidacyPredicate(PhdProgramCandidacyProcessState.STAND_BY_WITH_COMPLETE_INFORMATION);
            return new OrPredicate<PhdIndividualProgramProcess>(){
                {
                    this.add((Predicate)missingInformationFilter);
                    this.add((Predicate)completeInformationFilter);
                }
            };
        }
    }
    ,
    PENDING{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            return new PhdCandidacyPredicate(PhdProgramCandidacyProcessState.PENDING_FOR_COORDINATOR_OPINION);
        }
    }
    ,
    APPROVED{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            final PhdCandidacyPredicate waitingScientificFilter = new PhdCandidacyPredicate(PhdProgramCandidacyProcessState.WAITING_FOR_SCIENTIFIC_COUNCIL_RATIFICATION);
            final PhdCandidacyPredicate ratifiedScientificFilter = new PhdCandidacyPredicate(PhdProgramCandidacyProcessState.RATIFIED_BY_SCIENTIFIC_COUNCIL);
            return new OrPredicate<PhdIndividualProgramProcess>(){
                {
                    this.add((Predicate)waitingScientificFilter);
                    this.add((Predicate)ratifiedScientificFilter);
                }
            };
        }
    }
    ,
    CONCLUDED{

        @Override
        public Predicate<PhdIndividualProgramProcess> getPredicate() {
            return new PhdCandidacyPredicate(PhdProgramCandidacyProcessState.CONCLUDED){

                @Override
                public boolean test(PhdIndividualProgramProcess process2) {
                    return process2.getSeminarProcess() == null && process2.getThesisProcess() == null && super.test(process2);
                }
            };
        }
    };


    @Override
    public String getLocalizedName() {
        return BundleUtil.getString((String)"resources.PhdResources", (String)(PhdCandidacyPredicateContainer.class.getName() + "." + this.name()), (String[])new String[0]);
    }

    private static class PhdCandidacyPredicate
    extends InlinePredicate<PhdIndividualProgramProcess, PhdProgramCandidacyProcessState> {
        public PhdCandidacyPredicate(PhdProgramCandidacyProcessState candidacyState) {
            super(candidacyState);
        }

        @Override
        public boolean test(PhdIndividualProgramProcess process2) {
            return this.checkState(process2) && this.checkValue(process2);
        }

        private boolean checkState(PhdIndividualProgramProcess process2) {
            return process2.getActiveState().isActive();
        }

        private boolean checkValue(PhdIndividualProgramProcess process2) {
            return process2.getCandidacyProcess().getActiveState().equals(this.getValue());
        }
    }
}

