/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.ui.struts.action.academicAdministration.AcademicAdministrationApplication;
import org.fenixedu.academic.ui.struts.action.academicAdministration.executionCourseManagement.CourseLoadOverviewBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.fenixedu.commons.spreadsheet.StyledExcelSpreadsheet;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;

@StrutsFunctionality(app=AcademicAdministrationApplication.AcademicAdminExecutionsApp.class, path="course-load-overview", titleKey="label.courseLoadOverview.viewInconsistencies", bundle="AcademicAdminOffice", accessGroup="academic(VIEW_SCHEDULING_OVERSIGHT)")
@Mapping(path="/courseLoadOverview", module="academicAdministration")
@Forwards(value={@Forward(name="viewInconsistencies", path="/academicAdministration/courseLoadOverview/viewInconsistencies.jsp")})
public class CourseLoadOverviewDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward viewInconsistencies(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CourseLoadOverviewBean bean = (CourseLoadOverviewBean)this.getRenderedObject("courseLoadOverviewBean");
        if (bean == null) {
            bean = new CourseLoadOverviewBean();
        }
        request.setAttribute("courseLoadOverviewBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("viewInconsistencies");
    }

    public ActionForward downloadInconsistencies(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExecutionSemester executionSemester = (ExecutionSemester)this.getDomainObject(request, "executionSemesterOid");
        CourseLoadOverviewBean bean = new CourseLoadOverviewBean(executionSemester);
        StyledExcelSpreadsheet spreadsheet = bean.getInconsistencySpreadsheet();
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-disposition", "attachment; filename=" + BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"label.course.load.inconsistency.filename", (String[])new String[0]) + ".xls");
        try {
            ServletOutputStream writer = response.getOutputStream();
            spreadsheet.getWorkbook().write((OutputStream)writer);
            writer.close();
        }
        catch (IOException e) {
            throw new Error(e);
        }
        return null;
    }
}

