/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.Summary;
import org.fenixedu.academic.dto.SummariesManagementBean;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;

public class LastSummariesToSummariesManagementProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        SummariesManagementBean bean = (SummariesManagementBean)source;
        ShiftType lessonType = bean.getLessonType();
        if (lessonType != null) {
            ExecutionCourse executionCourse = bean.getExecutionCourse();
            ArrayList<Summary> summaries = new ArrayList<Summary>();
            summaries.addAll(executionCourse.getSummariesByShiftType(lessonType));
            Collections.sort(summaries, Summary.COMPARATOR_BY_DATE_AND_HOUR);
            List<Object> result = new ArrayList();
            result = !summaries.isEmpty() && summaries.size() > 4 ? summaries.subList(0, 4) : summaries;
            if (bean.getSummary() != null) {
                result.remove((Object)bean.getSummary());
            }
            return result;
        }
        return new ArrayList();
    }

    public Converter getConverter() {
        return new DomainObjectKeyConverter();
    }
}

