/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.StudentCurricularPlan;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.CycleType;
import org.fenixedu.academic.domain.degreeStructure.OptionalCurricularCourse;
import org.fenixedu.academic.domain.studentCurriculum.CurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.CycleCurriculumGroup;
import org.fenixedu.academic.domain.studentCurriculum.NoCourseGroupCurriculumGroup;
import org.fenixedu.academic.dto.administrativeOffice.dismissal.DismissalBean;
import pt.ist.fenixWebFramework.rendererExtensions.controllers.CopyCheckBoxValuesController;
import pt.ist.fenixWebFramework.rendererExtensions.converters.DomainObjectKeyConverter;
import pt.ist.fenixWebFramework.renderers.InputRenderer;
import pt.ist.fenixWebFramework.renderers.components.HtmlBlockContainer;
import pt.ist.fenixWebFramework.renderers.components.HtmlCheckBox;
import pt.ist.fenixWebFramework.renderers.components.HtmlComponent;
import pt.ist.fenixWebFramework.renderers.components.HtmlMultipleHiddenField;
import pt.ist.fenixWebFramework.renderers.components.HtmlRadioButton;
import pt.ist.fenixWebFramework.renderers.components.HtmlRadioButtonGroup;
import pt.ist.fenixWebFramework.renderers.components.HtmlTable;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableCell;
import pt.ist.fenixWebFramework.renderers.components.HtmlTableRow;
import pt.ist.fenixWebFramework.renderers.components.HtmlText;
import pt.ist.fenixWebFramework.renderers.components.controllers.HtmlController;
import pt.ist.fenixWebFramework.renderers.components.converters.ConversionException;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixWebFramework.renderers.layouts.Layout;
import pt.ist.fenixWebFramework.renderers.model.MetaObjectFactory;
import pt.ist.fenixWebFramework.renderers.schemas.Schema;

public class StudentDismissalRenderer
extends InputRenderer {
    private Integer initialWidth = 60;
    private Integer widthDecreasePerLevel = 3;
    private String tablesClasses = "showinfo3 mvert0";
    private String groupRowClasses = "bgcolor2";
    private String curricularCourseRowClasses = "";
    private String groupCellClasses = "smalltxt, aright";
    private String curricularCourseCellClasses = ", aright";
    private String dismissalType;

    public Integer getInitialWidth() {
        return this.initialWidth;
    }

    public void setInitialWidth(Integer initialWidth) {
        this.initialWidth = initialWidth;
    }

    public Integer getWidthDecreasePerLevel() {
        return this.widthDecreasePerLevel;
    }

    public void setWidthDecreasePerLevel(Integer widthDecreasePerLevel) {
        this.widthDecreasePerLevel = widthDecreasePerLevel;
    }

    public String getTablesClasses() {
        return this.tablesClasses;
    }

    public void setTablesClasses(String tablesClasses) {
        this.tablesClasses = tablesClasses;
    }

    public String getGroupRowClasses() {
        return this.groupRowClasses;
    }

    public void setGroupRowClasses(String groupRowClasses) {
        this.groupRowClasses = groupRowClasses;
    }

    public String getCurricularCourseRowClasses() {
        return this.curricularCourseRowClasses;
    }

    public void setCurricularCourseRowClasses(String curricularCourseRowClasses) {
        this.curricularCourseRowClasses = curricularCourseRowClasses;
    }

    private String[] getGroupCellClasses() {
        return this.groupCellClasses.split(",");
    }

    public void setGroupCellClasses(String groupCellClasses) {
        this.groupCellClasses = groupCellClasses;
    }

    public String getGroupNameClasses() {
        return this.getGroupCellClasses()[0];
    }

    public String getGroupRadioClasses() {
        return this.getGroupCellClasses()[1];
    }

    private String[] getCurricularCourseCellClasses() {
        return this.curricularCourseCellClasses.split(",");
    }

    public void setCurricularCourseCellClasses(String curricularCourseCellClasses) {
        this.curricularCourseCellClasses = curricularCourseCellClasses;
    }

    public String getCurricularCourseNameClasses() {
        return this.getCurricularCourseCellClasses()[0];
    }

    public String getCurricularCourseCheckBoxClasses() {
        return this.getCurricularCourseCellClasses()[1];
    }

    public String getDismissalType() {
        return this.dismissalType;
    }

    public void setDismissalType(String dismissalType) {
        this.dismissalType = dismissalType;
    }

    protected Layout getLayout(Object object, Class type) {
        return new StudentDismissalLayout();
    }

    private static class SelectedOptionalCurricularCoursesKeyConverter
    extends Converter {
        private static final long serialVersionUID = 1L;

        private SelectedOptionalCurricularCoursesKeyConverter() {
        }

        public Object convert(Class type, Object value) {
            String[] values;
            if (value == null) {
                return null;
            }
            DomainObjectKeyConverter converter = new DomainObjectKeyConverter();
            ArrayList<DismissalBean.SelectedOptionalCurricularCourse> result = new ArrayList<DismissalBean.SelectedOptionalCurricularCourse>();
            for (String key : values = (String[])value) {
                String[] parts = key.split(",");
                if (parts.length < 3) {
                    throw new ConversionException("invalid key format: " + key);
                }
                OptionalCurricularCourse curricularCourse = (OptionalCurricularCourse)((Object)converter.convert(type, (Object)parts[0]));
                CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)converter.convert(type, (Object)parts[1]));
                StudentCurricularPlan studentCurricularPlan = (StudentCurricularPlan)((Object)converter.convert(type, (Object)parts[2]));
                DismissalBean.SelectedOptionalCurricularCourse selectedCurricularCourse = new DismissalBean.SelectedOptionalCurricularCourse(curricularCourse, studentCurricularPlan);
                selectedCurricularCourse.setCurriculumGroup(curriculumGroup);
                result.add(selectedCurricularCourse);
            }
            return result;
        }
    }

    private static class SelectedCurricularCoursesKeyConverter
    extends Converter {
        private static final long serialVersionUID = 1L;

        private SelectedCurricularCoursesKeyConverter() {
        }

        public Object convert(Class type, Object value) {
            String[] values;
            if (value == null) {
                return null;
            }
            DomainObjectKeyConverter converter = new DomainObjectKeyConverter();
            ArrayList<DismissalBean.SelectedCurricularCourse> result = new ArrayList<DismissalBean.SelectedCurricularCourse>();
            for (String key : values = (String[])value) {
                String[] parts = key.split(",");
                if (parts.length < 3) {
                    throw new ConversionException("invalid key format: " + key);
                }
                CurricularCourse curricularCourse = (CurricularCourse)((Object)converter.convert(type, (Object)parts[0]));
                CurriculumGroup curriculumGroup = (CurriculumGroup)((Object)converter.convert(type, (Object)parts[1]));
                StudentCurricularPlan studentCurricularPlan = (StudentCurricularPlan)((Object)converter.convert(type, (Object)parts[2]));
                DismissalBean.SelectedCurricularCourse selectedCurricularCourse = new DismissalBean.SelectedCurricularCourse(curricularCourse, studentCurricularPlan);
                selectedCurricularCourse.setCurriculumGroup(curriculumGroup);
                result.add(selectedCurricularCourse);
            }
            return result;
        }
    }

    protected class StudentDismissalLayout
    extends Layout {
        private final CopyCheckBoxValuesController curricularCoursesController = new CopyCheckBoxValuesController();
        private final CopyCheckBoxValuesController optionalCurricularCoursesController = new CopyCheckBoxValuesController();
        private HtmlRadioButtonGroup radioButtonGroup = null;
        private DismissalBean dismissalBean = null;

        protected StudentDismissalLayout() {
        }

        public HtmlComponent createComponent(Object object, Class type) {
            DismissalBean.DismissalType dismissalTypeValue;
            this.dismissalBean = (DismissalBean)object;
            HtmlBlockContainer container = new HtmlBlockContainer();
            if (this.dismissalBean == null || this.dismissalBean.getExecutionPeriod() == null || this.dismissalBean.getStudentCurricularPlan().getStartExecutionPeriod().isAfter(this.dismissalBean.getExecutionPeriod())) {
                return new HtmlText();
            }
            DismissalBean.DismissalType dismissalType = dismissalTypeValue = StudentDismissalRenderer.this.getDismissalType() == null ? this.dismissalBean.getDismissalType() : DismissalBean.DismissalType.valueOf(StudentDismissalRenderer.this.getDismissalType());
            if (dismissalTypeValue == DismissalBean.DismissalType.CURRICULUM_GROUP_CREDITS) {
                this.radioButtonGroup = new HtmlRadioButtonGroup();
                this.radioButtonGroup.bind(StudentDismissalRenderer.this.getInputContext().getMetaObject(), "courseGroup");
                this.radioButtonGroup.setConverter((Converter)new DomainObjectKeyConverter());
                container.addChild((HtmlComponent)this.radioButtonGroup);
                this.generateCourseGroupCycles(container, this.dismissalBean.getStudentCurricularPlan(), this.dismissalBean.getExecutionPeriod());
            } else if (dismissalTypeValue == DismissalBean.DismissalType.CURRICULAR_COURSE_CREDITS) {
                HtmlMultipleHiddenField hiddenCurricularCourses = new HtmlMultipleHiddenField();
                hiddenCurricularCourses.bind(StudentDismissalRenderer.this.getInputContext().getMetaObject(), "dismissals");
                hiddenCurricularCourses.setConverter((Converter)new SelectedCurricularCoursesKeyConverter());
                hiddenCurricularCourses.setController((HtmlController)this.curricularCoursesController);
                container.addChild((HtmlComponent)hiddenCurricularCourses);
                HtmlMultipleHiddenField hiddenOptionalCurricularCourses = new HtmlMultipleHiddenField();
                hiddenOptionalCurricularCourses.bind(StudentDismissalRenderer.this.getInputContext().getMetaObject(), "optionalDismissals");
                hiddenOptionalCurricularCourses.setConverter((Converter)new SelectedOptionalCurricularCoursesKeyConverter());
                hiddenOptionalCurricularCourses.setController((HtmlController)this.optionalCurricularCoursesController);
                container.addChild((HtmlComponent)hiddenOptionalCurricularCourses);
                this.generateCurricularCourses(container, this.dismissalBean.getStudentCurricularPlan(), this.dismissalBean.getExecutionPeriod());
            } else {
                this.radioButtonGroup = new HtmlRadioButtonGroup();
                this.radioButtonGroup.bind(StudentDismissalRenderer.this.getInputContext().getMetaObject(), "curriculumGroup");
                this.radioButtonGroup.setConverter((Converter)new DomainObjectKeyConverter());
                container.addChild((HtmlComponent)this.radioButtonGroup);
                this.generateNoCourseGroupCurriculumGroups(container, this.dismissalBean.getStudentCurricularPlan());
            }
            return container;
        }

        protected void generateNoCourseGroupCurriculumGroups(HtmlBlockContainer container, StudentCurricularPlan studentCurricularPlan) {
            for (NoCourseGroupCurriculumGroup noCourseGroupCurriculumGroup : studentCurricularPlan.getNoCourseGroupCurriculumGroups()) {
                this.generateNoCourseGroupCurriculumGroup(container, studentCurricularPlan, (CurriculumGroup)((Object)noCourseGroupCurriculumGroup), 0);
            }
        }

        protected void generateNoCourseGroupCurriculumGroup(HtmlBlockContainer container, StudentCurricularPlan studentCurricularPlan, CurriculumGroup curriculumGroup, int depth) {
            HtmlTable groupTable = new HtmlTable();
            container.addChild((HtmlComponent)groupTable);
            groupTable.setClasses(StudentDismissalRenderer.this.getTablesClasses());
            groupTable.setStyle("width: " + (StudentDismissalRenderer.this.getInitialWidth() - depth) + "em; margin-left: " + depth + "em;");
            HtmlTableRow htmlTableRow = groupTable.createRow();
            htmlTableRow.setClasses(StudentDismissalRenderer.this.getGroupRowClasses());
            HtmlTableCell nameCell = htmlTableRow.createCell();
            nameCell.setBody((HtmlComponent)new HtmlText(curriculumGroup.getFullPath()));
            nameCell.setClasses(StudentDismissalRenderer.this.getGroupNameClasses());
            HtmlTableCell radioButtonCell = htmlTableRow.createCell();
            HtmlRadioButton radioButton = this.radioButtonGroup.createRadioButton();
            radioButton.setUserValue(MetaObjectFactory.createObject((Object)((Object)curriculumGroup), (Schema)new Schema(CurriculumGroup.class)).getKey().toString());
            radioButton.setChecked(curriculumGroup == this.dismissalBean.getCurriculumGroup());
            radioButtonCell.setBody((HtmlComponent)radioButton);
            radioButtonCell.setClasses(StudentDismissalRenderer.this.getGroupRadioClasses());
            radioButtonCell.setStyle("width: 2em;");
        }

        protected void generateCourseGroupCycles(HtmlBlockContainer blockContainer, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
            if (studentCurricularPlan.isBolonhaDegree()) {
                for (CycleType cycleType : studentCurricularPlan.getDegreeType().getSupportedCyclesToEnrol()) {
                    CourseGroup courseGroup = this.getCourseGroupWithCycleType(studentCurricularPlan, cycleType);
                    if (courseGroup == null) continue;
                    this.generateCourseGroups(blockContainer, studentCurricularPlan, courseGroup, executionSemester, 0);
                }
            } else {
                this.generateCourseGroups(blockContainer, studentCurricularPlan, (CourseGroup)((Object)studentCurricularPlan.getRoot().getDegreeModule()), executionSemester, 0);
            }
        }

        protected CourseGroup getCourseGroupWithCycleType(StudentCurricularPlan studentCurricularPlan, CycleType cycleType) {
            CycleCurriculumGroup curriculumGroup = studentCurricularPlan.getCycle(cycleType);
            return curriculumGroup != null ? curriculumGroup.getDegreeModule() : studentCurricularPlan.getDegreeCurricularPlan().getCycleCourseGroup(cycleType);
        }

        protected void generateCurricularCourses(HtmlBlockContainer blockContainer, StudentCurricularPlan studentCurricularPlan, ExecutionSemester executionSemester) {
            HtmlTable groupTable = new HtmlTable();
            blockContainer.addChild((HtmlComponent)groupTable);
            groupTable.setClasses(StudentDismissalRenderer.this.getTablesClasses());
            groupTable.setStyle("width: " + StudentDismissalRenderer.this.getInitialWidth() + "em; margin-left: 0em;");
            ArrayList<? extends CurricularCourse> orderedCurricularCourses = new ArrayList<CurricularCourse>(this.dismissalBean.getAllCurricularCoursesToDismissal());
            Collections.sort(orderedCurricularCourses, new BeanComparator("name", (Comparator)Collator.getInstance()));
            for (CurricularCourse curricularCourse : orderedCurricularCourses) {
                HtmlTableRow htmlTableRow = groupTable.createRow();
                htmlTableRow.setClasses(StudentDismissalRenderer.this.getCurricularCourseRowClasses());
                HtmlTableCell nameCell = htmlTableRow.createCell();
                String code = curricularCourse.getCode();
                String oneFullName = curricularCourse.getOneFullName(executionSemester);
                String name = " <span class='bold'>" + curricularCourse.getName(this.dismissalBean.getExecutionPeriod()) + "</span> (" + oneFullName.substring(0, oneFullName.lastIndexOf(">")) + ")";
                String codeAndname = StringUtils.isEmpty((String)code) ? name : code + " - " + name;
                nameCell.setBody((HtmlComponent)new HtmlText(codeAndname, false));
                nameCell.setClasses(StudentDismissalRenderer.this.getCurricularCourseNameClasses());
                HtmlTableCell checkBoxCell = htmlTableRow.createCell();
                checkBoxCell.setClasses(StudentDismissalRenderer.this.getCurricularCourseCheckBoxClasses());
                HtmlCheckBox checkBox = new HtmlCheckBox(this.dismissalBean.containsDismissalOrOptionalDismissal(curricularCourse));
                checkBox.setName("curricularCourseCheckBox" + curricularCourse.getExternalId());
                if (curricularCourse.isOptionalCurricularCourse()) {
                    OptionalCurricularCourse optionalCurricularCourse = (OptionalCurricularCourse)((Object)curricularCourse);
                    checkBox.setUserValue(new DismissalBean.SelectedOptionalCurricularCourse(optionalCurricularCourse, studentCurricularPlan).getKey());
                    checkBoxCell.setBody((HtmlComponent)checkBox);
                    this.optionalCurricularCoursesController.addCheckBox(checkBox);
                    continue;
                }
                checkBox.setUserValue(new DismissalBean.SelectedCurricularCourse(curricularCourse, studentCurricularPlan).getKey());
                checkBoxCell.setBody((HtmlComponent)checkBox);
                this.curricularCoursesController.addCheckBox(checkBox);
            }
        }

        protected void generateCourseGroups(HtmlBlockContainer blockContainer, StudentCurricularPlan studentCurricularPlan, CourseGroup courseGroup, ExecutionSemester executionSemester, int depth) {
            HtmlTable groupTable = new HtmlTable();
            blockContainer.addChild((HtmlComponent)groupTable);
            groupTable.setClasses(StudentDismissalRenderer.this.getTablesClasses());
            groupTable.setStyle("width: " + (StudentDismissalRenderer.this.getInitialWidth() - depth) + "em; margin-left: " + depth + "em;");
            HtmlTableRow htmlTableRow = groupTable.createRow();
            htmlTableRow.setClasses(StudentDismissalRenderer.this.getGroupRowClasses());
            HtmlTableCell nameCell = htmlTableRow.createCell();
            nameCell.setBody((HtmlComponent)new HtmlText(courseGroup.getName()));
            nameCell.setClasses(StudentDismissalRenderer.this.getGroupNameClasses());
            HtmlTableCell currentCreditsCell = htmlTableRow.createCell();
            double ectsCreditsForCourseGroup = studentCurricularPlan.getCreditsConcludedForCourseGroup(courseGroup);
            if (ectsCreditsForCourseGroup == 0.0) {
                currentCreditsCell.setBody((HtmlComponent)new HtmlText("ECTS:  -"));
            } else {
                currentCreditsCell.setBody((HtmlComponent)new HtmlText("ECTS: " + ectsCreditsForCourseGroup));
            }
            currentCreditsCell.setClasses("smalltxt");
            currentCreditsCell.setStyle("width: 6em;");
            HtmlTableCell creditsMinCell = htmlTableRow.createCell();
            creditsMinCell.setBody((HtmlComponent)new HtmlText("Min: " + courseGroup.getMinEctsCredits(executionSemester)));
            creditsMinCell.setClasses("smalltxt");
            creditsMinCell.setStyle("width: 6em;");
            HtmlTableCell creditsMaxCell = htmlTableRow.createCell();
            creditsMaxCell.setBody((HtmlComponent)new HtmlText("Max: " + courseGroup.getMaxEctsCredits(executionSemester)));
            creditsMaxCell.setClasses("smalltxt");
            creditsMaxCell.setStyle("width: 6em;");
            HtmlTableCell radioButtonCell = htmlTableRow.createCell();
            HtmlRadioButton radioButton = this.radioButtonGroup.createRadioButton();
            radioButton.setUserValue(MetaObjectFactory.createObject((Object)((Object)courseGroup), (Schema)new Schema(CourseGroup.class)).getKey().toString());
            radioButton.setChecked(courseGroup == this.dismissalBean.getCourseGroup());
            radioButtonCell.setBody((HtmlComponent)radioButton);
            radioButtonCell.setClasses(StudentDismissalRenderer.this.getGroupRadioClasses());
            radioButtonCell.setStyle("width: 2em;");
            for (Context context : courseGroup.getSortedOpenChildContextsWithCourseGroups(executionSemester)) {
                this.generateCourseGroups(blockContainer, studentCurricularPlan, (CourseGroup)((Object)context.getChildDegreeModule()), executionSemester, depth + StudentDismissalRenderer.this.getWidthDecreasePerLevel());
            }
        }
    }
}

