/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.faces.bean.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import javax.faces.model.SelectItem;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.dto.CurricularCourseScopesForPrintDTO;
import org.fenixedu.academic.dto.InfoCurricularCourseScope;
import org.fenixedu.academic.dto.InfoDegreeCurricularPlan;
import org.fenixedu.academic.dto.InfoExecutionYear;
import org.fenixedu.academic.service.services.commons.ReadActiveDegreeCurricularPlansByDegreeType;
import org.fenixedu.academic.service.services.commons.ReadExecutionYearByID;
import org.fenixedu.academic.service.services.commons.ReadNotClosedExecutionYears;
import org.fenixedu.academic.service.services.commons.curriculumHistoric.ReadActiveCurricularCourseScopeByDegreeCurricularPlanAndExecutionYear;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.faces.bean.base.FenixBackingBean;

public class DisplayCurricularPlan
extends FenixBackingBean {
    private String[] choosenDegreeCurricularPlansIDs;
    private String choosenExecutionYearID;

    public String choose() {
        return "success";
    }

    public List getDegreeCurricularPlans() throws FenixServiceException {
        List degreeCurricularPlans = (List)ReadActiveDegreeCurricularPlansByDegreeType.run(DegreeType::isPreBolonhaDegree);
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(degreeCurricularPlans.size());
        for (InfoDegreeCurricularPlan degreeCurricularPlan : degreeCurricularPlans) {
            String label = degreeCurricularPlan.getInfoDegree().getNome() + " - " + degreeCurricularPlan.getName();
            result.add(new SelectItem((Object)degreeCurricularPlan.getExternalId(), label));
        }
        return result;
    }

    public List getExecutionYears() throws FenixServiceException {
        List<InfoExecutionYear> executionYears = ReadNotClosedExecutionYears.run();
        ArrayList<SelectItem> result = new ArrayList<SelectItem>(executionYears.size());
        for (InfoExecutionYear executionYear : executionYears) {
            result.add(new SelectItem((Object)executionYear.getExternalId(), executionYear.getYear()));
        }
        if (executionYears.size() > 0) {
            this.setChoosenExecutionYearID(executionYears.get(executionYears.size() - 1).getExternalId());
        }
        return result;
    }

    public String getChoosenExecutionYear() throws FenixServiceException {
        InfoExecutionYear executionYear = ReadExecutionYearByID.run(this.getChoosenExecutionYearID());
        return executionYear.getYear();
    }

    public List getScopes() throws FenixServiceException {
        ArrayList<InfoCurricularCourseScope> scopes = new ArrayList<InfoCurricularCourseScope>();
        for (String degreeCurricularPlanID : this.getChoosenDegreeCurricularPlansIDs()) {
            SortedSet<DegreeModuleScope> degreeModuleScopes = ReadActiveCurricularCourseScopeByDegreeCurricularPlanAndExecutionYear.run(degreeCurricularPlanID, this.choosenExecutionYearID);
            for (DegreeModuleScope degreeModuleScope : degreeModuleScopes) {
                if (!(degreeModuleScope instanceof CurricularCourseScope.DegreeModuleScopeCurricularCourseScope)) continue;
                scopes.add(InfoCurricularCourseScope.newInfoFromDomain(((CurricularCourseScope.DegreeModuleScopeCurricularCourseScope)degreeModuleScope).getCurricularCourseScope()));
            }
        }
        this.sortScopes(scopes);
        CurricularCourseScopesForPrintDTO scopesForPrintDTO = new CurricularCourseScopesForPrintDTO();
        for (InfoCurricularCourseScope scope : scopes) {
            scopesForPrintDTO.add(scope);
        }
        return scopesForPrintDTO.getDegreeCurricularPlans();
    }

    private void sortScopes(List<InfoCurricularCourseScope> scopes) {
        ComparatorChain comparatorChain = new ComparatorChain();
        comparatorChain.addComparator((Comparator)new BeanComparator("infoCurricularSemester.infoCurricularYear.year"));
        comparatorChain.addComparator((Comparator)new BeanComparator("infoBranch.name"));
        comparatorChain.addComparator((Comparator)new BeanComparator("infoCurricularSemester.semester"));
        comparatorChain.addComparator((Comparator)new BeanComparator("infoCurricularCourse.name"));
        Collections.sort(scopes, comparatorChain);
    }

    public String getChoosenExecutionYearID() {
        return this.choosenExecutionYearID;
    }

    public void setChoosenExecutionYearID(String choosenExecutionYearID) {
        this.choosenExecutionYearID = choosenExecutionYearID;
    }

    public String[] getChoosenDegreeCurricularPlansIDs() {
        return this.choosenDegreeCurricularPlansIDs;
    }

    public void setChoosenDegreeCurricularPlansIDs(String[] choosenDegreeCurricularPlansIDs) {
        this.choosenDegreeCurricularPlansIDs = choosenDegreeCurricularPlansIDs;
    }
}

