/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.servlet.taglib.sop.v3.renderers;

import org.fenixedu.academic.domain.FrequencyType;
import org.fenixedu.academic.dto.InfoExam;
import org.fenixedu.academic.dto.InfoExecutionCourse;
import org.fenixedu.academic.dto.InfoLesson;
import org.fenixedu.academic.dto.InfoLessonInstance;
import org.fenixedu.academic.dto.InfoShowOccupation;
import org.fenixedu.academic.dto.InfoWrittenTest;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlot;
import org.fenixedu.academic.servlet.taglib.sop.v3.LessonSlotContentRenderer;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.spaces.domain.Space;

public class ClassTimeTableWithoutLinksLessonContentRenderer
extends LessonSlotContentRenderer {
    @Override
    public StringBuilder render(String context, LessonSlot lessonSlot) {
        StringBuilder strBuffer = new StringBuilder();
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLesson) {
            InfoLesson lesson = (InfoLesson)showOccupation;
            if (lessonSlot.isSinleSlot() || !lessonSlot.getInfoLessonWrapper().isFirstRowAlreadyAppended()) {
                strBuffer.append(lesson.getInfoShift().getInfoDisciplinaExecucao().getSigla());
            }
            if (lessonSlot.isSinleSlot()) {
                strBuffer.append("<br/>");
            }
            if (lessonSlot.isSinleSlot() || !lessonSlot.getInfoLessonWrapper().isSecondRowAlreadyAppended()) {
                strBuffer.append("(").append(lesson.getInfoShift().getShiftTypesCodePrettyPrint()).append(")&nbsp;");
                Space allocatableSpace = lesson.getAllocatableSpace();
                if (allocatableSpace != null) {
                    strBuffer.append(allocatableSpace.getName());
                }
                if (lesson.getFrequency().equals((Object)FrequencyType.BIWEEKLY)) {
                    strBuffer.append("&nbsp;&nbsp;[Q]");
                }
            }
            if (lessonSlot.isSinleSlot() || lessonSlot.getInfoLessonWrapper().isFirstRowAlreadyAppended() && !lessonSlot.getInfoLessonWrapper().isSecondRowAlreadyAppended()) {
                lessonSlot.getInfoLessonWrapper().setSecondRowAlreadyAppended(true);
            }
            if (lessonSlot.isSinleSlot() || !lessonSlot.getInfoLessonWrapper().isFirstRowAlreadyAppended()) {
                lessonSlot.getInfoLessonWrapper().setFirstRowAlreadyAppended(true);
            }
        } else if (showOccupation instanceof InfoLessonInstance) {
            InfoLessonInstance lesson = (InfoLessonInstance)showOccupation;
            if (lessonSlot.isSinleSlot() || !lessonSlot.getInfoLessonWrapper().isFirstRowAlreadyAppended()) {
                strBuffer.append(lesson.getInfoShift().getInfoDisciplinaExecucao().getSigla());
            }
            if (lessonSlot.isSinleSlot()) {
                strBuffer.append("<br/>");
            }
            if (lessonSlot.isSinleSlot() || lessonSlot.getInfoLessonWrapper().isFirstRowAlreadyAppended() && !lessonSlot.getInfoLessonWrapper().isSecondRowAlreadyAppended()) {
                strBuffer.append("(").append(lesson.getShiftTypeCodesPrettyPrint()).append(")&nbsp;");
                if (lesson.getInfoRoomOccupation() != null) {
                    strBuffer.append(lesson.getInfoRoomOccupation().getInfoRoom().getNome());
                }
            }
            if (lessonSlot.isSinleSlot() || lessonSlot.getInfoLessonWrapper().isFirstRowAlreadyAppended() && !lessonSlot.getInfoLessonWrapper().isSecondRowAlreadyAppended()) {
                lessonSlot.getInfoLessonWrapper().setSecondRowAlreadyAppended(true);
            }
            if (lessonSlot.isSinleSlot() || !lessonSlot.getInfoLessonWrapper().isFirstRowAlreadyAppended()) {
                lessonSlot.getInfoLessonWrapper().setFirstRowAlreadyAppended(true);
            }
        } else if (showOccupation instanceof InfoExam) {
            InfoExam infoExam = (InfoExam)showOccupation;
            for (int iterEC = 0; iterEC < infoExam.getAssociatedExecutionCourse().size(); ++iterEC) {
                InfoExecutionCourse infoEC = infoExam.getAssociatedExecutionCourse().get(iterEC);
                if (iterEC != 0) {
                    strBuffer.append(", ");
                }
                strBuffer.append(infoEC.getSigla());
            }
            strBuffer.append(" - ");
            strBuffer.append(infoExam.getSeason().getSeason());
            strBuffer.append("\u00aa \u00e9poca");
        } else if (showOccupation instanceof InfoWrittenTest) {
            InfoWrittenTest infoWrittenTest = (InfoWrittenTest)showOccupation;
            for (int iterEC = 0; iterEC < infoWrittenTest.getAssociatedExecutionCourse().size(); ++iterEC) {
                InfoExecutionCourse infoEC = infoWrittenTest.getAssociatedExecutionCourse().get(iterEC);
                if (iterEC != 0) {
                    strBuffer.append(", ");
                }
                strBuffer.append(infoEC.getSigla());
            }
            strBuffer.append(" - ");
            strBuffer.append(infoWrittenTest.getDescription());
        }
        return strBuffer;
    }

    @Override
    public String renderSecondLine(String context, LessonSlot lessonSlot) {
        StringBuilder builder = new StringBuilder();
        InfoShowOccupation showOccupation = lessonSlot.getInfoLessonWrapper().getInfoShowOccupation();
        if (showOccupation instanceof InfoLesson) {
            InfoLesson infoLesson = (InfoLesson)showOccupation;
            builder.append("<span>");
            builder.append(BundleUtil.getString((String)"resources.CandidateResources", (String)"label.weeks", (String[])new String[0]));
            builder.append(": &nbsp;&nbsp;");
            builder.append(infoLesson.getOccurrenceWeeksAsString());
            builder.append("&nbsp;");
            builder.append("</span>");
        }
        builder.append(super.renderSecondLine(context, lessonSlot));
        return builder.toString();
    }
}

