/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.service.services.resourceAllocationManager;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.Installation;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.Shift;
import org.fenixedu.academic.domain.student.Registration;
import org.fenixedu.academic.domain.util.email.ConcreteReplyTo;
import org.fenixedu.academic.domain.util.email.Message;
import org.fenixedu.academic.domain.util.email.Recipient;
import org.fenixedu.academic.domain.util.email.ReplyTo;
import org.fenixedu.academic.domain.util.email.Sender;
import org.fenixedu.academic.domain.util.email.SystemSender;
import org.fenixedu.academic.predicate.AccessControl;
import org.fenixedu.academic.predicate.RolePredicates;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.resourceAllocationManager.ChangeStudentsShift$callable$run;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.UserGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ChangeStudentsShift {
    public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static void run(User user, String string, String string2, Set<Registration> set) throws FenixServiceException {
        Object object = advice$run.perform((Callable)new ChangeStudentsShift$callable$run(user, string, string2, set));
    }

    static /* synthetic */ void advised$run(User userView, String oldShiftId, String newShiftId, Set<Registration> registrations) throws FenixServiceException {
        AccessControl.check(RolePredicates.RESOURCE_ALLOCATION_MANAGER_PREDICATE);
        if (newShiftId != null && newShiftId.isEmpty()) {
            return;
        }
        Shift oldShift = (Shift)FenixFramework.getDomainObject((String)oldShiftId);
        Shift newShift = (Shift)FenixFramework.getDomainObject((String)newShiftId);
        if (!(newShift == null || oldShift != null && oldShift.getTypes().containsAll(newShift.getTypes()) && newShift.getTypes().containsAll(oldShift.getTypes()) && oldShift.getExecutionCourse().equals((Object)newShift.getExecutionCourse()))) {
            throw new UnableToTransferStudentsException();
        }
        HashSet<Person> recievers = new HashSet<Person>();
        oldShift.getStudentsSet().removeAll(registrations);
        if (newShift != null) {
            newShift.getStudentsSet().addAll(registrations);
        }
        for (Registration registration : registrations) {
            recievers.add(registration.getPerson());
        }
        String subject = ChangeStudentsShift.getString("changeStudentsShift.email.subject", new String[0]);
        String groupName = ChangeStudentsShift.getString("changeStudentsShift.email.groupName", oldShift.getNome());
        String messagePrefix = ChangeStudentsShift.getString("changeStudentsShift.email.body", oldShift.getNome());
        String messagePosfix = newShift == null ? ChangeStudentsShift.getString("changeStudentsShift.email.body.notNewShift", new String[0]) : ChangeStudentsShift.getString("changeStudentsShift.email.body.newShift", oldShift.getNome());
        String message = messagePrefix + messagePosfix;
        Recipient recipient = new Recipient(groupName, UserGroup.of(Person.convertToUsers(recievers)));
        SystemSender sender = Bennu.getInstance().getSystemSender();
        String gopEmailAddress = Installation.getInstance().getInstituitionalEmailAddress("gop");
        new Message((Sender)((Object)sender), (Collection<? extends ReplyTo>)new ConcreteReplyTo(gopEmailAddress).asCollection(), recipient.asCollection(), subject, message, "");
    }

    private static String getString(String key, String ... args) {
        return BundleUtil.getString((String)"resources.ResourceManagerResources", (String)key, (String[])args);
    }

    public static class UnableToTransferStudentsException
    extends FenixServiceException {
    }
}

