/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.student;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanComparator;
import org.fenixedu.academic.domain.Attends;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.Evaluation;
import org.fenixedu.academic.domain.Exam;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.Grouping;
import org.fenixedu.academic.domain.StudentGroup;
import org.fenixedu.academic.domain.WrittenEvaluation;
import org.fenixedu.academic.domain.WrittenEvaluationEnrolment;
import org.fenixedu.academic.domain.WrittenTest;
import org.fenixedu.academic.domain.student.Student;
import org.fenixedu.academic.util.EvaluationType;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class StudentPortalBean
implements Serializable {
    private Degree degree;
    private Student student;
    private List<ExecutionCoursesAnnouncements> executionCoursesAnnouncements;

    public StudentPortalBean(Degree degree, Student student, Set<ExecutionCourse> executionCourses, DegreeCurricularPlan activeDegreeCurricularPlan) {
        this.setDegree(degree);
        this.setStudent(student);
        this.setExecutionCoursesAnnouncements(new ArrayList<ExecutionCoursesAnnouncements>());
        for (ExecutionCourse executionCourse : executionCourses) {
            this.addExecutionCoursesAnnouncement(new ExecutionCoursesAnnouncements(executionCourse));
        }
        Collections.sort(this.getExecutionCoursesAnnouncements(), new BeanComparator("executionCourse.name"));
    }

    public Degree getDegree() {
        return this.degree;
    }

    public Student getStudent() {
        return this.student;
    }

    public List<ExecutionCoursesAnnouncements> getExecutionCoursesAnnouncements() {
        return this.executionCoursesAnnouncements;
    }

    public void setDegree(Degree degree) {
        this.degree = degree;
    }

    public void setStudent(Student student) {
        this.student = student;
    }

    public void setExecutionCoursesAnnouncements(List<ExecutionCoursesAnnouncements> executionCoursesAnnouncements) {
        this.executionCoursesAnnouncements = executionCoursesAnnouncements;
    }

    public void addExecutionCoursesAnnouncement(ExecutionCoursesAnnouncements executionCoursesAnnouncement) {
        this.getExecutionCoursesAnnouncements().add(executionCoursesAnnouncement);
    }

    public class ExecutionCoursesAnnouncements {
        private ExecutionCourse executionCourse;
        private List<EvaluationAnnouncement> evaluationAnnouncements;

        public ExecutionCoursesAnnouncements(ExecutionCourse executionCourse) {
            this.setExecutionCourse(executionCourse);
            this.setEvaluationAnnouncements(new ArrayList<EvaluationAnnouncement>());
            for (Evaluation evaluation : executionCourse.getOrderedAssociatedEvaluations()) {
                if (evaluation.getEvaluationType() == EvaluationType.TEST_TYPE) {
                    this.addEvaluationAnnouncement(new EvaluationAnnouncement((WrittenTest)((Object)evaluation)));
                    continue;
                }
                if (evaluation.getEvaluationType() != EvaluationType.EXAM_TYPE) continue;
                this.addEvaluationAnnouncement(new EvaluationAnnouncement((Exam)((Object)evaluation)));
            }
            for (Grouping grouping : executionCourse.getGroupings()) {
                this.addEvaluationAnnouncement(new EvaluationAnnouncement(grouping));
            }
        }

        public ExecutionCourse getExecutionCourse() {
            return this.executionCourse;
        }

        public List<EvaluationAnnouncement> getEvaluationAnnouncements() {
            Collections.sort(this.evaluationAnnouncements, new Comparator(){

                public int compare(Object o1, Object o2) {
                    EvaluationAnnouncement e1 = (EvaluationAnnouncement)o1;
                    EvaluationAnnouncement e2 = (EvaluationAnnouncement)o2;
                    if (!e1.getStatus().equals("disabled") && e2.getStatus().equals("disabled")) {
                        return -1;
                    }
                    return 1;
                }
            });
            return this.evaluationAnnouncements;
        }

        public void setEvaluationAnnouncements(List<EvaluationAnnouncement> evaluationAnnouncements) {
            this.evaluationAnnouncements = evaluationAnnouncements;
        }

        public void addEvaluationAnnouncement(EvaluationAnnouncement evaluationAnnouncement) {
            this.getEvaluationAnnouncements().add(evaluationAnnouncement);
        }

        public void setExecutionCourse(ExecutionCourse executionCourse) {
            this.executionCourse = executionCourse;
        }

        public class EvaluationAnnouncement {
            private String evaluationType;
            private String identification;
            private String realization;
            private String register;
            private String enrolment;
            private String room;
            private boolean realizationPast;
            private boolean enrolmentElapsing;
            private boolean enrolmentPast;
            private boolean registered;
            private boolean groupEnrolment;

            public EvaluationAnnouncement(WrittenTest writtenTest) {
                this.setEvaluationType(writtenTest.getEvaluationType().toString());
                this.setIdentification(writtenTest.getDescription());
                this.setRegister(this.isStudentEnrolled((WrittenEvaluation)((Object)writtenTest)));
                this.setRealization((WrittenEvaluation)((Object)writtenTest));
                this.setEnrolment((WrittenEvaluation)((Object)writtenTest));
                this.setRoom((WrittenEvaluation)((Object)writtenTest));
                this.setGroupEnrolment(false);
            }

            public EvaluationAnnouncement(Exam exam) {
                this.setEvaluationType(exam.getEvaluationType().toString());
                this.setIdentification(exam.getName());
                this.setRegister(this.isStudentEnrolled((WrittenEvaluation)((Object)exam)));
                this.setRealization((WrittenEvaluation)((Object)exam));
                this.setEnrolment((WrittenEvaluation)((Object)exam));
                this.setRoom((WrittenEvaluation)((Object)exam));
                this.setGroupEnrolment(false);
            }

            public EvaluationAnnouncement(Grouping grouping) {
                this.setEvaluationType(BundleUtil.getString((String)"resources.ApplicationResources", (String)"label.grouping", (String[])new String[0]));
                this.setIdentification(grouping.getName());
                this.setRegister(this.isStudentEnrolled(grouping));
                this.setRealization(grouping);
                this.setEnrolment(grouping);
                this.setRoom("-");
                this.setGroupEnrolment(true);
            }

            private boolean isStudentEnrolled(WrittenEvaluation writtenEvaluation) {
                for (WrittenEvaluationEnrolment writtenEvaluationEnrolment : writtenEvaluation.getWrittenEvaluationEnrolmentsSet()) {
                    if (writtenEvaluationEnrolment.getStudent() == null || writtenEvaluationEnrolment.getStudent().getStudent() != StudentPortalBean.this.getStudent()) continue;
                    return true;
                }
                return false;
            }

            private boolean isStudentEnrolled(Grouping grouping) {
                for (StudentGroup studentGroup : grouping.getStudentGroupsSet()) {
                    for (Attends attends : studentGroup.getAttendsSet()) {
                        if (attends.getAluno().getStudent() != StudentPortalBean.this.getStudent()) continue;
                        return true;
                    }
                }
                return false;
            }

            public String getEvaluationType() {
                return this.evaluationType;
            }

            public String getIdentification() {
                return this.identification;
            }

            public String getRealization() {
                return this.realization;
            }

            public String getEnrolment() {
                return this.enrolment;
            }

            public String getRoom() {
                return this.room;
            }

            public String getRegister() {
                return this.register;
            }

            public boolean getRegistered() {
                return this.registered;
            }

            public boolean getRealizationPast() {
                return this.realizationPast;
            }

            public boolean getEnrolmentElapsing() {
                return this.enrolmentElapsing;
            }

            public boolean getEnrolmentPast() {
                return this.enrolmentPast;
            }

            public String getStatus() {
                if (this.getEvaluationType().equals("Agrupamento")) {
                    if (!this.getRegistered() && this.getEnrolmentPast()) {
                        return "disabled";
                    }
                } else {
                    if (this.getRealizationPast()) {
                        return "disabled";
                    }
                    if (!this.getRegistered() && this.getEnrolmentElapsing()) {
                        return "elapsing";
                    }
                }
                return "";
            }

            public void setEvaluationType(String evaluationType) {
                this.evaluationType = evaluationType;
            }

            public void setIdentification(String identification) {
                this.identification = identification;
            }

            public void setRealization(WrittenEvaluation writtenEvaluation) {
                this.realizationPast = writtenEvaluation.getBeginningDateTime().isBeforeNow();
                this.realization = YearMonthDay.fromDateFields((Date)writtenEvaluation.getBeginningDateTime().toDate()).toString() + " " + writtenEvaluation.getBeginningDateTime().getHourOfDay() + ":" + (writtenEvaluation.getBeginningDateTime().getMinuteOfHour() == 0 ? "00" : Integer.valueOf(writtenEvaluation.getBeginningDateTime().getMinuteOfHour()));
            }

            public void setRealization(Grouping grouping) {
                this.realization = "-";
            }

            private DateTime toDateTime(Calendar date, Calendar time) {
                if (date == null || time == null) {
                    return new DateTime((Object)null);
                }
                return new DateTime(date.getTimeInMillis()).withFields((ReadablePartial)new LocalTime(time.getTimeInMillis()));
            }

            public void setEnrolment(WrittenEvaluation writtenEvaluation) {
                Calendar endDay = writtenEvaluation.getEnrollmentEndDay();
                this.enrolmentPast = new DateTime((Object)endDay).isBeforeNow();
                Calendar beginDay = writtenEvaluation.getEnrollmentBeginDay();
                Calendar beginTime = writtenEvaluation.getEnrollmentBeginTime();
                Calendar endTime = writtenEvaluation.getEnrollmentEndTime();
                DateTime beginDateTime = this.toDateTime(beginDay, beginTime);
                DateTime endDateTime = this.toDateTime(endDay, endTime);
                Interval interval = new Interval((ReadableInstant)beginDateTime, (ReadableInstant)endDateTime);
                this.enrolmentElapsing = interval.containsNow();
                if (writtenEvaluation.getEnrollmentBeginDayDateYearMonthDay() != null && writtenEvaluation.getEnrollmentEndDayDateYearMonthDay() != null) {
                    this.enrolment = writtenEvaluation.getEnrollmentBeginDayDateYearMonthDay().toString() + " " + BundleUtil.getString((String)"resources.StudentResources", (String)"message.out.until", (String[])new String[0]) + " " + writtenEvaluation.getEnrollmentEndDayDateYearMonthDay().toString();
                } else {
                    this.enrolment = "-";
                    this.register = "-";
                }
            }

            public void setEnrolment(Grouping grouping) {
                this.enrolmentPast = new DateTime((Object)grouping.getEnrolmentEndDay()).isBeforeNow();
                this.enrolmentElapsing = new DateTime((Object)grouping.getEnrolmentBeginDay()).isBeforeNow() && new DateTime((Object)grouping.getEnrolmentEndDay()).isAfterNow();
                this.enrolment = YearMonthDay.fromDateFields((Date)grouping.getEnrolmentBeginDayDate()).toString() + " " + BundleUtil.getString((String)"resources.StudentResources", (String)"message.out.until", (String[])new String[0]) + " " + YearMonthDay.fromDateFields((Date)grouping.getEnrolmentEndDayDate()).toString();
            }

            public void setRoom(WrittenEvaluation writtenEvaluation) {
                for (WrittenEvaluationEnrolment writtenEvaluationEnrolment : writtenEvaluation.getWrittenEvaluationEnrolmentsSet()) {
                    if (writtenEvaluationEnrolment.getStudent() == null || writtenEvaluationEnrolment.getStudent().getStudent() != StudentPortalBean.this.getStudent()) continue;
                    if (writtenEvaluationEnrolment.getRoom() == null) break;
                    this.room = writtenEvaluationEnrolment.getRoom().getName();
                    return;
                }
                this.room = !writtenEvaluation.getAssociatedRooms().isEmpty() ? writtenEvaluation.getAssociatedRoomsAsString() : "-";
            }

            public void setRoom(String room) {
                this.room = room;
            }

            public void setRegister(Boolean registered) {
                String label = registered != false ? "label.enroled" : "message.out.not.enrolled";
                this.register = BundleUtil.getString((String)"resources.StudentResources", (String)label, (String[])new String[0]);
                this.setRegistered(registered);
            }

            public void setRegistered(Boolean registered) {
                this.registered = registered;
            }

            public void setGroupEnrolment(boolean groupEnrolment) {
                this.groupEnrolment = groupEnrolment;
            }

            public boolean isGroupEnrolment() {
                return this.groupEnrolment;
            }
        }
    }
}

