/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.spaceManager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.space.SpaceUtils;
import org.fenixedu.academic.domain.space.WrittenEvaluationSpaceOccupation;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.LinkObject;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.spaces.domain.Space;
import org.fenixedu.spaces.domain.occupation.Occupation;
import org.fenixedu.spaces.domain.occupation.SharedOccupation;

public class FindSpacesBean
implements Serializable {
    private String labelToSearch;
    private Space buildingReference;
    private Space campusReference;
    private List<LinkObject> spacePath;
    private Space selectedSpaceReference;
    private Boolean extraOptions;
    private Boolean withSchedule;
    private Boolean withWrittenEvaluations;
    private SpacesSearchCriteriaType searchType;
    private AcademicInterval academicInterval;

    public FindSpacesBean() {
        this.setExtraOptions(false);
        this.setSearchType(SpacesSearchCriteriaType.SPACE);
    }

    public FindSpacesBean(Space space, AcademicInterval academicInterval) {
        this();
        this.setSpace(space);
        this.setAcademicInterval(academicInterval);
    }

    public FindSpacesBean(Space space, SpacesSearchCriteriaType criteriaType, AcademicInterval academicInterval) {
        this.setSpace(space);
        this.setExtraOptions(false);
        this.setSearchType(criteriaType);
        this.setAcademicInterval(academicInterval);
    }

    public List<LinkObject> getSuroundingSpacePath() {
        Space space = this.getSpace();
        return space != null ? this.getPath(space.getParent()) : this.getPath(null);
    }

    public List<LinkObject> getSpacePath() {
        return this.getPath(this.getSpace());
    }

    private List<LinkObject> getPath(Space space) {
        ArrayList<LinkObject> result = new ArrayList<LinkObject>();
        if (space != null) {
            List<Space> spaceFullPath = SpaceUtils.getSpaceFullPath(space);
            for (Space surroundingSpace : spaceFullPath) {
                result.add(new LinkObject(surroundingSpace.getExternalId(), "viewSpace", surroundingSpace.getName()));
            }
        }
        return result;
    }

    public void setSpacePath(List<LinkObject> spacePath) {
        this.spacePath = spacePath;
    }

    public void setSpace(Space space) {
        this.selectedSpaceReference = space;
    }

    public Space getSpace() {
        return this.selectedSpaceReference;
    }

    public void setAcademicInterval(AcademicInterval academicInterval) {
        this.academicInterval = academicInterval;
    }

    public AcademicInterval getAcademicInterval() {
        return this.academicInterval;
    }

    public void setBuilding(Space building) {
        this.buildingReference = building;
    }

    public Space getBuilding() {
        return this.buildingReference;
    }

    public void setCampus(Space floor) {
        this.campusReference = floor;
    }

    public Space getCampus() {
        return this.campusReference;
    }

    public String getLabelToSearch() {
        return this.labelToSearch;
    }

    public void setLabelToSearch(String labelToSearch) {
        this.labelToSearch = labelToSearch;
    }

    public Boolean getExtraOptions() {
        return this.extraOptions;
    }

    public void setExtraOptions(Boolean extraOptions) {
        this.extraOptions = extraOptions;
    }

    public Boolean getWithSchedule() {
        Space space = this.getSpace();
        if (space != null && (SpaceUtils.isRoom(space) || SpaceUtils.isRoomSubdivision(space))) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setWithSchedule(Boolean withSchedule) {
        this.withSchedule = withSchedule;
    }

    public SpacesSearchCriteriaType getSearchType() {
        return this.searchType;
    }

    public void setSearchType(SpacesSearchCriteriaType searchType) {
        this.searchType = searchType;
    }

    public Boolean getWithWrittenEvaluations() {
        return this.searchType != null && this.searchType.equals((Object)SpacesSearchCriteriaType.WRITTEN_EVALUATION);
    }

    public void setWithWrittenEvaluations(Boolean withWrittenEvaluations) {
        this.withWrittenEvaluations = withWrittenEvaluations;
    }

    public Boolean getIsOccupiedByWrittenEvaluations() {
        for (Occupation occupation : this.getSpace().getOccupationSet()) {
            if (!(occupation instanceof WrittenEvaluationSpaceOccupation)) continue;
            return true;
        }
        return false;
    }

    public Integer getExamCapacity() {
        Optional metadata = this.getSpace().getMetadata("examCapacity");
        return metadata.isPresent() ? (Integer)metadata.get() : Integer.valueOf(0);
    }

    public List<User> getOccupants() {
        return this.getSpace().getOccupationSet().stream().filter(occ -> occ instanceof SharedOccupation && occ.isActive() != false).map(occ -> (SharedOccupation)occ).map(so -> so.getUser()).distinct().collect(Collectors.toList());
    }

    public static enum SpacesSearchCriteriaType {
        SPACE,
        PERSON,
        EXECUTION_COURSE,
        WRITTEN_EVALUATION;


        public String getName() {
            return this.name();
        }
    }
}

