/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.contacts;

import java.io.Serializable;
import org.fenixedu.academic.domain.contacts.EmailAddress;
import org.fenixedu.academic.domain.contacts.MobilePhone;
import org.fenixedu.academic.domain.contacts.PartyContact;
import org.fenixedu.academic.domain.contacts.PartyContactType;
import org.fenixedu.academic.domain.contacts.Phone;
import org.fenixedu.academic.domain.contacts.PhysicalAddress;
import org.fenixedu.academic.domain.contacts.WebAddress;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.dto.contacts.EmailAddressBean;
import org.fenixedu.academic.dto.contacts.MobilePhoneBean;
import org.fenixedu.academic.dto.contacts.PhoneBean;
import org.fenixedu.academic.dto.contacts.PhysicalAddressBean;
import org.fenixedu.academic.dto.contacts.WebAddressBean;

public abstract class PartyContactBean
implements Serializable {
    private Party party;
    private PartyContact contact;
    private String value;
    private PartyContactType type;
    private Boolean defaultContact = Boolean.FALSE;
    private Boolean visibleToPublic = Boolean.FALSE;
    private Boolean visibleToStudents = Boolean.FALSE;
    private Boolean visibleToStaff = Boolean.FALSE;
    private Boolean visibleToManagement = Boolean.TRUE;

    public PartyContactBean(Party party) {
        this.setParty(party);
    }

    public PartyContactBean(PartyContact partyContact) {
        this.init(partyContact);
    }

    private void init(PartyContact partyContact) {
        this.setParty(partyContact.getParty());
        this.setContact(partyContact);
        this.setType(partyContact.getType());
        this.setDefaultContact(partyContact.getDefaultContact());
        this.setVisibleToPublic(partyContact.getVisibleToPublic());
        this.setVisibleToStudents(partyContact.getVisibleToStudents());
        this.setVisibleToStaff(partyContact.getVisibleToStaff());
    }

    public Party getParty() {
        return this.party;
    }

    public void setParty(Party party) {
        this.party = party;
    }

    public PartyContact getContact() {
        return this.contact;
    }

    public void setContact(PartyContact contact) {
        this.contact = contact;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public PartyContactType getType() {
        return this.type;
    }

    public void setType(PartyContactType type) {
        this.type = type;
    }

    public Boolean getDefaultContact() {
        return this.defaultContact;
    }

    public void setDefaultContact(Boolean defaultContact) {
        this.defaultContact = defaultContact;
    }

    public Boolean getVisibleToPublic() {
        return this.visibleToPublic;
    }

    public void setVisibleToPublic(Boolean visibleToPublic) {
        this.visibleToPublic = visibleToPublic;
    }

    public Boolean getVisibleToStudents() {
        return this.visibleToStudents;
    }

    public void setVisibleToStudents(Boolean visibleToStudents) {
        this.visibleToStudents = visibleToStudents;
    }

    public Boolean getVisibleToStaff() {
        return this.visibleToStaff;
    }

    public void setVisibleToStaff(Boolean visibleToStaff) {
        this.visibleToStaff = visibleToStaff;
    }

    public Boolean getVisibleToManagement() {
        return this.visibleToManagement;
    }

    public void setVisibleToManagement(Boolean visibleToManagement) {
        this.visibleToManagement = visibleToManagement;
    }

    public abstract String getContactName();

    public abstract PartyContact createNewContact();

    public boolean isInstitutional() {
        return this.getType().equals((Object)PartyContactType.INSTITUTIONAL);
    }

    public Boolean edit() {
        boolean isValueChanged = this.isValueChanged();
        boolean createdNewContact = false;
        String newValue = this.getPresentationValue();
        if (isValueChanged && !this.getContact().waitsValidation()) {
            PartyContact contact;
            if (this.getContact().getCurrentPartyContact() != null) {
                contact = this.getContact().getCurrentPartyContact();
                contact.getPartyContactValidation().reset();
            } else {
                contact = this.createNewContact();
                contact.setPrevPartyContact(this.getContact());
                createdNewContact = true;
            }
            this.setContact(contact);
        }
        boolean isChanged = this.setContactProperties();
        this.getParty().logEditContact(this.getContact(), isChanged, isValueChanged, createdNewContact, newValue);
        return isValueChanged;
    }

    protected String getPresentationValue() {
        return this.getValue();
    }

    private boolean setContactProperties() {
        boolean changes = false;
        boolean isDefault = this.getDefaultContact();
        if (!this.isInstitutional() && this.getContact().getType() != this.getType()) {
            changes = true;
        }
        boolean bl = changes = changes || this.getContact().getDefaultContact() != isDefault || this.getContact().getVisibleToPublic().booleanValue() != this.getVisibleToPublic().booleanValue() || this.getContact().getVisibleToStudents().booleanValue() != this.getVisibleToStudents().booleanValue() || this.getContact().getVisibleToStaff().booleanValue() != this.getVisibleToStaff().booleanValue();
        if (changes) {
            if (!this.isInstitutional()) {
                this.getContact().setType(this.getType());
            }
            this.getContact().setDefaultContactInformation(isDefault);
            this.getContact().setVisibleToPublic(this.getVisibleToPublic());
            this.getContact().setVisibleToStudents(this.getVisibleToStudents());
            this.getContact().setVisibleToStaff(this.getVisibleToStaff());
        }
        return changes;
    }

    public boolean hasPartyContact() {
        return false;
    }

    public static PartyContactBean createFromDomain(PartyContact partyContact) {
        if (partyContact instanceof Phone) {
            return new PhoneBean((Phone)((Object)partyContact));
        }
        if (partyContact instanceof MobilePhone) {
            return new MobilePhoneBean((MobilePhone)((Object)partyContact));
        }
        if (partyContact instanceof EmailAddress) {
            return new EmailAddressBean((EmailAddress)((Object)partyContact));
        }
        if (partyContact instanceof WebAddress) {
            return new WebAddressBean((WebAddress)((Object)partyContact));
        }
        if (partyContact instanceof PhysicalAddress) {
            return new PhysicalAddressBean((PhysicalAddress)((Object)partyContact));
        }
        return null;
    }

    public abstract boolean isValueChanged();

    public String getValidationMessageKey() {
        return "label.contact.validation.message." + ((Object)((Object)this.getContact())).getClass().getSimpleName();
    }

    public boolean isToBeValidated() {
        return true;
    }
}

