/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto.accounting;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.organizationalStructure.Party;
import org.fenixedu.academic.domain.organizationalStructure.PartySocialSecurityNumber;
import org.fenixedu.academic.dto.accounting.EntryDTO;
import org.fenixedu.academic.util.Money;
import org.joda.time.DateTime;

public class PaymentsManagementDTO
implements Serializable {
    private static final long serialVersionUID = 3591155631181117718L;
    private Person person;
    private List<EntryDTO> entryDTOs;
    private DateTime paymentDate;
    private boolean differedPayment;
    private Party contributorParty;
    private String contributorNumber;
    private String contributorAddress;
    private String contributorName;
    private boolean usingContributorParty;

    public PaymentsManagementDTO(Person person) {
        this.setPerson(person);
        this.setContributorParty((Party)((Object)person));
        this.setEntryDTOs(new ArrayList<EntryDTO>());
        this.setUsingContributorParty(true);
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public void addEntryDTO(EntryDTO entryDTO) {
        this.entryDTOs.add(entryDTO);
    }

    public void addEntryDTOs(List<EntryDTO> entryDTOs) {
        this.entryDTOs.addAll(entryDTOs);
    }

    public List<EntryDTO> getEntryDTOs() {
        return this.entryDTOs;
    }

    public void setEntryDTOs(List<EntryDTO> entryDTOs) {
        this.entryDTOs = entryDTOs;
    }

    public DateTime getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(DateTime paymentDate) {
        this.paymentDate = paymentDate;
    }

    public boolean isDifferedPayment() {
        return this.differedPayment;
    }

    public void setDifferedPayment(boolean differedPayment) {
        this.differedPayment = differedPayment;
    }

    public List<EntryDTO> getSelectedEntries() {
        ArrayList<EntryDTO> result = new ArrayList<EntryDTO>();
        for (EntryDTO each : this.getEntryDTOs()) {
            if (!each.isSelected()) continue;
            result.add(each);
        }
        return result;
    }

    public Money getTotalAmountToPay() {
        Money result = Money.ZERO;
        for (EntryDTO entryDTO : this.getSelectedEntries()) {
            result = result.add(entryDTO.getAmountToPay());
        }
        return result;
    }

    public Party getContributorParty() {
        return this.contributorParty != null ? this.contributorParty : (StringUtils.isEmpty((String)this.contributorNumber) ? null : Party.readByContributorNumber(this.contributorNumber));
    }

    public void setContributorParty(Party contributorParty) {
        this.contributorParty = contributorParty;
        if (contributorParty != null) {
            this.contributorName = contributorParty.getName();
            this.contributorNumber = contributorParty.getSocialSecurityNumber();
            this.contributorAddress = contributorParty.getAddress() + (!StringUtils.isEmpty((String)contributorParty.getAreaCode()) ? contributorParty.getAreaCode() + " " + contributorParty.getAreaOfAreaCode() : null);
        }
    }

    public PartySocialSecurityNumber getContributorPartySocialSecurityNumber() {
        return this.contributorParty != null ? this.contributorParty.getPartySocialSecurityNumber() : null;
    }

    public void setContributorPartySocialSecurityNumber(PartySocialSecurityNumber partySocialSecurityNumber) {
        this.contributorParty = partySocialSecurityNumber != null ? partySocialSecurityNumber.getParty() : null;
    }

    public String getContributorName() {
        return this.contributorName;
    }

    public void setContributorName(String contributorName) {
        this.contributorName = contributorName;
    }

    public String getContributorNumber() {
        return this.contributorNumber;
    }

    public void setContributorNumber(String contributorNumber) {
        this.contributorNumber = contributorNumber;
    }

    public String getContributorAddress() {
        return this.contributorAddress;
    }

    public void setContributorAddress(String contributorAddress) {
        this.contributorAddress = contributorAddress;
    }

    public boolean isUsingContributorParty() {
        return this.usingContributorParty;
    }

    public void setUsingContributorParty(boolean usingContributorParty) {
        this.usingContributorParty = usingContributorParty;
    }
}

