/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.dto;

import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.dto.InfoExecutionPeriod;
import org.fenixedu.academic.dto.InfoObject;

public class InfoClass
extends InfoObject {
    private final SchoolClass schoolClass;

    public SchoolClass getSchoolClass() {
        return this.schoolClass;
    }

    public InfoClass(SchoolClass schoolClass) {
        this.schoolClass = schoolClass;
    }

    public String getNome() {
        return this.getSchoolClass().getNome();
    }

    public Integer getAnoCurricular() {
        return this.getSchoolClass().getAnoCurricular();
    }

    @Override
    public boolean equals(Object obj) {
        return obj != null && this.getSchoolClass() == ((InfoClass)obj).getSchoolClass();
    }

    public String toString() {
        return this.getSchoolClass().toString();
    }

    public InfoExecutionDegree getInfoExecutionDegree() {
        return InfoExecutionDegree.newInfoFromDomain(this.getSchoolClass().getExecutionDegree());
    }

    public AcademicInterval getAcademicInterval() {
        return this.getSchoolClass().getAcademicInterval();
    }

    @Deprecated
    public InfoExecutionPeriod getInfoExecutionPeriod() {
        return InfoExecutionPeriod.newInfoFromDomain(this.getSchoolClass().getExecutionPeriod());
    }

    public static InfoClass newInfoFromDomain(SchoolClass schoolClass) {
        return schoolClass == null ? null : new InfoClass(schoolClass);
    }

    @Override
    public String getExternalId() {
        return this.getSchoolClass().getExternalId();
    }

    @Override
    public void setExternalId(String integer) {
        throw new Error("Method should not be called!");
    }
}

