/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util.icalendar;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Locale;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.TimeZone;
import net.fortuna.ical4j.model.TimeZoneRegistryFactory;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.CalScale;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.model.property.Version;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.util.icalendar.EventBean;

public class CalendarFactory {
    public static String PROD_ID_APPLICATION = "Sistema Fenix";
    public static TimeZone TIMEZONE = TimeZoneRegistryFactory.getInstance().createRegistry().getTimeZone("Europe/Lisbon");

    private static String digest(String obj) {
        byte[] defaultBytes = obj.getBytes(StandardCharsets.UTF_8);
        try {
            MessageDigest algorithm = MessageDigest.getInstance("SHA-512");
            algorithm.reset();
            algorithm.update(defaultBytes);
            byte[] messageDigest = algorithm.digest();
            StringBuffer hexString = new StringBuffer();
            for (byte element : messageDigest) {
                hexString.append(Integer.toHexString(0xFF & element));
            }
            String foo = messageDigest.toString();
            obj = hexString + "";
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return obj;
    }

    private static VEvent convertEventBean(EventBean event) {
        Date end;
        Date begin;
        if (event.isAllDay()) {
            begin = new Date(event.getBegin().toCalendar(new Locale("pt")).getTime());
            end = new Date(event.getEnd().toCalendar(new Locale("pt")).getTime());
        } else {
            begin = new DateTime(event.getBegin().toCalendar(new Locale("pt")).getTime());
            end = new DateTime(event.getEnd().toCalendar(new Locale("pt")).getTime());
        }
        VEvent vEvent = new VEvent(begin, end, event.getTitle());
        vEvent.getStartDate().setTimeZone(TIMEZONE);
        vEvent.getEndDate().setTimeZone(TIMEZONE);
        if (event.getLocation() != null) {
            vEvent.getProperties().add((Property)new Location(event.getLocation()));
        }
        if (event.getUrl() != null) {
            try {
                vEvent.getProperties().add((Property)new Url(new URI(event.getUrl())));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (event.getNote() != null) {
            vEvent.getProperties().add((Property)new Description(event.getNote()));
        }
        Uid uid = new Uid(CalendarFactory.digest(event.getTitle() + "-" + begin.toGMTString() + "-" + end.toGMTString()));
        vEvent.getProperties().add((Property)uid);
        return vEvent;
    }

    public static Calendar createCalendar(List<EventBean> events) {
        String prodIdCompany = Unit.getInstitutionName().getContent();
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Property)new ProdId("-//" + prodIdCompany + "//" + PROD_ID_APPLICATION + "//PT"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getProperties().add((Property)CalScale.GREGORIAN);
        VTimeZone tz = TIMEZONE.getVTimeZone();
        calendar.getComponents().add((Component)tz);
        for (EventBean eventBean : events) {
            calendar.getComponents().add((Component)CalendarFactory.convertEventBean(eventBean));
        }
        return calendar;
    }
}

