/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.util;

import org.fenixedu.academic.domain.util.Email;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;

@Task(englishTitle="EmailTask", readOnly=true)
public class EmailTask
extends CronTask {
    public void runTask() {
        int sentCounter = 0;
        for (Email email : Bennu.getInstance().getEmailQueueSet()) {
            email.deliver();
            this.getLogger().debug("Sent email: {} succeeded: {} failed: {}", new Object[]{email.getExternalId(), email.getConfirmedAddresses() != null ? email.getConfirmedAddresses().size() : 0, email.getFailedAddresses() != null ? email.getFailedAddresses().size() : 0});
            ++sentCounter;
        }
        if (sentCounter > 0) {
            this.getLogger().info("Sent {} email batches", (Object)sentCounter);
        }
    }
}

