/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.transactions;

import java.math.BigDecimal;
import java.sql.Timestamp;
import org.fenixedu.academic.domain.GratuitySituation;
import org.fenixedu.academic.domain.GuideEntry;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.PersonAccount;
import org.fenixedu.academic.domain.transactions.GratuityTransaction_Base;
import org.fenixedu.academic.domain.transactions.PaymentType;
import org.fenixedu.academic.domain.transactions.TransactionType;
import org.joda.time.DateTime;
import org.joda.time.ReadablePartial;
import org.joda.time.YearMonthDay;

public class GratuityTransaction
extends GratuityTransaction_Base {
    public GratuityTransaction() {
    }

    public GratuityTransaction(Double value, Timestamp transactionDate, String remarks, PaymentType paymentType, TransactionType transactionType, Boolean wasInternalBalance, Person responsiblePerson, PersonAccount personAccount, GuideEntry guideEntry, GratuitySituation gratuitySituation) {
        this();
        this.setValue(value);
        this.setTransactionDate(transactionDate);
        this.setRemarks(remarks);
        this.setPaymentType(paymentType);
        this.setTransactionType(transactionType);
        this.setWasInternalBalance(wasInternalBalance);
        this.setResponsiblePerson(responsiblePerson);
        this.setPersonAccount(personAccount);
        this.setGuideEntry(guideEntry);
        this.setGratuitySituation(gratuitySituation);
    }

    public GratuityTransaction(BigDecimal value, DateTime transactionDateTime, PaymentType paymentType, TransactionType transactionType, Person responsiblePerson, PersonAccount personAccount, GratuitySituation gratuitySituation) {
        this();
        this.setValueBigDecimal(value);
        this.setTransactionDateDateTime(transactionDateTime);
        this.setRemarks(null);
        this.setPaymentType(paymentType);
        this.setTransactionType(transactionType);
        this.setWasInternalBalance(false);
        this.setResponsiblePerson(responsiblePerson);
        this.setPersonAccount(personAccount);
        this.setGuideEntry(null);
        this.setGratuitySituation(gratuitySituation);
    }

    public boolean isInsidePeriod(YearMonthDay start, YearMonthDay end) {
        YearMonthDay date = this.getTransactionDateDateTime().toYearMonthDay();
        return !date.isBefore((ReadablePartial)start) && !date.isAfter((ReadablePartial)end);
    }
}

