/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.serviceRequests.documentRequests;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.academic.domain.serviceRequests.ServiceRequestType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeType;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeTypeInstance$callable$edit;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DocumentPurposeTypeInstance_Base;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DocumentPurposeTypeInstance
extends DocumentPurposeTypeInstance_Base {
    public static Comparator<DocumentPurposeTypeInstance> COMPARE_BY_NAME;
    public static Comparator<DocumentPurposeTypeInstance> COMPARE_BY_LEGACY;
    public static final Advice advice$edit;

    protected DocumentPurposeTypeInstance() {
        this.setBennu(Bennu.getInstance());
    }

    public void delete() {
        this.setBennu(null);
        this.deleteDomainObject();
    }

    public void edit(String string, LocalizedString localizedString, DocumentPurposeType documentPurposeType, boolean bl, List<ServiceRequestType> list) {
        Object object = advice$edit.perform((Callable)new DocumentPurposeTypeInstance$callable$edit(this, string, localizedString, documentPurposeType, bl, list));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$edit(DocumentPurposeTypeInstance this_, String code, LocalizedString name, DocumentPurposeType type, boolean active, List serviceRequestTypes) {
        this_.setCode(code);
        this_.setName(name);
        this_.setDocumentPurposeType(type);
        this_.setActive(active);
        for (ServiceRequestType srt : this_.getServiceRequestTypesSet()) {
            this_.removeServiceRequestTypes(srt);
        }
        if (serviceRequestTypes != null) {
            for (ServiceRequestType srt : serviceRequestTypes) {
                this_.addServiceRequestTypes(srt);
            }
        }
    }

    public static DocumentPurposeTypeInstance create(String code, LocalizedString name) {
        if (DocumentPurposeTypeInstance.findUnique(code) != null) {
            throw new IllegalStateException("DocumentPurposeTypeInstance: could not create new instance because already exists one for the provided code [" + code + "]");
        }
        DocumentPurposeTypeInstance documentPurposeType = new DocumentPurposeTypeInstance();
        documentPurposeType.setCode(code);
        documentPurposeType.setName(name);
        return documentPurposeType;
    }

    public static DocumentPurposeTypeInstance create(String code, LocalizedString name, DocumentPurposeType type) {
        if (DocumentPurposeTypeInstance.findUnique(code) != null) {
            throw new IllegalStateException("DocumentPurposeTypeInstance: could not create new instance because already exists one for the provided code [" + code + "]");
        }
        if (type != null && DocumentPurposeTypeInstance.findUnique(type) != null) {
            throw new IllegalStateException("DocumentPurposeTypeInstance: could not create new instance because already exists one for the provided type [" + type.getName() + "]");
        }
        DocumentPurposeTypeInstance documentPurposeType = new DocumentPurposeTypeInstance();
        documentPurposeType.setCode(code);
        documentPurposeType.setName(name);
        documentPurposeType.setDocumentPurposeType(type);
        return documentPurposeType;
    }

    public static Stream<DocumentPurposeTypeInstance> findAll() {
        return Bennu.getInstance().getDocumentPurposeTypeInstancesSet().stream();
    }

    public static DocumentPurposeTypeInstance findUnique(DocumentPurposeType type) {
        return DocumentPurposeTypeInstance.findAll().filter(dpti -> dpti.getDocumentPurposeType() == type).findFirst().orElse(null);
    }

    public static Stream<DocumentPurposeTypeInstance> findActives() {
        return DocumentPurposeTypeInstance.findAll().filter(DocumentPurposeTypeInstance_Base::getActive);
    }

    public static DocumentPurposeTypeInstance findUnique(String code) {
        return DocumentPurposeTypeInstance.findAll().filter(dpti -> dpti.getCode().equals(code)).findFirst().orElse(null);
    }

    public static Stream<DocumentPurposeTypeInstance> findActivesFor(ServiceRequestType type) {
        return DocumentPurposeTypeInstance.findActives().filter(dpti -> dpti.getServiceRequestTypesSet().contains((Object)type));
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = new Comparator<DocumentPurposeTypeInstance>(){

            @Override
            public int compare(DocumentPurposeTypeInstance dpti1, DocumentPurposeTypeInstance dpti2) {
                return dpti1.getName().compareTo(dpti2.getName());
            }
        };
        COMPARE_BY_LEGACY = new Comparator<DocumentPurposeTypeInstance>(){

            @Override
            public int compare(DocumentPurposeTypeInstance dpti1, DocumentPurposeTypeInstance dpti2) {
                if (dpti1.getDocumentPurposeType() != null && dpti1.getDocumentPurposeType() == DocumentPurposeType.OTHER) {
                    return 1;
                }
                if (dpti2.getDocumentPurposeType() != null && dpti2.getDocumentPurposeType() == DocumentPurposeType.OTHER) {
                    return -1;
                }
                return COMPARE_BY_NAME.compare(dpti1, dpti2);
            }
        };
    }
}

