/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.reports;

import java.math.BigDecimal;
import java.util.Iterator;
import org.fenixedu.academic.domain.Branch;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.CourseLoad;
import org.fenixedu.academic.domain.CurricularCourse;
import org.fenixedu.academic.domain.CurricularCourseScope;
import org.fenixedu.academic.domain.Degree;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeModuleScope;
import org.fenixedu.academic.domain.Department;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.domain.ExecutionSemester;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.ShiftType;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseInformation;
import org.fenixedu.academic.domain.degreeStructure.CompetenceCourseLoad;
import org.fenixedu.academic.domain.degreeStructure.Context;
import org.fenixedu.academic.domain.organizationalStructure.CompetenceCourseGroupUnit;
import org.fenixedu.academic.domain.organizationalStructure.DepartmentUnit;
import org.fenixedu.academic.domain.reports.CourseLoadAndResponsiblesReportFile_Base;
import org.fenixedu.academic.domain.reports.GepReportFile;
import org.fenixedu.commons.spreadsheet.Spreadsheet;

public class CourseLoadAndResponsiblesReportFile
extends CourseLoadAndResponsiblesReportFile_Base {
    public String getJobName() {
        return "Listagem de informa\u00e7\u00e3o sobre disciplinas";
    }

    public String getDescription() {
        return this.getJobName() + " no formato " + this.getType().toUpperCase();
    }

    protected String getPrefix() {
        return "info_disciplinas";
    }

    public void renderReport(Spreadsheet spreadsheet) throws Exception {
        spreadsheet.setHeader("Tipo Curso");
        spreadsheet.setHeader("Nome Curso");
        spreadsheet.setHeader("Sigla Curso");
        spreadsheet.setHeader("Nome Disciplina");
        spreadsheet.setHeader("C\u00f3digo Disciplina Compet\u00eancia");
        spreadsheet.setHeader("C\u00f3digo Disciplina de Execu\u00e7\u00e3o");
        spreadsheet.setHeader("Ano Lectivo");
        spreadsheet.setHeader("Ano Curricular");
        spreadsheet.setHeader("Semestre Lectivo");
        spreadsheet.setHeader("Grupo");
        spreadsheet.setHeader("Responsaveis");
        spreadsheet.setHeader("Departamento");
        spreadsheet.setHeader("Area Cientifica");
        spreadsheet.setHeader("Cr\u00e9ditos ECTS");
        spreadsheet.setHeader("Carga Horaria Total");
        spreadsheet.setHeader("Carga Horaria de Contacto");
        spreadsheet.setHeader("Carga Trabalho Autonomo");
        spreadsheet.setHeader("Carga Horaria Teoricas");
        spreadsheet.setHeader("Carga Horaria Praticas");
        spreadsheet.setHeader("Carga Horaria Teorico-Pr\u00e1tica");
        spreadsheet.setHeader("Carga Horaria Laboratorial");
        spreadsheet.setHeader("Carga Horaria Semin\u00e1rios");
        spreadsheet.setHeader("Carga Horaria Problemas");
        spreadsheet.setHeader("Carga Horaria Trabalho de Campo");
        spreadsheet.setHeader("Carga Horaria Estagio");
        spreadsheet.setHeader("Carga Horaria Orientacao Tutorial");
        spreadsheet.setHeader("C\u00f3digo execucao disciplina");
        spreadsheet.setHeader("C\u00f3digo disciplina competencia");
        spreadsheet.setHeader("Tipo disciplina");
        spreadsheet.setHeader("Valor unit\u00e1rio disciplina (ck)");
        for (Degree degree : Degree.readNotEmptyDegrees()) {
            if (!degree.getDegreeType().equals(this.getDegreeType())) continue;
            for (DegreeCurricularPlan dcp : degree.getDegreeCurricularPlansSet()) {
                for (CurricularCourse curricularCourse : dcp.getAllCurricularCourses()) {
                    if (!curricularCourse.getDegreeType().equals(this.getDegreeType())) continue;
                    for (ExecutionSemester semester : this.getExecutionYear().getExecutionPeriodsSet()) {
                        if (curricularCourse.isActive(semester)) {
                            for (ExecutionCourse executionCourse : curricularCourse.getExecutionCoursesByExecutionPeriod(semester)) {
                                Spreadsheet.Row row = spreadsheet.addRow();
                                this.investigate(curricularCourse, semester, row, executionCourse);
                            }
                            continue;
                        }
                        Spreadsheet.Row row = spreadsheet.addRow();
                        this.investigate(curricularCourse, semester, row, null);
                    }
                }
            }
        }
    }

    private void investigate(CurricularCourse curricularCourse, ExecutionSemester executionPeriod, Spreadsheet.Row row, ExecutionCourse executionCourse) {
        Degree degree = curricularCourse.getDegree();
        DegreeModuleScope degreeModuleScope = this.findDegreeModuleScope(curricularCourse, executionPeriod);
        String group = this.findGroup(curricularCourse, degreeModuleScope);
        String department = this.findDepartment(curricularCourse);
        String scientificArea = this.findScientificAres(curricularCourse);
        CompetenceCourseLoad competenceCourseLoad = this.findCompetenceCourseLoad(curricularCourse, executionPeriod);
        row.setCell(degree.getDegreeType().getName().getContent());
        row.setCell(degree.getNome());
        row.setCell(degree.getSigla());
        row.setCell(curricularCourse.getName());
        row.setCell(curricularCourse.getCompetenceCourse() != null ? GepReportFile.getCompetenceCourseCode(curricularCourse.getCompetenceCourse()) : null);
        row.setCell(executionCourse != null ? GepReportFile.getExecutionCourseCode(executionCourse) : "");
        row.setCell(executionPeriod.getExecutionYear().getName());
        row.setCell(degreeModuleScope != null ? degreeModuleScope.getCurricularYear().toString() : "");
        if (curricularCourse.isAnual()) {
            row.setCell(" ");
        } else {
            row.setCell(degreeModuleScope != null ? degreeModuleScope.getCurricularSemester().toString() : "");
        }
        row.setCell(group);
        row.setCell(executionCourse != null ? this.findResponsibleTeachers(executionCourse) : "");
        row.setCell(department);
        row.setCell(scientificArea);
        row.setCell(this.printDouble(curricularCourse.getEctsCredits(executionPeriod)));
        row.setCell(this.printBigDecimal(this.findTotalCourseLoad(competenceCourseLoad, executionCourse, null)));
        row.setCell(this.printBigDecimal(this.findCourseLoadContact(competenceCourseLoad, executionCourse, null)));
        row.setCell(this.printBigDecimal(this.findAutonomousCourseLoad(competenceCourseLoad)));
        row.setCell(this.printBigDecimal(this.findCourseLoad(competenceCourseLoad, executionCourse, ShiftType.TEORICA)));
        row.setCell(this.printBigDecimal(this.findCourseLoad(competenceCourseLoad, executionCourse, ShiftType.PRATICA)));
        row.setCell(this.printBigDecimal(this.findCourseLoad(competenceCourseLoad, executionCourse, ShiftType.TEORICO_PRATICA)));
        row.setCell(this.printBigDecimal(this.findCourseLoad(competenceCourseLoad, executionCourse, ShiftType.LABORATORIAL)));
        row.setCell(this.printBigDecimal(this.findCourseLoad(competenceCourseLoad, executionCourse, ShiftType.SEMINARY)));
        row.setCell(this.printBigDecimal(this.findCourseLoad(competenceCourseLoad, executionCourse, ShiftType.PROBLEMS)));
        row.setCell(this.printBigDecimal(this.findCourseLoad(competenceCourseLoad, executionCourse, ShiftType.FIELD_WORK)));
        row.setCell(this.printBigDecimal(this.findCourseLoad(competenceCourseLoad, executionCourse, ShiftType.TRAINING_PERIOD)));
        row.setCell(this.printBigDecimal(this.findCourseLoad(competenceCourseLoad, executionCourse, ShiftType.TUTORIAL_ORIENTATION)));
        row.setCell(executionCourse != null ? GepReportFile.getExecutionCourseCode(executionCourse) : "");
        row.setCell(curricularCourse.getCompetenceCourse() != null ? GepReportFile.getCompetenceCourseCode(curricularCourse.getCompetenceCourse()) : "");
        row.setCell(executionCourse != null ? (executionCourse.isDissertation() ? "DISS" : (executionCourse.getProjectTutorialCourse().booleanValue() ? "A" : "B")) : "");
        row.setCell(executionCourse != null && executionCourse.getUnitCreditValue() != null ? executionCourse.getUnitCreditValue().toString() : "");
    }

    private CompetenceCourseLoad findCompetenceCourseLoad(CurricularCourse curricularCourse, ExecutionSemester executionPeriod) {
        Iterator iterator;
        CompetenceCourseInformation competenceCourseInformation;
        CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
        if (competenceCourse != null && (competenceCourseInformation = competenceCourse.findCompetenceCourseInformationForExecutionPeriod(executionPeriod)) != null && (iterator = competenceCourseInformation.getCompetenceCourseLoadsSet().iterator()).hasNext()) {
            CompetenceCourseLoad competenceCourseLoad = (CompetenceCourseLoad)iterator.next();
            return competenceCourseLoad;
        }
        return null;
    }

    private String findScientificAres(CurricularCourse curricularCourse) {
        CompetenceCourseGroupUnit competenceCourseGroupUnit;
        CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
        if (competenceCourse != null && (competenceCourseGroupUnit = competenceCourse.getCompetenceCourseGroupUnit()) != null) {
            return competenceCourseGroupUnit.getName();
        }
        return " ";
    }

    private String findDepartment(CurricularCourse curricularCourse) {
        StringBuilder stringBuilder = new StringBuilder();
        CompetenceCourse competenceCourse = curricularCourse.getCompetenceCourse();
        if (competenceCourse != null) {
            DepartmentUnit departmentUnit = competenceCourse.getDepartmentUnit();
            if (departmentUnit == null) {
                for (Department department : competenceCourse.getDepartmentsSet()) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(department.getName());
                }
            } else {
                stringBuilder.append(departmentUnit.getName());
            }
        }
        return stringBuilder.length() == 0 ? " " : stringBuilder.toString();
    }

    private String findGroup(CurricularCourse curricularCourse, DegreeModuleScope degreeModuleScope) {
        if (degreeModuleScope != null) {
            if (degreeModuleScope instanceof CurricularCourseScope.DegreeModuleScopeCurricularCourseScope) {
                CurricularCourseScope.DegreeModuleScopeCurricularCourseScope degreeModuleScopeCurricularCourseScope = (CurricularCourseScope.DegreeModuleScopeCurricularCourseScope)degreeModuleScope;
                Branch branch = degreeModuleScopeCurricularCourseScope.getCurricularCourseScope().getBranch();
                return branch == null ? " " : branch.getName();
            }
            Context.DegreeModuleScopeContext degreeModuleScopeContext = (Context.DegreeModuleScopeContext)degreeModuleScope;
            Context context = degreeModuleScopeContext.getContext();
            return context.getParentCourseGroup().getName();
        }
        return null;
    }

    private String findResponsibleTeachers(ExecutionCourse executionCourse) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Professorship professorship : executionCourse.getProfessorshipsSet()) {
            if (!professorship.isResponsibleFor()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(professorship.getTeacher().getPerson().getUsername());
        }
        return stringBuilder.length() == 0 ? " " : stringBuilder.toString();
    }

    private DegreeModuleScope findDegreeModuleScope(CurricularCourse curricularCourse, ExecutionSemester executionPeriod) {
        for (DegreeModuleScope degreeModuleScope : curricularCourse.getDegreeModuleScopes()) {
            if (!degreeModuleScope.isActiveForExecutionPeriod(executionPeriod)) continue;
            return degreeModuleScope;
        }
        return null;
    }

    private BigDecimal findTotalCourseLoad(CompetenceCourseLoad competenceCourseLoad, ExecutionCourse executionCourse, ShiftType shiftType) {
        if (competenceCourseLoad != null) {
            BigDecimal bigDecimal = BigDecimal.valueOf(0L);
            bigDecimal = bigDecimal.add(BigDecimal.valueOf(competenceCourseLoad.getTotalLoad()));
            return bigDecimal;
        }
        BigDecimal load = this.findCourseLoadFromExecutionCourse(competenceCourseLoad, executionCourse, shiftType);
        return load != null ? load.multiply(BigDecimal.valueOf(CompetenceCourseLoad.NUMBER_OF_WEEKS)) : BigDecimal.valueOf(0L);
    }

    private BigDecimal findCourseLoadContact(CompetenceCourseLoad competenceCourseLoad, ExecutionCourse executionCourse, ShiftType shiftType) {
        BigDecimal total = this.findTotalCourseLoad(competenceCourseLoad, executionCourse, shiftType);
        BigDecimal autonomous = this.findAutonomousCourseLoad(competenceCourseLoad);
        return total.subtract(autonomous);
    }

    private BigDecimal findAutonomousCourseLoad(CompetenceCourseLoad competenceCourseLoad) {
        return competenceCourseLoad == null ? BigDecimal.valueOf(0L) : BigDecimal.valueOf(competenceCourseLoad.getAutonomousWorkHours());
    }

    private BigDecimal findCourseLoad(CompetenceCourseLoad competenceCourseLoad, ExecutionCourse executionCourse, ShiftType shiftType) {
        if (competenceCourseLoad != null) {
            if (shiftType == null) {
                return this.findTotalCourseLoad(competenceCourseLoad, executionCourse, shiftType);
            }
            if (shiftType == ShiftType.TEORICA) {
                return BigDecimal.valueOf(competenceCourseLoad.getTheoreticalHours());
            }
            if (shiftType == ShiftType.PRATICA) {
                // empty if block
            }
            if (shiftType == ShiftType.TEORICO_PRATICA) {
                // empty if block
            }
            if (shiftType == ShiftType.LABORATORIAL) {
                return BigDecimal.valueOf(competenceCourseLoad.getLaboratorialHours());
            }
            if (shiftType == ShiftType.SEMINARY) {
                return BigDecimal.valueOf(competenceCourseLoad.getSeminaryHours());
            }
            if (shiftType == ShiftType.PROBLEMS) {
                return BigDecimal.valueOf(competenceCourseLoad.getProblemsHours());
            }
            if (shiftType == ShiftType.FIELD_WORK) {
                return BigDecimal.valueOf(competenceCourseLoad.getFieldWorkHours());
            }
            if (shiftType == ShiftType.TRAINING_PERIOD) {
                return BigDecimal.valueOf(competenceCourseLoad.getTrainingPeriodHours());
            }
            if (shiftType == ShiftType.TUTORIAL_ORIENTATION) {
                return BigDecimal.valueOf(competenceCourseLoad.getTutorialOrientationHours());
            }
        }
        return this.findCourseLoadFromExecutionCourse(competenceCourseLoad, executionCourse, shiftType);
    }

    private BigDecimal findCourseLoadFromExecutionCourse(CompetenceCourseLoad competenceCourseLoad, ExecutionCourse executionCourse, ShiftType shiftType) {
        if (executionCourse == null) {
            return null;
        }
        BigDecimal total = BigDecimal.valueOf(0L);
        for (CourseLoad courseLoad : executionCourse.getCourseLoadsSet()) {
            if (shiftType != null && courseLoad.getType() != shiftType) continue;
            total = total.add(courseLoad.getWeeklyHours());
        }
        return total;
    }

    private String printDouble(Double value) {
        return value == null ? "" : value.toString().replace('.', ',');
    }

    private String printBigDecimal(BigDecimal value) {
        return value == null ? "" : value.toPlainString().replace('.', ',');
    }
}

