/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.RegistryDiplomaRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.RegistryDiplomaRequest;
import org.fenixedu.academic.util.LabelFormatter;

public class RegistryDiplomaRequestEvent
extends RegistryDiplomaRequestEvent_Base {
    protected RegistryDiplomaRequestEvent() {
    }

    protected RegistryDiplomaRequestEvent(AdministrativeOffice administrativeOffice, EventType eventType, Person person, RegistryDiplomaRequest registryDiplomaRequest) {
        this();
        super.init(administrativeOffice, eventType, person, (RegistrationAcademicServiceRequest)((Object)registryDiplomaRequest));
    }

    public static final RegistryDiplomaRequestEvent create(AdministrativeOffice administrativeOffice, Person person, RegistryDiplomaRequest registryDiplomaRequest) {
        switch (registryDiplomaRequest.getEventType()) {
            case BOLONHA_DEGREE_REGISTRY_DIPLOMA_REQUEST: 
            case BOLONHA_MASTER_DEGREE_REGISTRY_DIPLOMA_REQUEST: 
            case BOLONHA_ADVANCED_FORMATION_REGISTRY_DIPLOMA_REQUEST: {
                return new RegistryDiplomaRequestEvent(administrativeOffice, registryDiplomaRequest.getEventType(), person, registryDiplomaRequest);
            }
        }
        throw new DomainException("error.registryDiplomaRequestEvent.invalid.event.type.in.creation", new String[0]);
    }

    public LabelFormatter getDescription() {
        LabelFormatter result = super.getDescription();
        this.fillDescription(result);
        return result;
    }

    public final LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        this.fillDescription(labelFormatter);
        return labelFormatter;
    }

    private void fillDescription(LabelFormatter labelFormatter) {
        labelFormatter.appendLabel(" (");
        RegistryDiplomaRequest request = (RegistryDiplomaRequest)((Object)this.getAcademicServiceRequest());
        if (request.getProgramConclusion() != null) {
            labelFormatter.appendLabel(request.getProgramConclusion().getName().getContent()).appendLabel(" ").appendLabel("label.of", "resources.ApplicationResources").appendLabel(" ");
        }
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent());
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel("label.in", "resources.ApplicationResources");
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent());
        labelFormatter.appendLabel(")");
    }
}

