/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accounting.events.serviceRequests;

import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.accounting.EntryType;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.events.serviceRequests.DiplomaRequestEvent_Base;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.serviceRequests.RegistrationAcademicServiceRequest;
import org.fenixedu.academic.domain.serviceRequests.documentRequests.DiplomaRequest;
import org.fenixedu.academic.util.LabelFormatter;

public abstract class DiplomaRequestEvent
extends DiplomaRequestEvent_Base {
    protected DiplomaRequestEvent() {
    }

    protected DiplomaRequestEvent(AdministrativeOffice administrativeOffice, EventType eventType, Person person, DiplomaRequest diplomaRequest) {
        this();
        super.init(administrativeOffice, eventType, person, (RegistrationAcademicServiceRequest)((Object)diplomaRequest));
    }

    public static final DiplomaRequestEvent create(AdministrativeOffice administrativeOffice, Person person, DiplomaRequest diplomaRequest) {
        throw new RuntimeException("Event is deprecated");
    }

    public LabelFormatter getDescription() {
        LabelFormatter result = super.getDescription();
        this.fillDescription(result);
        return result;
    }

    public final LabelFormatter getDescriptionForEntryType(EntryType entryType) {
        LabelFormatter labelFormatter = new LabelFormatter();
        labelFormatter.appendLabel(entryType.name(), "resources.EnumerationResources");
        this.fillDescription(labelFormatter);
        return labelFormatter;
    }

    private void fillDescription(LabelFormatter labelFormatter) {
        labelFormatter.appendLabel(" (");
        DiplomaRequest request = (DiplomaRequest)((Object)this.getAcademicServiceRequest());
        if (request.getRequestedCycle() != null) {
            labelFormatter.appendLabel(request.getRequestedCycle().getQualifiedName(), "resources.EnumerationResources").appendLabel(" ").appendLabel("label.of", "resources.ApplicationResources").appendLabel(" ");
        }
        labelFormatter.appendLabel(this.getDegree().getDegreeType().getName().getContent());
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel("label.in", "resources.ApplicationResources");
        labelFormatter.appendLabel(" ");
        labelFormatter.appendLabel(this.getDegree().getNameFor(this.getExecutionYear()).getContent());
        labelFormatter.appendLabel(")");
    }

    public PostingRule getPostingRule() {
        return this.getAdministrativeOffice().getServiceAgreementTemplate().findPostingRuleByEventTypeAndDate(this.getEventType(), this.getAcademicServiceRequest().getRequestDate());
    }

    public boolean isExemptionAppliable() {
        return true;
    }
}

