/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.academic.domain.accessControl.FenixGroup;
import org.fenixedu.academic.domain.accessControl.PersistentThesisReadersGroup;
import org.fenixedu.academic.domain.thesis.Thesis;
import org.fenixedu.bennu.core.annotation.GroupArgument;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.groups.AnyoneGroup;
import org.fenixedu.bennu.core.groups.LoggedGroup;
import org.joda.time.DateTime;

@GroupOperator(value="thesisReaders")
@Deprecated
public class ThesisReadersGroup
extends FenixGroup {
    private static final long serialVersionUID = -784604571687620343L;
    @GroupArgument
    private Thesis thesis;

    private ThesisReadersGroup() {
    }

    private ThesisReadersGroup(Thesis thesis) {
        this();
        this.thesis = thesis;
    }

    public static ThesisReadersGroup get(Thesis thesis) {
        return new ThesisReadersGroup(thesis);
    }

    @Override
    public String[] getPresentationNameKeyArgs() {
        return new String[]{this.thesis.getTitle().getContent(), this.thesis.getVisibility().getLocalizedName()};
    }

    public Set<User> getMembers() {
        return this.getMembers(new DateTime());
    }

    public Set<User> getMembers(DateTime when) {
        if (this.thesis.isEvaluated() && (this.thesis.getDocumentsAvailableAfter() == null || this.thesis.getDocumentsAvailableAfter().isBeforeNow()) && this.thesis.getVisibility() != null) {
            switch (this.thesis.getVisibility()) {
                case INTRANET: {
                    return LoggedGroup.get().getMembers(when);
                }
                case PUBLIC: {
                    return AnyoneGroup.get().getMembers(when);
                }
            }
        }
        return this.getThesisMembers();
    }

    public boolean isMember(User user) {
        return this.isMember(user, new DateTime());
    }

    public boolean isMember(User user, DateTime when) {
        if (this.thesis.isEvaluated() && (this.thesis.getDocumentsAvailableAfter() == null || this.thesis.getDocumentsAvailableAfter().isBeforeNow()) && this.thesis.getVisibility() != null) {
            switch (this.thesis.getVisibility()) {
                case INTRANET: {
                    return LoggedGroup.get().isMember(user, when);
                }
                case PUBLIC: {
                    return AnyoneGroup.get().isMember(user, when);
                }
            }
        }
        return this.getThesisMembers().contains(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentThesisReadersGroup.getInstance(this.thesis);
    }

    public boolean equals(Object object) {
        if (object instanceof ThesisReadersGroup) {
            return Objects.equal((Object)((Object)this.thesis), (Object)((Object)((ThesisReadersGroup)((Object)object)).thesis));
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.thesis});
    }

    private Set<User> getThesisMembers() {
        Set<User> members = this.thesis.getParticipationsSet().stream().filter(p -> p.getPerson() != null).map(p -> p.getPerson().getUser()).collect(Collectors.toSet());
        members.add(this.thesis.getStudent().getPerson().getUser());
        return members;
    }
}

