/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain.accessControl;

import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import java.util.Set;
import org.fenixedu.academic.domain.Professorship;
import org.fenixedu.academic.domain.accessControl.FenixGroupStrategy;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.joda.time.DateTime;

@GroupOperator(value="professors")
public final class ProfessorsGroup
extends FenixGroupStrategy {
    private static final long serialVersionUID = -7099165263747393201L;

    public Set<User> getMembers() {
        return FluentIterable.from((Iterable)Bennu.getInstance().getProfessorshipsSet()).transform((Function)new Function<Professorship, User>(){

            public User apply(Professorship input) {
                return input.getPerson().getUser();
            }
        }).filter(Predicates.notNull()).toSet();
    }

    public boolean isMember(User user) {
        return user != null && user.getPerson() != null && !user.getPerson().getProfessorshipsSet().isEmpty();
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }
}

