/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.ExternalCurricularCourse_Base;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.organizationalStructure.AccountabilityTypeEnum;
import org.fenixedu.academic.domain.organizationalStructure.SchoolUnit;
import org.fenixedu.academic.domain.organizationalStructure.Unit;
import org.fenixedu.academic.domain.organizationalStructure.UnitUtils;
import org.fenixedu.academic.domain.organizationalStructure.UniversityUnit;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import pt.ist.fenixframework.dml.runtime.RelationAdapter;
import pt.ist.fenixframework.dml.runtime.RelationListener;

public class ExternalCurricularCourse
extends ExternalCurricularCourse_Base {
    public ExternalCurricularCourse(Unit unit, String name, String code) {
        if (unit == null) {
            throw new DomainException("error.externalCurricularCourse.unit.cannot.be.null", new String[0]);
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new DomainException("error.externalCurricularCourse.name.cannot.be.empty", new String[0]);
        }
        this.checkForExternalCurricularCourseWithSameNameAndCode(unit, name, code);
        this.setRootDomainObject(Bennu.getInstance());
        this.setUnit(unit);
        this.setName(name);
        this.setCode(code);
    }

    public void edit(String name, String code) {
        if (StringUtils.isEmpty((String)name)) {
            throw new DomainException("error.externalCurricularCourse.name.cannot.be.empty", new String[0]);
        }
        this.checkForExternalCurricularCourseWithSameNameAndCode(this.getUnit(), name, code);
        this.setName(name);
        this.setCode(code);
    }

    private void checkForExternalCurricularCourseWithSameNameAndCode(Unit unit, String name, String code) {
        String nameToSearch = name.toLowerCase();
        for (ExternalCurricularCourse externalCurricularCourse : unit.getExternalCurricularCoursesSet()) {
            if (!externalCurricularCourse.getName().toLowerCase().equals(nameToSearch) || (externalCurricularCourse.getCode() == null || !externalCurricularCourse.getCode().equals(code)) && (externalCurricularCourse.getCode() != null || code != null)) continue;
            throw new DomainException("error.externalCurricularCourse.parent.unit.already.has.externalCurricularCourse.with.same.type", new String[0]);
        }
    }

    public void delete() {
        DomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        this.setRootDomainObject(null);
        this.setUnit(null);
        super.deleteDomainObject();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        if (!this.getExternalEnrolmentsSet().isEmpty()) {
            blockers.add(BundleUtil.getString((String)"resources.AcademicAdminOffice", (String)"error.external.enrolment.cannot.be.deleted", (String[])new String[0]));
        }
    }

    public String getFullPathName() {
        List<AccountabilityTypeEnum> validAccountabilityTypes = Arrays.asList(AccountabilityTypeEnum.GEOGRAPHIC, AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE, AccountabilityTypeEnum.ACADEMIC_STRUCTURE);
        return UnitUtils.getUnitFullPathName(this.getUnit(), validAccountabilityTypes).toString() + " > " + this.getName();
    }

    public final Unit getAcademicUnit() {
        List<AccountabilityTypeEnum> validAccountabilityTypes = Arrays.asList(AccountabilityTypeEnum.GEOGRAPHIC, AccountabilityTypeEnum.ORGANIZATIONAL_STRUCTURE, AccountabilityTypeEnum.ACADEMIC_STRUCTURE);
        UniversityUnit universityUnit = null;
        Object schoolUnit = null;
        for (Unit unit : UnitUtils.getUnitFullPath(this.getUnit(), validAccountabilityTypes)) {
            if (unit.isUniversityUnit()) {
                universityUnit = (UniversityUnit)((Object)unit);
                continue;
            }
            if (!unit.isSchoolUnit()) continue;
            schoolUnit = (SchoolUnit)((Object)unit);
        }
        return schoolUnit != null ? schoolUnit : universityUnit;
    }

    public static ExternalCurricularCourse readExternalCurricularCourse(Unit unit, String name, String code) {
        for (ExternalCurricularCourse externalCurricularCourse : unit.getExternalCurricularCoursesSet()) {
            if (!externalCurricularCourse.getCode().equals(code) || !externalCurricularCourse.getName().equals(name)) continue;
            return externalCurricularCourse;
        }
        return null;
    }

    public static ExternalCurricularCourse readExternalCurricularCourse(Unit unit, String code) {
        ArrayList<ExternalCurricularCourse> result = new ArrayList<ExternalCurricularCourse>();
        for (ExternalCurricularCourse externalCurricularCourse : unit.getExternalCurricularCoursesSet()) {
            if ((!StringUtils.isEmpty((String)externalCurricularCourse.getCode()) || !StringUtils.isEmpty((String)code)) && !externalCurricularCourse.getCode().equals(code)) continue;
            result.add(externalCurricularCourse);
        }
        if (result.size() == 1) {
            return (ExternalCurricularCourse)((Object)result.iterator().next());
        }
        if (result.size() == 0) {
            return null;
        }
        throw new DomainException("error.externalCurricularCourse.manyFoundWithSameCode", new String[0]);
    }

    public static List<ExternalCurricularCourse> readExternalCurricularCoursesByCode(String code) {
        ArrayList<ExternalCurricularCourse> result = new ArrayList<ExternalCurricularCourse>();
        for (ExternalCurricularCourse externalCurricularCourse : Bennu.getInstance().getExternalCurricularCoursesSet()) {
            if ((!StringUtils.isEmpty((String)externalCurricularCourse.getCode()) || !StringUtils.isEmpty((String)code)) && !externalCurricularCourse.getCode().equals(code)) continue;
            result.add(externalCurricularCourse);
        }
        return result;
    }

    public static List<ExternalCurricularCourse> readByName(String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        String nameToMatch = name.replaceAll("%", ".*").toLowerCase();
        ArrayList<ExternalCurricularCourse> result = new ArrayList<ExternalCurricularCourse>();
        for (ExternalCurricularCourse externalCurricularCourse : Bennu.getInstance().getExternalCurricularCoursesSet()) {
            if (!externalCurricularCourse.getName().toLowerCase().matches(nameToMatch)) continue;
            result.add(externalCurricularCourse);
        }
        return result;
    }

    static {
        ExternalCurricularCourse.getRelationExternalCurricularCourseUnit().addListener((RelationListener)new RelationAdapter<Unit, ExternalCurricularCourse>(){

            public void beforeAdd(Unit unit, ExternalCurricularCourse externalCurricularCourse) {
                if (!(unit == null || unit.isUniversityUnit() || unit.isSchoolUnit() || unit.isDepartmentUnit())) {
                    throw new DomainException("error.extraCurricularCourse.invalid.unit.type", new String[0]);
                }
            }
        });
    }
}

