/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.teacher.executionCourse;

import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.fenixedu.academic.domain.CompetenceCourse;
import org.fenixedu.academic.domain.EvaluationMethod;
import org.fenixedu.academic.domain.ExecutionCourse;
import org.fenixedu.academic.dto.teacher.executionCourse.ImportContentBean;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.service.services.teacher.EditEvaluation;
import org.fenixedu.academic.ui.struts.action.teacher.ManageExecutionCourseDA;
import org.fenixedu.academic.util.MultiLanguageString;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Input;
import org.fenixedu.bennu.struts.annotations.Mapping;

@Mapping(path="/manageEvaluationMethod", module="teacher", functionality=ManageExecutionCourseDA.class, formBean="evaluationMethodForm")
@Forwards(value={@Forward(name="evaluationMethod", path="/teacher/executionCourse/evaluationMethod.jsp"), @Forward(name="editEvaluationMethod", path="/teacher/executionCourse/editEvaluationMethod.jsp"), @Forward(name="importEvaluationMethod", path="/teacher/executionCourse/importEvaluationMethod.jsp")})
public class EvaluationMethodDA
extends ManageExecutionCourseDA {
    @Input
    public ActionForward evaluationMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("evaluationMethod");
    }

    public ActionForward prepareEditEvaluationMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        MultiLanguageString evaluationElements;
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        EvaluationMethod evaluationMethod = executionCourse.getEvaluationMethod();
        MultiLanguageString multiLanguageString = evaluationElements = evaluationMethod == null ? null : evaluationMethod.getEvaluationElements();
        if (evaluationMethod == null || evaluationElements == null || evaluationElements.isEmpty() || StringUtils.isEmpty((String)evaluationElements.getContent())) {
            MultiLanguageString evaluationMethodMls = new MultiLanguageString();
            Set<CompetenceCourse> competenceCourses = executionCourse.getCompetenceCourses();
            if (!competenceCourses.isEmpty()) {
                CompetenceCourse competenceCourse = competenceCourses.iterator().next();
                String pt = competenceCourse.getEvaluationMethod();
                String en = competenceCourse.getEvaluationMethodEn();
                evaluationMethodMls = evaluationMethodMls.with(MultiLanguageString.pt, pt == null ? "" : pt).with(MultiLanguageString.en, en == null ? "" : en);
            }
            EditEvaluation.runEditEvaluation(executionCourse, evaluationMethodMls);
            evaluationMethod = executionCourse.getEvaluationMethod();
        }
        return mapping.findForward("editEvaluationMethod");
    }

    public ActionForward editEvaluationMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm dynaActionForm = (DynaActionForm)form;
        String evaluationMethod = request.getParameter("evaluationMethod");
        String evaluationMethodEn = dynaActionForm.getString("evaluationMethodEn");
        MultiLanguageString multiLanguageString = new MultiLanguageString();
        multiLanguageString = multiLanguageString.with(MultiLanguageString.pt, evaluationMethod);
        multiLanguageString = multiLanguageString.with(MultiLanguageString.en, evaluationMethodEn);
        ExecutionCourse executionCourse = (ExecutionCourse)((Object)request.getAttribute("executionCourse"));
        EditEvaluation.runEditEvaluation(executionCourse, multiLanguageString);
        return mapping.findForward("evaluationMethod");
    }

    public ActionForward prepareImportEvaluationMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("importContentBean", (Object)new ImportContentBean());
        return mapping.findForward("importEvaluationMethod");
    }

    public ActionForward prepareImportEvaluationMethodPostBack(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.prepareImportContentPostBack(request);
        return mapping.findForward("importEvaluationMethod");
    }

    public ActionForward prepareImportEvaluationMethodInvalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.prepareImportContentInvalid(request);
        return mapping.findForward("importEvaluationMethod");
    }

    public ActionForward listExecutionCoursesToImportEvaluationMethod(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        this.listExecutionCoursesToImportContent(request);
        return mapping.findForward("importEvaluationMethod");
    }

    public ActionForward importEvaluationMethod(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        this.importContent(request, "ImportEvaluationMethod");
        return mapping.findForward("evaluationMethod");
    }
}

