/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.student.thesis;

import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import org.fenixedu.academic.domain.thesis.Thesis;

public class ThesisFileBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title;
    private String subTitle;
    private Locale language;
    private String fileName;
    private Long fileSize;
    private transient InputStream file;

    public ThesisFileBean() {
    }

    public ThesisFileBean(Thesis thesis) {
        this.title = thesis.getFinalTitle().getContent();
        this.subTitle = thesis.getFinalSubtitle() != null ? thesis.getFinalSubtitle().getContent() : null;
        this.language = thesis.getFinalFullTitle().getContentLocale();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public InputStream getFile() {
        return this.file;
    }

    public void setFile(InputStream file) {
        this.file = file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    public Locale getLanguage() {
        return this.language;
    }

    public void setLanguage(Locale language) {
        this.language = language;
    }

    public String getSimpleFileName() {
        String name = this.getFileName();
        if (name == null) {
            return null;
        }
        int separator = name.matches("[\\p{Alpha}]:\\\\.*") ? 92 : 47;
        return name.substring(name.lastIndexOf(separator) + 1);
    }
}

