/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.resourceAllocationManager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.struts.action.ActionError;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.validator.DynaValidatorForm;
import org.fenixedu.academic.domain.ExecutionDegree;
import org.fenixedu.academic.domain.SchoolClass;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.time.calendarStructure.AcademicInterval;
import org.fenixedu.academic.dto.InfoClass;
import org.fenixedu.academic.dto.InfoCurricularYear;
import org.fenixedu.academic.dto.InfoExecutionDegree;
import org.fenixedu.academic.service.services.resourceAllocationManager.ApagarTurma;
import org.fenixedu.academic.service.services.resourceAllocationManager.CriarTurma;
import org.fenixedu.academic.service.services.resourceAllocationManager.DeleteClasses;
import org.fenixedu.academic.ui.struts.action.exceptions.ExistingActionException;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.ExecutionPeriodDA;
import org.fenixedu.academic.ui.struts.action.resourceAllocationManager.base.FenixExecutionDegreeAndCurricularYearContextDispatchAction;
import org.fenixedu.academic.ui.struts.action.utils.ContextUtils;
import org.fenixedu.academic.ui.struts.config.FenixErrorExceptionHandler;
import org.fenixedu.bennu.struts.annotations.ExceptionHandling;
import org.fenixedu.bennu.struts.annotations.Exceptions;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import pt.ist.fenixframework.FenixFramework;

@Mapping(path="/manageClasses", module="resourceAllocationManager", formBean="classForm", input="/manageClasses.do?method=listClasses", functionality=ExecutionPeriodDA.class)
@Forwards(value={@Forward(name="ShowClassList", path="/resourceAllocationManager/manageClasses_bd.jsp")})
@Exceptions(value={@ExceptionHandling(handler=FenixErrorExceptionHandler.class, type=ExistingActionException.class, key="resources.Action.exceptions.ExistingActionException", scope="request")})
public class ManageClassesDA
extends FenixExecutionDegreeAndCurricularYearContextDispatchAction {
    public ActionForward listClasses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AcademicInterval academicInterval = AcademicInterval.getAcademicIntervalFromResumedString((String)request.getAttribute("academicInterval"));
        InfoCurricularYear infoCurricularYear = (InfoCurricularYear)request.getAttribute("curricular_year");
        InfoExecutionDegree infoExecutionDegree = (InfoExecutionDegree)request.getAttribute("execution_degree");
        ExecutionDegree executionDegree = (ExecutionDegree)FenixFramework.getDomainObject((String)infoExecutionDegree.getExternalId());
        Integer curricularYear = infoCurricularYear.getYear();
        Set<SchoolClass> classes = curricularYear != null ? executionDegree.findSchoolClassesByAcademicIntervalAndCurricularYear(academicInterval, curricularYear) : executionDegree.findSchoolClassesByAcademicInterval(academicInterval);
        ArrayList<InfoClass> infoClassesList = new ArrayList<InfoClass>();
        for (SchoolClass schoolClass : classes) {
            InfoClass infoClass = InfoClass.newInfoFromDomain(schoolClass);
            infoClassesList.add(infoClass);
        }
        if (infoClassesList != null && !infoClassesList.isEmpty()) {
            BeanComparator nameComparator = new BeanComparator("nome");
            Collections.sort(infoClassesList, nameComparator);
            request.setAttribute("classes", infoClassesList);
        }
        request.setAttribute("executionDegreeD", (Object)executionDegree);
        return mapping.findForward("ShowClassList");
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm classForm = (DynaValidatorForm)form;
        String className = (String)classForm.get("className");
        InfoCurricularYear infoCurricularYear = (InfoCurricularYear)request.getAttribute("curricular_year");
        InfoExecutionDegree infoExecutionDegree = (InfoExecutionDegree)request.getAttribute("execution_degree");
        AcademicInterval academicInterval = AcademicInterval.getAcademicIntervalFromResumedString((String)request.getAttribute("academicInterval"));
        Integer curricularYear = infoCurricularYear.getYear();
        try {
            CriarTurma.run(className, curricularYear, infoExecutionDegree, academicInterval);
        }
        catch (DomainException e) {
            throw new ExistingActionException((Object)"A SchoolClass", (Throwable)((Object)e));
        }
        return this.listClasses(mapping, form, request, response);
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContextUtils.setClassContext(request);
        InfoClass infoClass = (InfoClass)request.getAttribute("context.classView");
        ApagarTurma.run(infoClass);
        request.removeAttribute("context.classView");
        return this.listClasses(mapping, form, request, response);
    }

    public ActionForward deleteClasses(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaActionForm deleteClassesForm = (DynaActionForm)form;
        String[] selectedClasses = (String[])deleteClassesForm.get("selectedItems");
        if (selectedClasses.length == 0) {
            ActionErrors actionErrors = new ActionErrors();
            actionErrors.add("errors.classes.notSelected", new ActionError("errors.classes.notSelected"));
            this.saveErrors(request, actionErrors);
            return mapping.getInputForward();
        }
        ArrayList<String> classOIDs = new ArrayList<String>();
        for (String selectedClasse : selectedClasses) {
            classOIDs.add(selectedClasse);
        }
        DeleteClasses.run(classOIDs);
        return this.listClasses(mapping, form, request, response);
    }
}

