/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.payments;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.ExecutionYear;
import org.fenixedu.academic.domain.accounting.EventType;
import org.fenixedu.academic.domain.accounting.Installment;
import org.fenixedu.academic.domain.accounting.PaymentPlan;
import org.fenixedu.academic.domain.accounting.PostingRule;
import org.fenixedu.academic.domain.accounting.ServiceAgreementTemplate;
import org.fenixedu.academic.domain.accounting.installments.InstallmentService;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.DFAGratuityByAmountPerEctsPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.DFAGratuityByNumberOfEnrolmentsPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.DFAGratuityPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.SpecializationDegreeGratuityByAmountPerEctsPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.SpecializationDegreeGratuityPR;
import org.fenixedu.academic.domain.accounting.postingRules.gratuity.StandaloneEnrolmentGratuityPR;
import org.fenixedu.academic.domain.administrativeOffice.AdministrativeOffice;
import org.fenixedu.academic.domain.degree.DegreeType;
import org.fenixedu.academic.domain.degree.degreeCurricularPlan.DegreeCurricularPlanState;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.domain.phd.debts.ExternalScholarshipPhdGratuityContribuitionPR;
import org.fenixedu.academic.dto.accounting.paymentPlan.InstallmentBean;
import org.fenixedu.academic.dto.accounting.paymentPlan.PaymentPlanBean;
import org.fenixedu.academic.dto.accounting.paymentPlan.StandaloneInstallmentBean;
import org.fenixedu.academic.dto.accounting.postingRule.CreateDFAGratuityPostingRuleBean;
import org.fenixedu.academic.dto.accounting.postingRule.CreateGratuityPostingRuleBean;
import org.fenixedu.academic.dto.accounting.postingRule.CreateSpecializationDegreeGratuityPostingRuleBean;
import org.fenixedu.academic.dto.accounting.postingRule.CreateStandaloneEnrolmentGratuityPRBean;
import org.fenixedu.academic.service.services.accounting.PostingRulesManager;
import org.fenixedu.academic.service.services.accounting.gratuity.paymentPlan.GratuityPaymentPlanManager;
import org.fenixedu.academic.service.services.commons.FactoryExecutor;
import org.fenixedu.academic.service.services.exceptions.FenixServiceException;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.ui.struts.action.manager.payments.PostingRulesManagementDA$callable$createFCTScolarshipPostingRule;
import org.fenixedu.academic.ui.struts.action.manager.payments.PostingRulesManagementDA$callable$deleteFCTScolarshipPostingRule;
import org.fenixedu.academic.ui.struts.action.manager.payments.PostingRulesManagementDA$callable$editFCTScolarshipPostingRule;
import org.fenixedu.academic.util.Money;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=ManagerApplications.ManagerPaymentsApp.class, path="posting-rules", titleKey="label.payments.postingRules.management")
@Mapping(path="/postingRules", module="manager", formBeanClass=PostingRulesManagementForm.class)
@Forwards(value={@Forward(name="chooseCategory", path="/manager/payments/postingRules/management/chooseCategory.jsp"), @Forward(name="choosePostGraduationDegreeCurricularPlans", path="/manager/payments/postingRules/management/choosePostGraduationDegreeCurricularPlans.jsp"), @Forward(name="showPostGraduationDegreeCurricularPlanPostingRules", path="/manager/payments/postingRules/management/showPostGraduationDegreeCurricularPlanPostingRules.jsp"), @Forward(name="viewPostingRuleDetails", path="/manager/payments/postingRules/management/viewPostingRuleDetails.jsp"), @Forward(name="createDFAGratuityPR", path="/manager/payments/postingRules/management/createDFAGratuityPR.jsp"), @Forward(name="editDFAGratuityPR", path="/manager/payments/postingRules/management/editDFAGratuityPR.jsp"), @Forward(name="editSpecializationDegreeGratuityPR", path="/manager/payments/postingRules/management/specializationDegree/editSpecializationDegreeGratuityPR.jsp"), @Forward(name="editDegreeCurricularPlanPostingRule", path="/manager/payments/postingRules/management/editDegreeCurricularPlanPostingRule.jsp"), @Forward(name="showInsurancePostingRules", path="/manager/payments/postingRules/management/showInsurancePostingRules.jsp"), @Forward(name="editInsurancePR", path="/manager/payments/postingRules/management/editInsurancePR.jsp"), @Forward(name="showGraduationDegreeCurricularPlans", path="/manager/payments/postingRules/management/graduation/showGraduationDegreeCurricularPlans.jsp"), @Forward(name="showPaymentPlans", path="/manager/payments/postingRules/management/graduation/showPaymentPlans.jsp"), @Forward(name="createPaymentPlan", path="/manager/payments/postingRules/management/graduation/createPaymentPlan.jsp"), @Forward(name="createGraduationGratuityPR", path="/manager/payments/postingRules/management/graduation/createGraduationGratuityPR.jsp"), @Forward(name="showGraduationDegreeCurricularPlanPostingRules", path="/manager/payments/postingRules/management/graduation/showGraduationDegreeCurricularPlanPostingRules.jsp"), @Forward(name="createGraduationStandaloneEnrolmentGratuityPR", path="/manager/payments/postingRules/management/graduation/createGraduationStandaloneEnrolmentGratuityPR.jsp"), @Forward(name="createSpecializationDegreeGratuityPR", path="/manager/payments/postingRules/management/specializationDegree/createSpecializationDegreeGratuityPR.jsp"), @Forward(name="createDEAGratuityPR", path="/manager/payments/postingRules/management/dea/createDEAGratuityPR.jsp"), @Forward(name="createDEAStandaloneEnrolmentGratuityPR", path="/manager/payments/postingRules/management/dea/createDEAStandaloneEnrolmentGratuityPR.jsp"), @Forward(name="prepareEditFCTScolarshipPostingRule", path="/manager/payments/postingRules/management/prepareEditFCTScolarshipPostingRule.jsp"), @Forward(name="showFCTScolarshipPostingRules", path="/manager/payments/postingRules/management/showFCTScolarshipPostingRules.jsp"), @Forward(name="prepareAddFCTPostingRule", path="/manager/payments/postingRules/management/prepareAddFCTPostingRule.jsp"), @Forward(name="editInstallment", path="/manager/payments/postingRules/management/graduation/editInstallment.jsp")})
public class PostingRulesManagementDA
extends FenixDispatchAction {
    private static final Predicate<DegreeType> CREATE_GRATUITIES_DEGREE_TYPES;
    public static final Advice advice$createFCTScolarshipPostingRule;
    public static final Advice advice$editFCTScolarshipPostingRule;
    public static final Advice advice$deleteFCTScolarshipPostingRule;

    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward("chooseCategory");
    }

    public ActionForward managePostGraduationRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeCurricularPlans", DegreeCurricularPlan.readByDegreeTypesAndState(DegreeType.oneOf(DegreeType::isAdvancedFormationDiploma, DegreeType::isAdvancedSpecializationDiploma, DegreeType::isSpecializationDegree), DegreeCurricularPlanState.ACTIVE));
        request.setAttribute("phdPrograms", (Object)Bennu.getInstance().getPhdProgramsSet());
        return mapping.findForward("choosePostGraduationDegreeCurricularPlans");
    }

    public ActionForward viewPostingRuleDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        request.setAttribute("postingRule", (Object)this.getPostingRule(request));
        return mapping.findForward("viewPostingRuleDetails");
    }

    protected PostingRule getPostingRule(HttpServletRequest request) {
        return (PostingRule)((Object)this.getDomainObject(request, "postingRuleId"));
    }

    private DegreeCurricularPlan getDegreeCurricularPlan(HttpServletRequest request) {
        return (DegreeCurricularPlan)((Object)this.getDomainObject(request, "degreeCurricularPlanId"));
    }

    public ActionForward prepareEditDegreeCurricularPlanPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PostingRule postingRule = this.getPostingRule(request);
        if (postingRule instanceof DFAGratuityPR) {
            return this.prepareEditDFAGratuityPR(mapping, form, request, response);
        }
        if (postingRule instanceof SpecializationDegreeGratuityPR) {
            return this.prepareEditSpecializationDegreeGratuityPR(mapping, form, request, response);
        }
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        request.setAttribute("postingRule", (Object)postingRule);
        return mapping.findForward("editDegreeCurricularPlanPostingRule");
    }

    public ActionForward prepareEditDegreeCurricularPlanPostingRuleInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        request.setAttribute("postingRule", this.getRenderedObject("postingRule"));
        return mapping.findForward("editDegreeCurricularPlanPostingRule");
    }

    public ActionForward prepareEditDFAGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        PostingRule rule = this.getPostingRule(request);
        if (rule instanceof DFAGratuityByAmountPerEctsPR) {
            request.setAttribute("postingRuleEditor", (Object)DFAGratuityByAmountPerEctsPREditor.buildFrom((DFAGratuityByAmountPerEctsPR)((Object)rule)));
        } else {
            request.setAttribute("postingRuleEditor", (Object)DFAGratuityByNumberOfEnrolmentsPREditor.buildFrom((DFAGratuityByNumberOfEnrolmentsPR)((Object)rule)));
        }
        return mapping.findForward("editDFAGratuityPR");
    }

    public ActionForward prepareEditDFAGratuityPRInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        request.setAttribute("postingRuleEditor", this.getRenderedObject("postingRuleEditor"));
        return mapping.findForward("editDFAGratuityPR");
    }

    public ActionForward editDFAGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeFactoryMethod((FactoryExecutor)this.getRenderedObject("postingRuleEditor"));
            request.setAttribute("degreeCurricularPlanId", (Object)this.getDegreeCurricularPlan(request).getExternalId());
            return this.showPostGraduationDegreeCurricularPlanPostingRules(mapping, form, request, response);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
            request.setAttribute("postingRuleEditor", this.getRenderedObject());
            return mapping.findForward("editDFAGratuityPR");
        }
    }

    public ActionForward prepareEditSpecializationDegreeGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        PostingRule rule = this.getPostingRule(request);
        request.setAttribute("postingRuleEditor", (Object)SpecializationDegreeGratuityByAmountPerEctsPREditor.buildFrom((SpecializationDegreeGratuityByAmountPerEctsPR)((Object)rule)));
        return mapping.findForward("editSpecializationDegreeGratuityPR");
    }

    public ActionForward prepareEditSpecializationDegreeGratuityPRInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        request.setAttribute("postingRuleEditor", this.getRenderedObject("postingRuleEditor"));
        return mapping.findForward("editSpecializationDegreeGratuityPR");
    }

    public ActionForward editSpecializationDegreeGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            this.executeFactoryMethod((FactoryExecutor)this.getRenderedObject("postingRuleEditor"));
            request.setAttribute("degreeCurricularPlanId", (Object)this.getDegreeCurricularPlan(request).getExternalId());
            return this.showPostGraduationDegreeCurricularPlanPostingRules(mapping, form, request, response);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("postingRuleEditor", this.getRenderedObject());
            return mapping.findForward("editDegreeCurricularPlanPostingRule");
        }
    }

    public ActionForward deleteDEAPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            PostingRulesManager.deleteDEAPostingRule(this.getPostingRule(request));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        return this.showPostGraduationDegreeCurricularPlanPostingRules(mapping, form, request, response);
    }

    public ActionForward deleteDegreeCurricularPlanPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            PostingRulesManager.deletePostingRule(this.getPostingRule(request));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        return this.showPostGraduationDegreeCurricularPlanPostingRules(mapping, form, request, response);
    }

    public ActionForward showInsurancePostingRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("postingRules", this.getInsurancePostingRules());
        return mapping.findForward("showInsurancePostingRules");
    }

    private Set<PostingRule> getInsurancePostingRules() {
        return Bennu.getInstance().getInstitutionUnit().getUnitServiceAgreementTemplate().getAllPostingRulesFor(EventType.INSURANCE);
    }

    public ActionForward prepareEditInsurancePR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("postingRule", (Object)this.getPostingRule(request));
        return mapping.findForward("editInsurancePR");
    }

    public ActionForward prepareEditInsurancePRInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("postingRule", this.getRenderedObject("postingRuleEditor"));
        return mapping.findForward("editInsurancePR");
    }

    public ActionForward manageGraduationRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List<DegreeCurricularPlan> degreeCurricularPlans = DegreeCurricularPlan.readByDegreeTypesAndState(type -> true, null);
        DegreeCurricularPlan empty = DegreeCurricularPlan.readEmptyDegreeCurricularPlan();
        if (empty != null) {
            degreeCurricularPlans.add(DegreeCurricularPlan.readEmptyDegreeCurricularPlan());
        }
        request.setAttribute("degreeCurricularPlans", degreeCurricularPlans);
        return mapping.findForward("showGraduationDegreeCurricularPlans");
    }

    public ActionForward showPaymentPlans(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PostingRulesManagementForm postingRulesManagementForm = (PostingRulesManagementForm)form;
        if (postingRulesManagementForm.getExecutionYearId() == null) {
            postingRulesManagementForm.setExecutionYearId(ExecutionYear.readCurrentExecutionYear().getExternalId());
        }
        this.setRequestAttributesToShowPaymentPlans(request, postingRulesManagementForm);
        return mapping.findForward("showPaymentPlans");
    }

    public ActionForward changeExecutionYearForPaymentPlans(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.setRequestAttributesToShowPaymentPlans(request, (PostingRulesManagementForm)form);
        return mapping.findForward("showPaymentPlans");
    }

    private void setRequestAttributesToShowPaymentPlans(HttpServletRequest request, PostingRulesManagementForm form) {
        ExecutionYear executionYear = (ExecutionYear)FenixFramework.getDomainObject((String)form.getExecutionYearId());
        request.setAttribute("executionYears", new ArrayList(rootDomainObject.getExecutionYearsSet()));
        request.setAttribute("paymentPlans", this.getDegreeCurricularPlan(request).getServiceAgreementTemplate().getGratuityPaymentPlansFor(executionYear));
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
    }

    public ActionForward prepareCreatePaymentPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentPlanBean paymentPlanBean = new PaymentPlanBean(ExecutionYear.readCurrentExecutionYear());
        request.setAttribute("paymentPlanEditor", (Object)paymentPlanBean);
        request.setAttribute("installmentEditor", (Object)new InstallmentBean(paymentPlanBean));
        return mapping.findForward("createPaymentPlan");
    }

    public ActionForward prepareCreatePaymentPlanInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("paymentPlanEditor", (Object)this.getPaymentPlanBean());
        request.setAttribute("installmentEditor", (Object)this.getInstallment());
        return mapping.findForward("createPaymentPlan");
    }

    public ActionForward changeExecutionYearForPaymentPlanCreate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("paymentPlanEditor", (Object)this.getPaymentPlanBean());
        request.setAttribute("installmentEditor", (Object)this.getInstallment());
        this.invalidatePaymentPlanViewStates();
        return mapping.findForward("createPaymentPlan");
    }

    public ActionForward addInstallmentInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("paymentPlanEditor", (Object)this.getPaymentPlanBean());
        request.setAttribute("installmentEditor", (Object)this.getInstallment());
        return mapping.findForward("createPaymentPlan");
    }

    public ActionForward addInstallment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        if (!this.getInstallment().hasRequiredInformation()) {
            this.addActionMessage("installment", request, "label.payments.postingRules.paymentPlan.information.to.create.installment.is.all.required");
            return this.addInstallmentInvalid(mapping, form, request, response);
        }
        this.getPaymentPlanBean().addInstallment(this.getInstallment());
        request.setAttribute("paymentPlanEditor", (Object)this.getPaymentPlanBean());
        request.setAttribute("installmentEditor", (Object)new InstallmentBean(this.getPaymentPlanBean()));
        this.invalidatePaymentPlanViewStates();
        return mapping.findForward("createPaymentPlan");
    }

    private void invalidatePaymentPlanViewStates() {
        RenderUtils.invalidateViewState((String)"paymentPlanEditor");
        RenderUtils.invalidateViewState((String)"installmentEditor");
        RenderUtils.invalidateViewState((String)"installmentsEditor");
    }

    private InstallmentBean getInstallment() {
        return (InstallmentBean)this.getRenderedObject("installmentEditor");
    }

    public ActionForward removeInstallments(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        this.getPaymentPlanBean().removeSelectedInstallments();
        request.setAttribute("paymentPlanEditor", (Object)this.getPaymentPlanBean());
        request.setAttribute("installmentEditor", (Object)new InstallmentBean(this.getPaymentPlanBean()));
        this.invalidatePaymentPlanViewStates();
        return mapping.findForward("createPaymentPlan");
    }

    public ActionForward createPaymentPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            GratuityPaymentPlanManager.create(this.getPaymentPlanBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("paymentPlanEditor", (Object)this.getPaymentPlanBean());
            request.setAttribute("installmentEditor", (Object)this.getInstallment());
            return mapping.findForward("createPaymentPlan");
        }
        return this.manageGraduationRules(mapping, form, request, response);
    }

    private PaymentPlanBean getPaymentPlanBean() {
        return (PaymentPlanBean)this.getRenderedObject("paymentPlanEditor");
    }

    private PaymentPlan getPaymentPlan(HttpServletRequest request) {
        return (PaymentPlan)((Object)this.getDomainObject(request, "paymentPlanId"));
    }

    public ActionForward deletePaymentPlan(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            GratuityPaymentPlanManager.delete(this.getPaymentPlan(request));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        this.setRequestAttributesToShowPaymentPlans(request, (PostingRulesManagementForm)form);
        return mapping.findForward("showPaymentPlans");
    }

    public ActionForward prepareCreateGraduationGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createPostingRuleBean", (Object)new CreateGratuityPostingRuleBean());
        return mapping.findForward("createGraduationGratuityPR");
    }

    public ActionForward prepareCreateGraduationGratuityPRInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createPostingRuleBean", this.getRenderedObject("createPostingRuleBean"));
        return mapping.findForward("createGraduationGratuityPR");
    }

    public ActionForward prepareCreateGraduationGratuityPRPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Object object = this.getRenderedObject("createPostingRuleBean");
        RenderUtils.invalidateViewState();
        request.setAttribute("createPostingRuleBean", object);
        return mapping.findForward("createGraduationGratuityPR");
    }

    public ActionForward createGraduationGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreateGratuityPostingRuleBean bean = (CreateGratuityPostingRuleBean)this.getRenderedObject("createPostingRuleBean");
        try {
            PostingRulesManager.createGraduationGratuityPostingRule(bean);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("createPostingRuleBean", (Object)bean);
            return mapping.findForward("createGraduationGratuityPR");
        }
        return this.manageGraduationRules(mapping, form, request, response);
    }

    public ActionForward showPostGraduationDegreeCurricularPlanPostingRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        request.setAttribute("allowCreateGratuityPR", (Object)this.allowCreateGratuityPR(degreeCurricularPlan));
        request.setAttribute("allowCreateStandaloneGratuityPR", (Object)this.allowCreateStandaloneGratuityPR(degreeCurricularPlan));
        request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        return mapping.findForward("showPostGraduationDegreeCurricularPlanPostingRules");
    }

    private boolean allowCreateGratuityPR(DegreeCurricularPlan degreeCurricularPlan) {
        if (!CREATE_GRATUITIES_DEGREE_TYPES.test(degreeCurricularPlan.getDegreeType())) {
            return false;
        }
        return !degreeCurricularPlan.getServiceAgreementTemplate().hasActivePostingRuleFor(EventType.GRATUITY);
    }

    private boolean allowCreateStandaloneGratuityPR(DegreeCurricularPlan degreeCurricularPlan) {
        if (!CREATE_GRATUITIES_DEGREE_TYPES.test(degreeCurricularPlan.getDegreeType())) {
            return false;
        }
        boolean activePRStandalone = degreeCurricularPlan.getServiceAgreementTemplate().hasActivePostingRuleFor(EventType.STANDALONE_ENROLMENT_GRATUITY);
        boolean activePRGratuity = degreeCurricularPlan.getServiceAgreementTemplate().hasActivePostingRuleFor(EventType.GRATUITY);
        return !activePRStandalone && activePRGratuity;
    }

    public ActionForward showGraduationDegreeCurricularPlanPostingRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("degreeCurricularPlan", (Object)this.getDegreeCurricularPlan(request));
        return mapping.findForward("showGraduationDegreeCurricularPlanPostingRules");
    }

    public ActionForward prepareCreateGraduationStandaloneEnrolmentGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreateStandaloneEnrolmentGratuityPRBean bean = new CreateStandaloneEnrolmentGratuityPRBean();
        bean.setRule(StandaloneEnrolmentGratuityPR.class);
        request.setAttribute("createPostingRuleBean", (Object)bean);
        return mapping.findForward("createGraduationStandaloneEnrolmentGratuityPR");
    }

    public ActionForward prepareCreateGraduationStandaloneEnrolmentGratuityPRInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createPostingRuleBean", this.getRenderedObject("createPostingRuleBean"));
        return mapping.findForward("createGraduationStandaloneEnrolmentGratuityPR");
    }

    public ActionForward prepareCreateGraduationStandaloneEnrolmentGratuityPRPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) {
        Object object = this.getRenderedObject("createPostingRuleBean");
        RenderUtils.invalidateViewState();
        request.setAttribute("createPostingRuleBean", object);
        return mapping.findForward("createGraduationStandaloneEnrolmentGratuityPR");
    }

    public ActionForward createGraduationStandaloneEnrolmentGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        CreateStandaloneEnrolmentGratuityPRBean bean = (CreateStandaloneEnrolmentGratuityPRBean)this.getRenderedObject("createPostingRuleBean");
        try {
            PostingRulesManager.createStandaloneGraduationGratuityPostingRule(bean);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            request.setAttribute("createPostingRuleBean", (Object)bean);
            return mapping.findForward("createGraduationStandaloneEnrolmentGratuityPR");
        }
        return this.manageGraduationRules(mapping, form, request, response);
    }

    public ActionForward deleteGraduationDegreeCurricularPlanPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            PostingRulesManager.deletePostingRule(this.getPostingRule(request));
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
        }
        request.setAttribute("degreeCurricularPlanId", (Object)this.getDegreeCurricularPlan(request).getExternalId());
        return this.showGraduationDegreeCurricularPlanPostingRules(mapping, form, request, response);
    }

    public ActionForward prepareCreateDFAGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        request.setAttribute("createDFAGratuityPostingRuleBean", (Object)new CreateDFAGratuityPostingRuleBean((ServiceAgreementTemplate)((Object)degreeCurricularPlan.getServiceAgreementTemplate())));
        return mapping.findForward("createDFAGratuityPR");
    }

    public ActionForward prepareCreateDFAGratuityPRTypeChosen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createDFAGratuityPostingRuleBean", this.getObjectFromViewState("createDFAGratuityPostingRuleBean.chooseType"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("createDFAGratuityPR");
    }

    public ActionForward prepareCreateDFAGratuityPRInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createDFAGratuityPostingRuleBean", (Object)this.getCreateDFAGratuityPostingRuleBeanFromRequest());
        return mapping.findForward("createDFAGratuityPR");
    }

    public ActionForward createDFAGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            PostingRulesManager.createDFAGratuityPostingRule(this.getCreateDFAGratuityPostingRuleBeanFromRequest());
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            request.setAttribute("createDFAGratuityPostingRuleBean", (Object)this.getCreateDFAGratuityPostingRuleBeanFromRequest());
            return mapping.findForward("createDFAGratuityPR");
        }
        request.setAttribute("degreeCurricularPlanId", (Object)this.getCreateDFAGratuityPostingRuleBeanFromRequest().getDegreeCurricularPlan().getExternalId());
        return this.showPostGraduationDegreeCurricularPlanPostingRules(mapping, form, request, response);
    }

    private CreateDFAGratuityPostingRuleBean getCreateDFAGratuityPostingRuleBeanFromRequest() {
        return (CreateDFAGratuityPostingRuleBean)this.getObjectFromViewState("createDFAGratuityPostingRuleBean");
    }

    public ActionForward prepareCreateSpecializationDegreeGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        request.setAttribute("createSpecializationDegreeGratuityPostingRuleBean", (Object)new CreateSpecializationDegreeGratuityPostingRuleBean((ServiceAgreementTemplate)((Object)degreeCurricularPlan.getServiceAgreementTemplate())));
        return mapping.findForward("createSpecializationDegreeGratuityPR");
    }

    public ActionForward prepareCreateSpecializationDegreeGratuityPRTypeChosen(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createSpecializationDegreeGratuityPostingRuleBean", this.getObjectFromViewState("createSpecializationDegreeGratuityPostingRuleBean.chooseType"));
        RenderUtils.invalidateViewState();
        return mapping.findForward("createSpecializationDegreeGratuityPR");
    }

    public ActionForward prepareCreateSpecializationDegreeGratuityPRInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("createSpecializationDegreeGratuityPostingRuleBean", (Object)this.getCreateSpecializationDegreeGratuityPostingRuleBeanFromRequest());
        return mapping.findForward("createSpecializationDegreeGratuityPR");
    }

    public ActionForward createSpecializationDegreeGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        try {
            PostingRulesManager.createSpecializationDegreeGratuityPostingRule(this.getCreateSpecializationDegreeGratuityPostingRuleBeanFromRequest());
        }
        catch (DomainException ex) {
            this.addActionMessage(request, ex.getKey(), ex.getArgs());
            request.setAttribute("createSpecializationDegreeGratuityPostingRuleBean", (Object)this.getCreateSpecializationDegreeGratuityPostingRuleBeanFromRequest());
            return mapping.findForward("createSpecializationDegreeGratuityPR");
        }
        request.setAttribute("degreeCurricularPlanId", (Object)this.getCreateSpecializationDegreeGratuityPostingRuleBeanFromRequest().getDegreeCurricularPlan().getExternalId());
        return this.showPostGraduationDegreeCurricularPlanPostingRules(mapping, form, request, response);
    }

    public ActionForward prepareCreateDEAGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        PaymentPlanBean paymentPlanBean = new PaymentPlanBean(ExecutionYear.readCurrentExecutionYear());
        paymentPlanBean.setMain(true);
        paymentPlanBean.setForAlien(false);
        paymentPlanBean.setForFirstTimeInstitutionStudents(false);
        paymentPlanBean.setForPartialRegime(false);
        paymentPlanBean.setForStudentEnroledOnSecondSemesterOnly(false);
        paymentPlanBean.setDegreeCurricularPlans(Collections.singletonList(degreeCurricularPlan));
        request.setAttribute("paymentPlanEditor", (Object)paymentPlanBean);
        InstallmentBean installmentBean = new InstallmentBean(paymentPlanBean);
        installmentBean.setPenaltyAppliable(false);
        request.setAttribute("installmentEditor", (Object)installmentBean);
        request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        return mapping.findForward("createDEAGratuityPR");
    }

    public ActionForward prepareCreateDEAStandaloneEnrolmentGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        PaymentPlanBean paymentPlanBean = new PaymentPlanBean(ExecutionYear.readCurrentExecutionYear());
        paymentPlanBean.setMain(true);
        paymentPlanBean.setForAlien(false);
        paymentPlanBean.setForFirstTimeInstitutionStudents(false);
        paymentPlanBean.setForPartialRegime(false);
        paymentPlanBean.setForStudentEnroledOnSecondSemesterOnly(false);
        paymentPlanBean.setDegreeCurricularPlans(Collections.singletonList(degreeCurricularPlan));
        request.setAttribute("paymentPlanEditor", (Object)paymentPlanBean);
        StandaloneInstallmentBean installmentBean = new StandaloneInstallmentBean(paymentPlanBean);
        installmentBean.setPenaltyAppliable(false);
        request.setAttribute("installmentEditor", (Object)installmentBean);
        request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        return mapping.findForward("createDEAStandaloneEnrolmentGratuityPR");
    }

    public ActionForward createDEAGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        InstallmentBean installment = this.getInstallment();
        if (!installment.hasRequiredInformation()) {
            this.addActionMessage("installment", request, "label.payments.postingRules.paymentPlan.information.to.create.installment.is.all.required");
            return this.createDEAGratuityPRInvalid(mapping, form, request, response);
        }
        PaymentPlanBean paymentPlanBean = this.getPaymentPlanBean();
        paymentPlanBean.addInstallment(installment);
        try {
            PostingRulesManager.createDEAGratuityPostingRule(this.getPaymentPlanBean());
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getKey(), e.getArgs());
            return this.createDEAGratuityPRInvalid(mapping, form, request, response);
        }
        return this.showPostGraduationDegreeCurricularPlanPostingRules(mapping, form, request, response);
    }

    public ActionForward createDEAStandaloneGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws FenixServiceException {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        InstallmentBean installment = this.getInstallment();
        StandaloneInstallmentBean standaloneInstallment = (StandaloneInstallmentBean)installment;
        if (!installment.hasRequiredInformation()) {
            this.addActionMessage("installment", request, "label.payments.postingRules.paymentPlan.information.to.create.installment.is.all.required");
            return this.createDEAGratuityPRInvalid(mapping, form, request, response);
        }
        try {
            PostingRulesManager.createDEAStandaloneGratuityPostingRule(standaloneInstallment, degreeCurricularPlan);
        }
        catch (DomainException e) {
            PaymentPlanBean paymentPlanEditor = new PaymentPlanBean(ExecutionYear.readCurrentExecutionYear());
            request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
            request.setAttribute("paymentPlanEditor", (Object)paymentPlanEditor);
            request.setAttribute("installmentEditor", (Object)installment);
            this.addActionMessage(request, e.getKey(), e.getArgs());
            return mapping.findForward("createDEAGratuityPR");
        }
        return this.showPostGraduationDegreeCurricularPlanPostingRules(mapping, form, request, response);
    }

    public ActionForward changeExecutionYearForDEAGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        request.setAttribute("paymentPlanEditor", (Object)this.getPaymentPlanBean());
        request.setAttribute("installmentEditor", (Object)this.getInstallment());
        request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createDEAGratuityPR");
    }

    public ActionForward changeExecutionYearForDEAStandaloneGratuityPR(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        request.setAttribute("paymentPlanEditor", (Object)this.getPaymentPlanBean());
        request.setAttribute("installmentEditor", (Object)this.getInstallment());
        request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createDEAStandaloneEnrolmentGratuityPR");
    }

    public ActionForward createDEAGratuityPRInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DegreeCurricularPlan degreeCurricularPlan = this.getDegreeCurricularPlan(request);
        request.setAttribute("paymentPlanEditor", (Object)this.getPaymentPlanBean());
        request.setAttribute("installmentEditor", (Object)this.getInstallment());
        request.setAttribute("degreeCurricularPlan", (Object)degreeCurricularPlan);
        return mapping.findForward("createDEAGratuityPR");
    }

    private CreateSpecializationDegreeGratuityPostingRuleBean getCreateSpecializationDegreeGratuityPostingRuleBeanFromRequest() {
        return (CreateSpecializationDegreeGratuityPostingRuleBean)this.getObjectFromViewState("createSpecializationDegreeGratuityPostingRuleBean");
    }

    public ActionForward showFCTScolarshipPostingRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ArrayList<PostingRule> list = new ArrayList<PostingRule>();
        for (PostingRule postingRule : Bennu.getInstance().getPostingRulesSet()) {
            if (!(postingRule instanceof ExternalScholarshipPhdGratuityContribuitionPR)) continue;
            list.add(postingRule);
        }
        request.setAttribute("list", list);
        return mapping.findForward("showFCTScolarshipPostingRules");
    }

    public ActionForward prepareAddFCTPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        FctScolarshipPostingRuleBean bean = new FctScolarshipPostingRuleBean();
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("prepareAddFCTPostingRule");
    }

    public void createFCTScolarshipPostingRule(FctScolarshipPostingRuleBean fctScolarshipPostingRuleBean) {
        Object object = advice$createFCTScolarshipPostingRule.perform((Callable)new PostingRulesManagementDA$callable$createFCTScolarshipPostingRule(this, fctScolarshipPostingRuleBean));
    }

    static /* synthetic */ void advised$createFCTScolarshipPostingRule(PostingRulesManagementDA this_, FctScolarshipPostingRuleBean bean) {
        ExternalScholarshipPhdGratuityContribuitionPR postingRule = new ExternalScholarshipPhdGratuityContribuitionPR(bean.getStartDate(), bean.getEndDate(), (ServiceAgreementTemplate)((Object)AdministrativeOffice.readMasterDegreeAdministrativeOffice().getServiceAgreementTemplate()));
        postingRule.setRootDomainObject(Bennu.getInstance());
    }

    public ActionForward addFCTScolarshipPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        FctScolarshipPostingRuleBean bean = (FctScolarshipPostingRuleBean)this.getRenderedObject("bean");
        this.createFCTScolarshipPostingRule(bean);
        return this.showFCTScolarshipPostingRules(mapping, form, request, response);
    }

    public ActionForward prepareEditFCTScolarshipPostingRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExternalScholarshipPhdGratuityContribuitionPR postingRule = (ExternalScholarshipPhdGratuityContribuitionPR)FenixFramework.getDomainObject((String)request.getParameter("postingRule"));
        FctScolarshipPostingRuleBean bean = new FctScolarshipPostingRuleBean();
        bean.setStartDate(postingRule.getStartDate());
        bean.setEndDate(postingRule.getEndDate());
        bean.setExternalId(postingRule.getExternalId());
        request.setAttribute("bean", (Object)bean);
        return mapping.findForward("prepareEditFCTScolarshipPostingRule");
    }

    public ActionForward editFCTScolarshipPostingRule(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$editFCTScolarshipPostingRule.perform((Callable)new PostingRulesManagementDA$callable$editFCTScolarshipPostingRule(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$editFCTScolarshipPostingRule(PostingRulesManagementDA this_, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        FctScolarshipPostingRuleBean bean = (FctScolarshipPostingRuleBean)this_.getRenderedObject("bean");
        ExternalScholarshipPhdGratuityContribuitionPR postingRule = (ExternalScholarshipPhdGratuityContribuitionPR)FenixFramework.getDomainObject((String)bean.getExternalId());
        postingRule.setStartDate(bean.getStartDate());
        postingRule.setEndDate(bean.getEndDate());
        return this_.showFCTScolarshipPostingRules(mapping, form, request, response);
    }

    public ActionForward deleteFCTScolarshipPostingRule(ActionMapping actionMapping, ActionForm actionForm, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        return (ActionForward)advice$deleteFCTScolarshipPostingRule.perform((Callable)new PostingRulesManagementDA$callable$deleteFCTScolarshipPostingRule(this, actionMapping, actionForm, httpServletRequest, httpServletResponse));
    }

    static /* synthetic */ ActionForward advised$deleteFCTScolarshipPostingRule(PostingRulesManagementDA this_, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ExternalScholarshipPhdGratuityContribuitionPR postingRule = (ExternalScholarshipPhdGratuityContribuitionPR)FenixFramework.getDomainObject((String)request.getParameter("postingRule"));
        postingRule.delete();
        return this_.showFCTScolarshipPostingRules(mapping, form, request, response);
    }

    public ActionForward prepareEditInstallment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentPlan paymentPlan = (PaymentPlan)((Object)this.getDomainObject(request, "paymentPlanId"));
        Installment installment = (Installment)((Object)this.getDomainObject(request, "installmentId"));
        request.setAttribute("paymentPlan", (Object)paymentPlan);
        request.setAttribute("installment", (Object)installment);
        request.setAttribute("installmentBean", (Object)new InstallmentBean(installment));
        return mapping.findForward("editInstallment");
    }

    public ActionForward editInstallment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Installment installment = (Installment)((Object)this.getDomainObject(request, "installmentId"));
            InstallmentBean bean = (InstallmentBean)this.getRenderedObject("installmentBean");
            InstallmentService.edit(installment, bean);
        }
        catch (DomainException e) {
            this.addErrorMessage(request, "error", e.getKey(), new String[0]);
            return this.editInstallmentInvalid(mapping, form, request, response);
        }
        return this.showPaymentPlans(mapping, form, request, response);
    }

    public ActionForward editInstallmentInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PaymentPlan paymentPlan = (PaymentPlan)((Object)this.getDomainObject(request, "paymentPlanId"));
        Installment installment = (Installment)((Object)this.getDomainObject(request, "installmentId"));
        InstallmentBean bean = (InstallmentBean)this.getRenderedObject("installmentBean");
        request.setAttribute("paymentPlan", (Object)paymentPlan);
        request.setAttribute("installment", (Object)installment);
        request.setAttribute("installmentBean", (Object)bean);
        return mapping.findForward("editInstallment");
    }

    static {
        advice$createFCTScolarshipPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$editFCTScolarshipPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$deleteFCTScolarshipPostingRule = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        CREATE_GRATUITIES_DEGREE_TYPES = DegreeType.oneOf(DegreeType::isAdvancedFormationDiploma, DegreeType::isSpecializationDegree, DegreeType::isAdvancedSpecializationDiploma);
    }

    protected static abstract class SpecializationDegreeGratuityPREditor
    implements FactoryExecutor,
    Serializable {
        private static final long serialVersionUID = -5454487291500203873L;
        private DateTime beginDate;
        private Money specializationDegreeTotalAmount;
        private BigDecimal specializationDegreePartialAcceptedPercentage;
        private SpecializationDegreeGratuityPR specializationDegreeGratuityPR;

        protected SpecializationDegreeGratuityPREditor() {
        }

        public DateTime getBeginDate() {
            return this.beginDate;
        }

        public void setBeginDate(DateTime beginDate) {
            this.beginDate = beginDate;
        }

        public Money getSpecializationDegreeTotalAmount() {
            return this.specializationDegreeTotalAmount;
        }

        public void setSpecializationDegreeTotalAmount(Money specializationDegreeTotalAmount) {
            this.specializationDegreeTotalAmount = specializationDegreeTotalAmount;
        }

        public BigDecimal getSpecializationDegreePartialAcceptedPercentage() {
            return this.specializationDegreePartialAcceptedPercentage;
        }

        public void setSpecializationDegreePartialAcceptedPercentage(BigDecimal specializationDegreePartialAcceptedPercentage) {
            this.specializationDegreePartialAcceptedPercentage = specializationDegreePartialAcceptedPercentage;
        }

        public SpecializationDegreeGratuityPR getSpecializationDegreeGratuityPR() {
            return this.specializationDegreeGratuityPR;
        }

        public void setSpecializationDegreeGratuityPR(SpecializationDegreeGratuityPR specializationDegreeGratuityPR) {
            this.specializationDegreeGratuityPR = specializationDegreeGratuityPR;
        }
    }

    public static class SpecializationDegreeGratuityByAmountPerEctsPREditor
    extends SpecializationDegreeGratuityPREditor {
        private Money specializationDegreeAmountPerEctsCredit;

        private SpecializationDegreeGratuityByAmountPerEctsPREditor() {
        }

        public Money getSpecializationDegreeAmountPerEctsCredit() {
            return this.specializationDegreeAmountPerEctsCredit;
        }

        public void setSpecializationDegreeAmountPerEctsCredit(Money specializationDegreeAmountPerEctsCredit) {
            this.specializationDegreeAmountPerEctsCredit = specializationDegreeAmountPerEctsCredit;
        }

        @Override
        public Object execute() {
            return ((SpecializationDegreeGratuityByAmountPerEctsPR)((Object)this.getSpecializationDegreeGratuityPR())).edit(this.getBeginDate(), this.getSpecializationDegreeTotalAmount(), this.getSpecializationDegreeAmountPerEctsCredit(), this.getSpecializationDegreePartialAcceptedPercentage());
        }

        public static SpecializationDegreeGratuityByAmountPerEctsPREditor buildFrom(SpecializationDegreeGratuityByAmountPerEctsPR rule) {
            SpecializationDegreeGratuityByAmountPerEctsPREditor result = new SpecializationDegreeGratuityByAmountPerEctsPREditor();
            SpecializationDegreeGratuityByAmountPerEctsPREditor.init((SpecializationDegreeGratuityPR)((Object)rule), result);
            result.setSpecializationDegreeAmountPerEctsCredit(rule.getSpecializationDegreeAmountPerEctsCredit());
            return result;
        }

        private static void init(SpecializationDegreeGratuityPR o1, SpecializationDegreeGratuityPREditor o2) {
            o2.setSpecializationDegreeGratuityPR(o1);
            o2.setSpecializationDegreePartialAcceptedPercentage(o1.getSpecializationDegreePartialAcceptedPercentage());
            o2.setSpecializationDegreeTotalAmount(o1.getSpecializationDegreeTotalAmount());
        }
    }

    public static abstract class DFAGratuityPREditor
    implements FactoryExecutor,
    Serializable {
        private static final long serialVersionUID = -5454487291500203873L;
        private DateTime beginDate;
        private Money dfaTotalAmount;
        private BigDecimal dfaPartialAcceptedPercentage;
        private DFAGratuityPR dfaGratuityPR;

        public DateTime getBeginDate() {
            return this.beginDate;
        }

        public void setBeginDate(DateTime beginDate) {
            this.beginDate = beginDate;
        }

        public Money getDfaTotalAmount() {
            return this.dfaTotalAmount;
        }

        public void setDfaTotalAmount(Money dfaTotalAmount) {
            this.dfaTotalAmount = dfaTotalAmount;
        }

        public BigDecimal getDfaPartialAcceptedPercentage() {
            return this.dfaPartialAcceptedPercentage;
        }

        public void setDfaPartialAcceptedPercentage(BigDecimal dfaPartialAcceptedPercentage) {
            this.dfaPartialAcceptedPercentage = dfaPartialAcceptedPercentage;
        }

        public DFAGratuityPR getDfaGratuityPR() {
            return this.dfaGratuityPR;
        }

        public void setDfaGratuityPR(DFAGratuityPR dfaGratuityPR) {
            this.dfaGratuityPR = dfaGratuityPR;
        }
    }

    public static class DFAGratuityByNumberOfEnrolmentsPREditor
    extends DFAGratuityPREditor {
        private DFAGratuityByNumberOfEnrolmentsPREditor() {
        }

        @Override
        public Object execute() {
            return ((DFAGratuityByNumberOfEnrolmentsPR)((Object)this.getDfaGratuityPR())).edit(this.getBeginDate(), this.getDfaTotalAmount(), this.getDfaPartialAcceptedPercentage());
        }

        public static DFAGratuityByNumberOfEnrolmentsPREditor buildFrom(DFAGratuityByNumberOfEnrolmentsPR rule) {
            DFAGratuityByNumberOfEnrolmentsPREditor result = new DFAGratuityByNumberOfEnrolmentsPREditor();
            DFAGratuityByNumberOfEnrolmentsPREditor.init((DFAGratuityPR)((Object)rule), result);
            return result;
        }

        private static void init(DFAGratuityPR o1, DFAGratuityPREditor o2) {
            o2.setDfaGratuityPR(o1);
            o2.setDfaPartialAcceptedPercentage(o1.getDfaPartialAcceptedPercentage());
            o2.setDfaTotalAmount(o1.getDfaTotalAmount());
        }
    }

    public static class DFAGratuityByAmountPerEctsPREditor
    extends DFAGratuityPREditor {
        private Money dfaAmountPerEctsCredit;

        private DFAGratuityByAmountPerEctsPREditor() {
        }

        public Money getDfaAmountPerEctsCredit() {
            return this.dfaAmountPerEctsCredit;
        }

        public void setDfaAmountPerEctsCredit(Money dfaAmountPerEctsCredit) {
            this.dfaAmountPerEctsCredit = dfaAmountPerEctsCredit;
        }

        @Override
        public Object execute() {
            return ((DFAGratuityByAmountPerEctsPR)((Object)this.getDfaGratuityPR())).edit(this.getBeginDate(), this.getDfaTotalAmount(), this.getDfaAmountPerEctsCredit(), this.getDfaPartialAcceptedPercentage());
        }

        public static DFAGratuityByAmountPerEctsPREditor buildFrom(DFAGratuityByAmountPerEctsPR rule) {
            DFAGratuityByAmountPerEctsPREditor result = new DFAGratuityByAmountPerEctsPREditor();
            DFAGratuityByAmountPerEctsPREditor.init((DFAGratuityPR)((Object)rule), result);
            result.setDfaAmountPerEctsCredit(rule.getDfaAmountPerEctsCredit());
            return result;
        }

        private static void init(DFAGratuityPR o1, DFAGratuityPREditor o2) {
            o2.setDfaGratuityPR(o1);
            o2.setDfaPartialAcceptedPercentage(o1.getDfaPartialAcceptedPercentage());
            o2.setDfaTotalAmount(o1.getDfaTotalAmount());
        }
    }

    public static class FctScolarshipPostingRuleBean
    implements Serializable {
        DateTime startDate = new DateTime();
        DateTime endDate;
        String externalId;

        public String getExternalId() {
            return this.externalId;
        }

        public void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        public DateTime getStartDate() {
            return this.startDate;
        }

        public void setStartDate(DateTime startDate) {
            this.startDate = startDate;
        }

        public DateTime getEndDate() {
            return this.endDate;
        }

        public void setEndDate(DateTime endDate) {
            this.endDate = endDate;
        }
    }

    public static class PostingRulesManagementForm
    extends ActionForm {
        private static final long serialVersionUID = 1L;
        private String executionYearId;

        public String getExecutionYearId() {
            return this.executionYearId;
        }

        public void setExecutionYearId(String executionYearId) {
            this.executionYearId = executionYearId;
        }
    }
}

