/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.manager.documents;

import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.documents.GeneratedDocument;
import org.fenixedu.academic.dto.documents.DocumentSearchBean;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.service.services.person.SearchPerson;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.academic.ui.struts.action.manager.ManagerApplications;
import org.fenixedu.academic.util.CollectionPager;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import org.joda.time.ReadablePartial;

@StrutsFunctionality(app=ManagerApplications.ManagerSystemManagementApp.class, path="generated-documents", titleKey="documents.management.title")
@Mapping(path="/generatedDocuments", module="manager")
@Forwards(value={@Forward(name="search", path="/manager/documents/generatedDocuments.jsp")})
public class GeneratedDocumentsDA
extends FenixDispatchAction {
    @EntryPoint
    public ActionForward prepare(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("searchBean", (Object)new DocumentSearchBean());
        request.setAttribute("personBean", (Object)new PersonBean());
        return mapping.findForward("search");
    }

    public ActionForward search(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        SearchPerson.SearchPersonPredicate predicate;
        SearchPerson.SearchParameters parameters;
        DocumentSearchBean searchBean = (DocumentSearchBean)this.getRenderedObject();
        List documents = GenericFile.getFiles(GeneratedDocument.class);
        if (searchBean.hasAddressee()) {
            parameters = new SearchPerson.SearchParameters(searchBean.getAddressee().getName(), null, searchBean.getAddressee().getUsername(), searchBean.getAddressee().getDocumentIdNumber(), null, null, null, null, null, null, null, null);
            predicate = new SearchPerson.SearchPersonPredicate(parameters);
            CollectionPager<Person> persons = SearchPerson.runSearchPerson(parameters, predicate);
            HashSet personDocuments = new HashSet();
            for (Person person : persons.getCollection()) {
                personDocuments.addAll(person.getAddressedDocumentSet());
            }
            documents.retainAll(personDocuments);
        }
        if (searchBean.hasOperator()) {
            parameters = new SearchPerson.SearchParameters(searchBean.getOperator().getName(), null, searchBean.getOperator().getUsername(), searchBean.getOperator().getDocumentIdNumber(), null, null, null, null, null, null, null, null);
            predicate = new SearchPerson.SearchPersonPredicate(parameters);
            CollectionPager<Person> operators = SearchPerson.runSearchPerson(parameters, predicate);
            HashSet operatorDocuments = new HashSet();
            for (Person person : operators.getCollection()) {
                operatorDocuments.addAll(person.getProcessedDocumentSet());
            }
            documents.retainAll(operatorDocuments);
        }
        if (searchBean.getType() != null) {
            HashSet<GeneratedDocument> typed = new HashSet<GeneratedDocument>();
            for (GeneratedDocument document : documents) {
                if (document.getType() != searchBean.getType()) continue;
                typed.add(document);
            }
            documents.retainAll(typed);
        }
        if (searchBean.getCreationDate() != null) {
            HashSet<GeneratedDocument> dated = new HashSet<GeneratedDocument>();
            for (GeneratedDocument document : documents) {
                if (document.getCreationDate().toLocalDate().isBefore((ReadablePartial)searchBean.getCreationDate())) continue;
                dated.add(document);
            }
            documents.retainAll(dated);
        }
        request.setAttribute("searchBean", (Object)searchBean);
        request.setAttribute("documents", (Object)documents);
        return mapping.findForward("search");
    }

    public ActionForward searchPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonBean personBean = (PersonBean)this.getRenderedObject();
        SearchPerson.SearchParameters parameters = new SearchPerson.SearchParameters(personBean.getName(), null, personBean.getUsername(), personBean.getDocumentIdNumber(), null, null, null, null, null, null, null, null);
        SearchPerson.SearchPersonPredicate predicate = new SearchPerson.SearchPersonPredicate(parameters);
        CollectionPager<Person> persons = SearchPerson.runSearchPerson(parameters, predicate);
        request.setAttribute("resultPersons", persons.getCollection());
        request.setAttribute("personBean", (Object)personBean);
        return mapping.findForward("search");
    }

    public ActionForward selectPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = this.getPersonFromParameter(request);
        request.setAttribute("login", (Object)person.getUser());
        request.setAttribute("documents", (Object)person.getAddressedDocumentSet());
        return mapping.findForward("search");
    }

    private Person getPersonFromParameter(HttpServletRequest request) {
        return (Person)((Object)this.getDomainObject(request, "personID"));
    }
}

