/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.externalServices;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.twilio.sdk.TwilioRestClient;
import com.twilio.sdk.TwilioRestException;
import com.twilio.sdk.resource.factory.CallFactory;
import com.twilio.sdk.resource.instance.Account;
import java.io.IOException;
import java.util.HashMap;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.FenixEduAcademicConfiguration;
import org.fenixedu.bennu.core.rest.Healthcheck;
import org.fenixedu.bennu.core.rest.SystemResource;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoneValidationUtils {
    private static final Logger logger = LoggerFactory.getLogger(PhoneValidationUtils.class);
    private String TWILIO_FROM_NUMBER;
    private TwilioRestClient TWILIO_CLIENT;
    private String CIIST_SMS_GATEWAY_URL;
    private HttpClient CIIST_CLIENT;
    private static PhoneValidationUtils instance;

    public static PhoneValidationUtils getInstance() {
        if (instance == null) {
            instance = new PhoneValidationUtils();
        }
        return instance;
    }

    public boolean canRun() {
        return this.TWILIO_CLIENT != null && this.CIIST_CLIENT != null && CoreConfiguration.getConfiguration().developmentMode() == false;
    }

    public boolean shouldRun() {
        Boolean ciistsmsShouldRun = FenixEduAcademicConfiguration.getConfiguration().getCIISTSMSShouldRun();
        return ciistsmsShouldRun != null ? ciistsmsShouldRun : true;
    }

    private void initCIISTSMSGateway() {
        String CIIST_SMS_USERNAME = FenixEduAcademicConfiguration.getConfiguration().getCIISTSMSUsername();
        String CIIST_SMS_PASSWORD = FenixEduAcademicConfiguration.getConfiguration().getCIISTSMSPassword();
        this.CIIST_SMS_GATEWAY_URL = FenixEduAcademicConfiguration.getConfiguration().getCIISTSMSGatewayUrl();
        if (!StringUtils.isEmpty((String)CIIST_SMS_USERNAME) && !StringUtils.isEmpty((String)CIIST_SMS_PASSWORD)) {
            this.CIIST_CLIENT = new HttpClient();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(CIIST_SMS_USERNAME, CIIST_SMS_PASSWORD);
            this.CIIST_CLIENT.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
    }

    private void initTwilio() {
        String TWILIO_SID = FenixEduAcademicConfiguration.getConfiguration().getTwilioSid();
        String TWILIO_STOKEN = FenixEduAcademicConfiguration.getConfiguration().getTwilioStoken();
        final String URL2 = "/2010-04-01/Accounts/" + TWILIO_SID + ".json";
        this.TWILIO_FROM_NUMBER = FenixEduAcademicConfiguration.getConfiguration().getTwilioFromNumber();
        if (!(StringUtils.isEmpty((String)TWILIO_SID) || StringUtils.isEmpty((String)TWILIO_STOKEN) || StringUtils.isEmpty((String)this.TWILIO_FROM_NUMBER))) {
            this.TWILIO_CLIENT = new TwilioRestClient(TWILIO_SID, TWILIO_STOKEN);
            SystemResource.registerHealthcheck((Healthcheck)new Healthcheck(){
                private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

                public String getName() {
                    return "Twilio";
                }

                protected Healthcheck.Result check() throws Exception {
                    JsonElement json = new JsonParser().parse(PhoneValidationUtils.this.TWILIO_CLIENT.get(URL2).getResponseText());
                    return Healthcheck.Result.healthy((String)this.gson.toJson(json));
                }
            });
        }
    }

    private PhoneValidationUtils() {
        this.initTwilio();
        this.initCIISTSMSGateway();
        if (this.canRun()) {
            logger.info("Twilio Initialized:\n\tfrom number {} \n\thost: {} \n", (Object)this.TWILIO_FROM_NUMBER, (Object)CoreConfiguration.getConfiguration().applicationUrl());
            logger.info("DSI SMS Gateway Initialized: {}\n", (Object)this.CIIST_SMS_GATEWAY_URL);
        } else {
            logger.debug("Twilio/DSI SMS Gateway not initialized");
        }
    }

    public boolean makeCall(String phoneNumber, String code, String lang) {
        if (this.canRun()) {
            Account account = this.TWILIO_CLIENT.getAccount();
            CallFactory callFactory = account.getCallFactory();
            HashMap<String, String> callParams = new HashMap<String, String>();
            callParams.put("To", phoneNumber);
            callParams.put("From", this.TWILIO_FROM_NUMBER);
            callParams.put("Url", CoreConfiguration.getConfiguration().applicationUrl() + "/external/partyContactValidation.do?method=validatePhone&code=" + code + "&lang=" + lang);
            try {
                callFactory.create(callParams);
                return true;
            }
            catch (TwilioRestException e) {
                logger.error("Error makeCall: " + e.getMessage(), (Throwable)e);
                return false;
            }
        }
        logger.info("Call to >" + phoneNumber + "<: Bem-vindo ao sistema F\u00e9nix. Introduza o c\u00f3digo " + code + " . Obrigado!");
        return true;
    }

    public boolean sendSMS(String number, String token) {
        block5: {
            number = number.replace(" ", "");
            String message = "Bem-vindo ao sistema Fenix. Introduza o codigo " + token + " . Obrigado!";
            if (this.canRun()) {
                PostMethod method = new PostMethod(this.CIIST_SMS_GATEWAY_URL);
                method.addParameter(new NameValuePair("number", number));
                method.addParameter(new NameValuePair("msg", message));
                try {
                    this.CIIST_CLIENT.executeMethod((HttpMethod)method);
                    if (method.getStatusCode() != 200) {
                        return false;
                    }
                    break block5;
                }
                catch (HttpException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return false;
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            logger.info("SMS to >" + number + "<: " + message);
        }
        return true;
    }
}

