/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.struts.action.accounts;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.fenixedu.academic.domain.Person;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.dto.person.PersonBean;
import org.fenixedu.academic.ui.struts.action.accounts.AccountManagementApp;
import org.fenixedu.academic.ui.struts.action.accounts.ManageAccountsDA$callable$createAccount;
import org.fenixedu.academic.ui.struts.action.accounts.SearchParametersBean;
import org.fenixedu.academic.ui.struts.action.base.FenixDispatchAction;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.struts.annotations.Forward;
import org.fenixedu.bennu.struts.annotations.Forwards;
import org.fenixedu.bennu.struts.annotations.Mapping;
import org.fenixedu.bennu.struts.portal.EntryPoint;
import org.fenixedu.bennu.struts.portal.StrutsFunctionality;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixWebFramework.renderers.utils.RenderUtils;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@StrutsFunctionality(app=AccountManagementApp.class, path="manage-accounts", titleKey="link.accountmanagement.manageaccounts")
@Mapping(path="/accounts/manageAccounts")
@Forwards(value={@Forward(name="manageAccounts", path="/accounts/manageAccounts.jsp"), @Forward(name="createPerson", path="/accounts/createPerson.jsp"), @Forward(name="createPersonFillInfo", path="/accounts/createPersonFillInfo.jsp"), @Forward(name="viewPerson", path="/accounts/viewPerson.jsp")})
public class ManageAccountsDA
extends FenixDispatchAction {
    public static final Advice advice$createAccount = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));

    @EntryPoint
    public ActionForward manageAccounts(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("searchParameters", (Object)new SearchParametersBean());
        return mapping.findForward("manageAccounts");
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        SearchParametersBean parameters = (SearchParametersBean)this.getRenderedObject("searchParameters");
        request.setAttribute("matches", parameters.search());
        return mapping.findForward("manageAccounts");
    }

    public ActionForward prepareCreatePerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("personBean", (Object)new PersonBean());
        return mapping.findForward("createPerson");
    }

    public ActionForward showExistentPersonsWithSameMandatoryDetails(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Collection<Object> results;
        PersonBean bean = (PersonBean)this.getRenderedObject("personBean");
        if (!Strings.isNullOrEmpty((String)bean.getGivenNames()) || !Strings.isNullOrEmpty((String)bean.getFamilyNames())) {
            String name = Stream.of(bean.getGivenNames(), bean.getFamilyNames()).filter(n -> !Strings.isNullOrEmpty((String)n)).collect(Collectors.joining(" "));
            Stream<Person> stream = Person.findPersonStream(name, Integer.MAX_VALUE);
            if (!Strings.isNullOrEmpty((String)bean.getDocumentIdNumber())) {
                stream = stream.filter(p -> p.getDocumentIdNumber().equals(bean.getDocumentIdNumber()));
            }
            results = stream.collect(Collectors.toSet());
        } else {
            results = !Strings.isNullOrEmpty((String)bean.getDocumentIdNumber()) ? Person.findPersonByDocumentID(bean.getDocumentIdNumber()) : Collections.emptySet();
        }
        request.setAttribute("resultPersons", results);
        request.setAttribute("createPerson", (Object)bean);
        return mapping.findForward("createPerson");
    }

    public ActionForward prepareCreatePersonFillInformation(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("personBean", this.getRenderedObject("personBean"));
        return mapping.findForward("createPersonFillInfo");
    }

    public ActionForward createNewPerson(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonBean bean = (PersonBean)this.getRenderedObject();
        try {
            Person person = this.createAccount(bean);
            SearchParametersBean searchParametersBean = new SearchParametersBean();
            searchParametersBean.setUsername(person.getUsername());
            request.setAttribute("searchParameters", (Object)searchParametersBean);
            request.setAttribute("matches", searchParametersBean.search());
            return mapping.findForward("manageAccounts");
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            request.setAttribute("personBean", (Object)bean);
            return mapping.findForward("createPersonFillInfo");
        }
    }

    private Person createAccount(PersonBean personBean) {
        return (Person)((Object)advice$createAccount.perform((Callable)new ManageAccountsDA$callable$createAccount(this, personBean)));
    }

    static /* synthetic */ Person advised$createAccount(ManageAccountsDA this_, PersonBean bean) {
        Person person = new Person(bean);
        if (person.getUser() == null) {
            person.setUser(new User(person.getProfile()));
        }
        person.getAllPendingPartyContacts().forEach(partyContact -> partyContact.setValid());
        return person;
    }

    public ActionForward invalid(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonBean bean = (PersonBean)this.getRenderedObject();
        request.setAttribute("personBean", (Object)bean);
        return mapping.findForward("createPersonFillInfo");
    }

    public ActionForward createNewPersonPostback(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PersonBean bean = (PersonBean)this.getRenderedObject();
        request.setAttribute("personBean", (Object)bean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("createPersonFillInfo");
    }

    public ActionForward viewPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = (Person)((Object)this.getDomainObject(request, "personId"));
        return this.viewPerson(person, mapping, request);
    }

    public ActionForward viewPerson(Person person, ActionMapping mapping, HttpServletRequest request) throws Exception {
        PersonBean personBean = new PersonBean(person);
        request.setAttribute("editPersonalInfo", (Object)false);
        request.setAttribute("person", (Object)person);
        request.setAttribute("personBean", (Object)personBean);
        return mapping.findForward("viewPerson");
    }

    public ActionForward prepareEditPersonalData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Person person = (Person)((Object)this.getDomainObject(request, "personId"));
        PersonBean personBean = new PersonBean(person);
        request.setAttribute("editPersonalInfo", (Object)true);
        request.setAttribute("person", (Object)person);
        request.setAttribute("personBean", (Object)personBean);
        return mapping.findForward("viewPerson");
    }

    public ActionForward editPersonalDataInvalid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = (Person)((Object)this.getDomainObject(request, "personId"));
        PersonBean personBean = (PersonBean)this.getRenderedObject("personBean");
        request.setAttribute("editPersonalInfo", (Object)true);
        request.setAttribute("person", (Object)person);
        request.setAttribute("personBean", (Object)personBean);
        return mapping.findForward("viewPerson");
    }

    public ActionForward editPersonalDataPostback(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = (Person)((Object)this.getDomainObject(request, "personId"));
        PersonBean personBean = (PersonBean)this.getRenderedObject("personBean");
        request.setAttribute("editPersonalInfo", (Object)true);
        request.setAttribute("person", (Object)person);
        request.setAttribute("personBean", (Object)personBean);
        RenderUtils.invalidateViewState();
        return mapping.findForward("viewPerson");
    }

    public ActionForward editPersonalData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Person person = (Person)((Object)this.getDomainObject(request, "personId"));
        PersonBean personBean = (PersonBean)this.getRenderedObject("personBean");
        try {
            personBean.save();
            return this.viewPerson(person, mapping, request);
        }
        catch (DomainException e) {
            this.addActionMessage(request, e.getMessage());
            return this.editPersonalDataInvalid(mapping, form, request, response);
        }
    }
}

