/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.spring.controller;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.academic.domain.exceptions.DomainException;
import org.fenixedu.academic.ui.spring.controller.ManageDepartmentsController$callable$createErrorJson;
import org.fenixedu.academic.ui.spring.controller.manager.DepartmentBean;
import org.fenixedu.academic.ui.spring.controller.manager.DepartmentService;
import org.fenixedu.bennu.core.rest.JsonAwareResource;
import org.fenixedu.bennu.spring.portal.SpringApplication;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringApplication(path="departments", hint="Manager", group="#managers", title="label.manageDepartments")
@SpringFunctionality(app=ManageDepartmentsController.class, title="title.departments")
@RequestMapping(value={"/department-management"})
public class ManageDepartmentsController
extends JsonAwareResource {
    @Autowired
    private DepartmentService departmentService;
    public static final Advice advice$createErrorJson = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping(method={RequestMethod.GET})
    public String list(Model model) {
        return "manager/departments/manageDepartments";
    }

    @RequestMapping(value={"departments.json"})
    @ResponseBody
    public String getDepartmentsSet() {
        return this.view(DepartmentService.getAllDepartments());
    }

    @RequestMapping(value={"/createDepartment"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> addDepartment(@RequestBody String departmentJson) {
        try {
            this.departmentService.addDepartment(this.createDepartmentBeanFromJSON(departmentJson));
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (DomainException dme) {
            return new ResponseEntity((Object)this.createErrorJson(dme.getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
    }

    @RequestMapping(value={"/editDepartment"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> editDepartment(@RequestBody String departmentJson) {
        try {
            this.departmentService.editDepartment(this.createDepartmentBeanFromJSON(departmentJson));
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (DomainException dme) {
            return new ResponseEntity((Object)this.createErrorJson(dme.getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
    }

    @RequestMapping(value={"/deleteDepartment"}, method={RequestMethod.POST})
    @ResponseBody
    public ResponseEntity<String> deleteDepartment(@RequestBody String departmentJson) {
        try {
            this.departmentService.deleteDepartment(this.createDepartmentBeanFromJSON(departmentJson));
            return new ResponseEntity(HttpStatus.OK);
        }
        catch (DomainException dme) {
            return new ResponseEntity((Object)this.createErrorJson(dme.getLocalizedMessage()), HttpStatus.FORBIDDEN);
        }
    }

    private String createErrorJson(String string) {
        return (String)advice$createErrorJson.perform((Callable)new ManageDepartmentsController$callable$createErrorJson(this, string));
    }

    static /* synthetic */ String advised$createErrorJson(ManageDepartmentsController this_, String message) {
        JsonObject object = new JsonObject();
        object.addProperty("message", message);
        return object.toString();
    }

    private DepartmentBean createDepartmentBeanFromJSON(String departmentJson) {
        JsonObject json = (JsonObject)new JsonParser().parse(departmentJson);
        boolean active = json.get("active").getAsBoolean();
        String code = json.get("code").getAsString();
        String name = json.get("name").getAsString();
        String realName = json.get("realName").getAsString();
        String realNameEn = json.get("realNameEn").getAsString();
        String externalId = json.get("externalId") == null ? null : json.get("externalId").getAsString();
        return new DepartmentBean(active, code, name, realName, realNameEn, externalId);
    }
}

