/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.academic.ui.renderers.providers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.academic.domain.DegreeCurricularPlan;
import org.fenixedu.academic.domain.DegreeCurricularPlanEquivalencePlan;
import org.fenixedu.academic.domain.degreeStructure.CourseGroup;
import org.fenixedu.academic.domain.degreeStructure.DegreeModule;
import org.fenixedu.academic.dto.GenericPair;
import org.fenixedu.academic.ui.struts.action.coordinator.EquivalencePlanEntryCreator;
import pt.ist.fenixWebFramework.renderers.DataProvider;
import pt.ist.fenixWebFramework.renderers.components.converters.BiDirectionalConverter;
import pt.ist.fenixWebFramework.renderers.components.converters.Converter;
import pt.ist.fenixframework.FenixFramework;

public class DestinationDegreeModulesPreviousCourseGroupForEquivalencePlanEntryCreatorProvider
implements DataProvider {
    public Object provide(Object source, Object currentValue) {
        ArrayList<CourseGroupPair> result = new ArrayList<CourseGroupPair>();
        for (List<DegreeModule> degreeModules : this.getDegreeCurricularPlan(source).getDcpDegreeModulesIncludingFullPath(CourseGroup.class, null)) {
            result.add(new CourseGroupPair((CourseGroup)((Object)degreeModules.get(degreeModules.size() - 1)), this.buildPath(degreeModules)));
        }
        return result;
    }

    protected DegreeCurricularPlan getDegreeCurricularPlan(Object source) {
        EquivalencePlanEntryCreator equivalencePlanEntryCreator = (EquivalencePlanEntryCreator)source;
        DegreeCurricularPlanEquivalencePlan equivalencePlan = (DegreeCurricularPlanEquivalencePlan)((Object)equivalencePlanEntryCreator.getEquivalencePlan());
        return equivalencePlan.getDegreeCurricularPlan();
    }

    private String buildPath(List<DegreeModule> degreeModules) {
        StringBuilder result = new StringBuilder();
        Iterator<DegreeModule> iterator = degreeModules.iterator();
        while (iterator.hasNext()) {
            DegreeModule degreeModule = iterator.next();
            result.append(degreeModule.getName());
            if (!iterator.hasNext()) continue;
            result.append(" > ");
        }
        return result.toString();
    }

    public Converter getConverter() {
        return new BiDirectionalConverter(){

            public Object convert(Class type, Object value) {
                if (!StringUtils.isEmpty((String)((String)value))) {
                    return FenixFramework.getDomainObject((String)((String)value));
                }
                return null;
            }

            public String deserialize(Object object) {
                if (object == null) {
                    return "";
                }
                CourseGroupPair option = (CourseGroupPair)object;
                return (String)option.getLeft();
            }
        };
    }

    private static class CourseGroupPair
    extends GenericPair<String, String> {
        public CourseGroupPair(CourseGroup courseGroup, String path) {
            super(courseGroup.getExternalId(), path);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CourseGroup) {
                return ((String)this.getLeft()).equals(((CourseGroup)((Object)obj)).getExternalId());
            }
            return false;
        }
    }
}

